/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.RandomUtil;

public class TestUtils {
    public static KylinConfig getTestConfig() {
        return KylinConfig.getInstanceFromEnv();
    }

    public static void writeToFile(File file) {
        try (FileOutputStream fos = new FileOutputStream(file);){
            String info = System.currentTimeMillis() + RandomUtil.randomUUIDStr();
            fos.write(info.getBytes());
            fos.flush();
        }
        catch (IOException e) {
            throw new IllegalStateException("Write file failed: ", e);
        }
    }

    public static boolean isSkipBuild() {
        return Boolean.parseBoolean(System.getProperty("skipBuild", "false"));
    }

    public static boolean isPersistBuild() {
        return Boolean.parseBoolean(System.getProperty("persistBuild", "false"));
    }
}

