/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec.common;

import java.io.Serializable;
import lombok.Generated;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;

public class SmartConfig
implements Serializable {
    private final KapConfig kapConfig;

    private SmartConfig(KapConfig kapConfig) {
        this.kapConfig = kapConfig;
    }

    public static SmartConfig wrap(KylinConfig kylinConfig) {
        return new SmartConfig(KapConfig.wrap((KylinConfig)kylinConfig));
    }

    public KylinConfig getKylinConfig() {
        return this.kapConfig.getKylinConfig();
    }

    private String getOptional(String name, String defaultValue) {
        String val = this.kapConfig.getSmartModelingConf(name);
        if (val == null) {
            return defaultValue;
        }
        return val.trim();
    }

    private long getOptional(String name, long defaultValue) {
        return Long.parseLong(this.getOptional(name, Long.toString(defaultValue)));
    }

    private boolean getOptional(String name, boolean defaultValue) {
        return Boolean.parseBoolean(this.getOptional(name, Boolean.toString(defaultValue)));
    }

    public long getRowkeyUHCCardinalityMin() {
        return this.getOptional("rowkey.uhc.min-cardinality", 1000000L);
    }

    public String getMeasureCountDistinctType() {
        return this.getOptional("measure.count-distinct.return-type", "bitmap");
    }

    public long getComputedColumnOnGroupKeySuggestionMinCardinality() {
        return this.getOptional("computed-column.suggestion.group-key.minimum-cardinality", 10000L);
    }

    public long getComputedColumnOnFilterKeySuggestionMinCardinality() {
        return this.getOptional("computed-column.suggestion.filter-key.minimum-cardinality", 10000L);
    }

    public boolean enableComputedColumnOnFilterKeySuggestion() {
        return Boolean.parseBoolean(this.getOptional("computed-column.suggestion.filter-key.enabled", "FALSE"));
    }

    public boolean needProposeCcIfNoSampling() {
        return this.getOptional("computed-column.suggestion.enabled-if-no-sampling", false);
    }

    public boolean includeAllFks() {
        return this.getOptional("propose-all-foreign-keys", true);
    }

    public String getModelOptRule() {
        return this.getOptional("model-opt-rule", "");
    }

    public boolean skipUselessMetadata() {
        return this.getOptional("skip-useless-metadata", true);
    }

    public String getProposeRunnerImpl() {
        return this.getOptional("propose-runner-type", "fork");
    }

    @Generated
    public KapConfig getKapConfig() {
        return this.kapConfig;
    }
}

