/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.rest.request.ModelRequest;
import org.apache.kylin.rest.request.OpenSqlAccelerateRequest;
import org.apache.kylin.rest.response.OpenAccSqlResponse;
import org.apache.kylin.rest.response.OpenSuggestionResponse;
import org.apache.kylin.rest.response.SuggestAndOptimizedResponse;
import org.apache.kylin.rest.response.SuggestionResponse;
import org.apache.kylin.rest.service.AbstractModelService;
import org.apache.kylin.rest.service.BaseIndexUpdateHelper;
import org.apache.kylin.rest.service.IndexPlanService;
import org.apache.kylin.rest.service.ModelBuildService;
import org.apache.kylin.rest.service.ModelService;
import org.apache.kylin.rest.service.ModelSmartService;
import org.apache.kylin.rest.service.OptRecService;
import org.apache.kylin.rest.service.RawRecService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="modelRecService")
public class ModelRecService
extends AbstractModelService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModelRecService.class);
    @Autowired
    private RawRecService rawRecService;
    @Autowired
    private OptRecService optRecService;
    @Autowired
    private ModelSmartService modelSmartService;
    @Autowired
    private ModelService modelService;
    @Autowired
    private IndexPlanService indexPlanService;
    @Autowired
    @Qualifier(value="modelBuildService")
    private ModelBuildService modelBuildService;
    @Autowired
    public AclEvaluate aclEvaluate;

    @VisibleForTesting
    public void saveRecResult(SuggestionResponse modelSuggestionResponse, String project, String saveIndexesStrategy) {
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            for (SuggestionResponse.ModelRecResponse response : modelSuggestionResponse.getReusedModels()) {
                NDataModelManager modelMgr = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
                NDataModel model = modelMgr.getDataModelDesc(response.getId());
                BaseIndexUpdateHelper baseIndexUpdater = new BaseIndexUpdateHelper(model, "single_dim_and_reduce_hc".equalsIgnoreCase(saveIndexesStrategy));
                modelMgr.updateDataModel(response.getId(), copyForWrite -> {
                    copyForWrite.setJoinTables(response.getJoinTables());
                    copyForWrite.setComputedColumnDescs(response.getComputedColumnDescs());
                    copyForWrite.setAllNamedColumns(response.getAllNamedColumns());
                    copyForWrite.setAllMeasures(response.getAllMeasures());
                });
                NIndexPlanManager indexMgr = NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
                IndexPlan targetIndexPlan = response.getIndexPlan();
                indexMgr.updateIndexPlan(response.getId(), copyForWrite -> {
                    if ("single_dim_and_reduce_hc".equalsIgnoreCase(saveIndexesStrategy)) {
                        this.splitIndexesIntoSingleDimIndexes(model, targetIndexPlan);
                    }
                    copyForWrite.setIndexes(targetIndexPlan.getIndexes());
                });
                baseIndexUpdater.update(this.indexPlanService);
            }
            return null;
        }, (String)project);
    }

    void saveProposedJoinRelations(List<SuggestionResponse.ModelRecResponse> reusedModels, boolean canCreateNewModel, String project) {
        if (!canCreateNewModel) {
            return;
        }
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            for (SuggestionResponse.ModelRecResponse response : reusedModels) {
                NDataModelManager modelMgr = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
                modelMgr.updateDataModel(response.getId(), copyForWrite -> {
                    List newJoinTables = response.getJoinTables();
                    if (newJoinTables.size() != copyForWrite.getJoinTables().size()) {
                        copyForWrite.setJoinTables(newJoinTables);
                        copyForWrite.setAllNamedColumns(response.getAllNamedColumns());
                        copyForWrite.setAllMeasures(response.getAllMeasures());
                        copyForWrite.setComputedColumnDescs(response.getComputedColumnDescs());
                    }
                });
            }
            return null;
        }, (String)project);
    }

    public OpenSuggestionResponse suggestOrOptimizeModels(OpenSqlAccelerateRequest request) {
        SuggestionResponse innerResponse = this.suggestOptimizeModels(request, false);
        return OpenSuggestionResponse.from(innerResponse, request.getSqls());
    }

    public OpenAccSqlResponse suggestAndOptimizeModels(OpenSqlAccelerateRequest request) {
        SuggestionResponse innerResponse = this.suggestOptimizeModels(request, true);
        String modelName = null;
        String modelId = null;
        if (!CollectionUtils.isEmpty((Collection)innerResponse.getNewModels())) {
            modelName = ((SuggestionResponse.ModelRecResponse)innerResponse.getNewModels().get(0)).getAlias();
            modelId = ((SuggestionResponse.ModelRecResponse)innerResponse.getNewModels().get(0)).getUuid();
        } else if (!CollectionUtils.isEmpty((Collection)innerResponse.getReusedModels())) {
            modelName = ((SuggestionResponse.ModelRecResponse)innerResponse.getReusedModels().get(0)).getAlias();
            modelId = ((SuggestionResponse.ModelRecResponse)innerResponse.getReusedModels().get(0)).getUuid();
        } else if (!CollectionUtils.isEmpty((Collection)innerResponse.getOptimalModels())) {
            modelName = ((SuggestionResponse.ModelRecResponse)innerResponse.getOptimalModels().get(0)).getAlias();
            modelId = ((SuggestionResponse.ModelRecResponse)innerResponse.getOptimalModels().get(0)).getUuid();
        }
        OpenAccSqlResponse openAccSqlResponse = OpenAccSqlResponse.from(innerResponse, request.getSqls());
        openAccSqlResponse.setModel(modelName);
        if (request.isNeedBuild()) {
            String project = request.getProject();
            NDataflow df = ((NDataflowManager)this.getManager(NDataflowManager.class, project)).getDataflow(modelId);
            if (df.getSegments().size() == 1) {
                return openAccSqlResponse;
            }
            this.modelBuildService.buildIndicesManually(modelId, project, 3, null, null);
        }
        return openAccSqlResponse;
    }

    public SuggestionResponse suggestOptimizeModels(OpenSqlAccelerateRequest request, boolean createNewModel) {
        SuggestAndOptimizedResponse response = this.modelSmartService.generateSuggestion(request, createNewModel);
        SuggestionResponse suggestionResponse = request.isAcceptRecommendation() ? this.saveModelAndApproveRecommendations(response, request) : this.saveModelAndRecommendations(response, request);
        return suggestionResponse;
    }

    private SuggestionResponse saveModelAndRecommendations(SuggestAndOptimizedResponse response, OpenSqlAccelerateRequest request) {
        SuggestionResponse innerResponse = response.getSuggestionResponse();
        List<ModelRequest> modelRequests = response.getModelRequests();
        boolean canCreateNewModel = response.isCanCreateNewModel();
        String project = response.getProject();
        Set<String> modelIds = response.getModelIds();
        this.modelService.checkNewModels(request.getProject(), modelRequests);
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            if (request.isSaveNewModel()) {
                this.modelService.saveNewModelsAndIndexes(request.getProject(), modelRequests);
            }
            this.saveProposedJoinRelations(innerResponse.getReusedModels(), canCreateNewModel, project);
            this.optRecService.updateRecommendationCount(project, modelIds);
            return null;
        }, (String)request.getProject());
        return innerResponse;
    }

    private SuggestionResponse saveModelAndApproveRecommendations(SuggestAndOptimizedResponse response, OpenSqlAccelerateRequest request) {
        SuggestionResponse innerResponse = response.getSuggestionResponse();
        List<ModelRequest> modelRequests = response.getModelRequests();
        this.modelService.checkNewModels(request.getProject(), modelRequests);
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            this.modelService.saveNewModelsAndIndexes(request.getProject(), request.getAcceptRecommendationStrategy(), modelRequests);
            this.saveRecResult(innerResponse, request.getProject(), request.getAcceptRecommendationStrategy());
            return null;
        }, (String)request.getProject());
        return innerResponse;
    }
}

