/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cache.fs;

import alluxio.client.file.CacheContext;
import alluxio.client.file.cache.CacheManager;
import alluxio.client.file.cache.PageId;
import java.util.BitSet;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagerOfCacheFileContent
implements CacheManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ManagerOfCacheFileContent.class);
    private final CacheManager under;
    private final ConcurrentHashMap<String, FileMeta> fileMetas = new ConcurrentHashMap();

    public boolean put(PageId pageId, byte[] page, CacheContext cacheContext) {
        boolean ok = this.under.put(pageId, page, cacheContext);
        this.markFilePageCached(pageId);
        return ok;
    }

    public int get(PageId pageId, int pageOffset, int bytesToRead, byte[] buffer, int offsetInBuffer, CacheContext cacheContext) {
        int bytesRead = this.under.get(pageId, pageOffset, bytesToRead, buffer, offsetInBuffer, cacheContext);
        if (bytesRead > 0) {
            this.markFilePageCached(pageId);
        }
        return bytesRead;
    }

    public boolean delete(PageId pageId) {
        boolean ok = this.under.delete(pageId);
        this.markFilePageRemoved(pageId);
        return ok;
    }

    public CacheManager.State state() {
        return this.under.state();
    }

    public void close() throws Exception {
        this.under.close();
    }

    public int countCachedPages(String fileId) {
        FileMeta meta = this.fileMetas.get(fileId);
        if (meta == null) {
            return 0;
        }
        return meta.cachedPageIndex.cardinality();
    }

    public long countTotalCachedPages() {
        long sum = 0L;
        for (FileMeta meta : this.fileMetas.values()) {
            sum += (long)meta.cachedPageIndex.cardinality();
        }
        return sum;
    }

    protected void markFilePageCached(PageId pageId) {
        this.fileMetas.compute(pageId.getFileId(), (fileId, fmeta) -> {
            if (fmeta == null) {
                fmeta = new FileMeta((String)fileId);
            }
            fmeta.cachedPageIndex.set((int)pageId.getPageIndex());
            return fmeta;
        });
    }

    protected void markFilePageRemoved(PageId pageId) {
        this.fileMetas.compute(pageId.getFileId(), (fileId, fmeta) -> {
            if (fmeta == null) {
                fmeta = new FileMeta((String)fileId);
            }
            fmeta.cachedPageIndex.clear((int)pageId.getPageIndex());
            return fmeta;
        });
    }

    @Generated
    public ManagerOfCacheFileContent(CacheManager under) {
        this.under = under;
    }

    static class FileMeta {
        final String fileId;
        final long cacheCreateTime = System.currentTimeMillis();
        final BitSet cachedPageIndex = new BitSet();

        @Generated
        public FileMeta(String fileId) {
            this.fileId = fileId;
        }
    }
}

