/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.exception.code;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.kylin.common.util.FileUtils;
import org.apache.kylin.common.util.ResourceUtils;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractErrorContent
implements Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractErrorContent.class);
    private static final long serialVersionUID = 1L;
    static final String CN_LANG = "cn";
    protected final String keCode;

    protected static Map<String, String> loadProperties(String name) throws IOException {
        URL resource = ResourceUtils.getServerConfUrl(name);
        log.info("loading error code msg/suggestion map: {}", (Object)resource.getPath());
        ImmutableMap map = ImmutableMap.copyOf(new ConcurrentHashMap<String, String>(FileUtils.readFromPropertiesFile(resource.openStream())));
        log.info("loading error code msg/suggestion map successful: {}", (Object)resource.getPath());
        return map;
    }

    protected AbstractErrorContent(String keCode) {
        this.keCode = keCode;
    }

    public abstract Map<String, String> getMap();

    public abstract Map<String, String> getDefaultMap();

    public String getLocalizedString() {
        return this.getMap().getOrDefault(this.keCode, "unknown msg");
    }

    public String getString() {
        return this.getDefaultMap().getOrDefault(this.keCode, "unknown msg");
    }

    public String getCodeString() {
        return this.keCode;
    }
}

