/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.discovery;

import java.util.TimeZone;
import java.util.concurrent.locks.Lock;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.transaction.TransactionException;
import org.apache.kylin.common.persistence.transaction.UnitOfWorkParams;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.system.NodeRegistryManager;
import org.apache.kylin.rest.aspect.Transaction;
import org.apache.kylin.rest.discovery.ConditionalOnNodeRegistryJdbcEnabled;
import org.apache.kylin.rest.util.SpringContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@ConditionalOnNodeRegistryJdbcEnabled
@Service
public class NodeRegistryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NodeRegistryService.class);
    private ThreadPoolTaskScheduler scheduler;

    @EventListener(value={ApplicationReadyEvent.class})
    public void initOnApplicationReady(ApplicationReadyEvent event) {
        log.info("NodeRegistryService initOnApplicationReady");
        ((NodeRegistryService)SpringContext.getBean(NodeRegistryService.class)).tryCreateNodeRegistry();
        this.scheduler = new ThreadPoolTaskScheduler();
        this.scheduler.setPoolSize(2);
        this.scheduler.setThreadNamePrefix("NodeRegistryScheduler-");
        this.scheduler.initialize();
        ((NodeRegistryService)SpringContext.getBean(NodeRegistryService.class)).manuallyScheduleTasks();
    }

    public void manuallyScheduleTasks() {
        if (this.scheduler == null) {
            throw new IllegalStateException("scheduler not initialized");
        }
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        String renewCron = config.getServerNodeRegistryJdbcRenewCron();
        String checkCron = config.getServerNodeRegistryJdbcCheckCron();
        this.scheduler.schedule(() -> ((NodeRegistryService)SpringContext.getBean(NodeRegistryService.class)).scheduleRenew(), (Trigger)new CronTrigger(renewCron, TimeZone.getDefault()));
        this.scheduler.schedule(() -> ((NodeRegistryService)SpringContext.getBean(NodeRegistryService.class)).scheduleCheck(), (Trigger)new CronTrigger(checkCron, TimeZone.getDefault()));
    }

    @PreDestroy
    public void preDestroy() {
        log.info("NodeRegistryService preDestroy");
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry((UnitOfWorkParams)UnitOfWorkParams.builder().unitName("_global").projectId("").readonly(false).maxRetry(1).processor(() -> {
            try {
                NodeRegistryManager manager = NodeRegistryManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
                manager.cleanup();
                return null;
            }
            catch (Throwable throwable) {
                throw new TransactionException(throwable);
            }
        }).build());
    }

    public void scheduleRenew() {
        log.debug("Start renew registry");
        ((NodeRegistryService)SpringContext.getBean(NodeRegistryService.class)).renew();
        log.debug("End renew registry");
    }

    public void scheduleCheck() {
        Lock lock = KylinConfig.getInstanceFromEnv().getDistributedLockFactory().lockForCurrentProcess("node-registry-check-lock");
        if (lock.tryLock()) {
            try {
                log.debug("Start check registry");
                ((NodeRegistryService)SpringContext.getBean(NodeRegistryService.class)).check();
                NodeRegistryService.sleep((long)KylinConfig.getInstanceFromEnv().getServerNodeRegistryJdbcCheckIdleTime());
            }
            catch (Exception e) {
                log.warn("Check registry failed", (Throwable)e);
            }
            finally {
                lock.unlock();
                log.debug("End check registry");
            }
        }
    }

    @Transaction
    public void tryCreateNodeRegistry() {
        NodeRegistryManager manager = NodeRegistryManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        try {
            manager.createNodeRegistryIfNotExists();
        }
        catch (PersistenceException e) {
            log.warn("SYSTEM/node_registry is most likely existing");
        }
    }

    @Transaction
    public void renew() {
        NodeRegistryManager manager = NodeRegistryManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        manager.renew();
    }

    @Transaction(retry=1)
    public void check() {
        NodeRegistryManager manager = NodeRegistryManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        manager.checkAndClean();
    }

    private static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            log.warn("Thread sleeping was interrupted");
            Thread.currentThread().interrupt();
        }
    }
}

