/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.rest.cluster.ClusterManager;
import org.apache.kylin.rest.cluster.NacosClusterManager;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.ServerInfoResponse;
import org.apache.kylin.rest.util.SpringContext;
import org.apache.kylin.tool.restclient.RestClient;
import org.apache.kylin.tool.util.ToolUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;

public class ConfTool {
    private static final Logger logger = LoggerFactory.getLogger((String)"diag");
    private static final Set<String> KYLIN_BIN_INCLUSION = Sets.newHashSet((Object[])new String[]{"kylin.sh"});

    private ConfTool() {
    }

    public static void extractK8sConf(HttpHeaders headers, File exportDir, String targetServerId) {
        try {
            File confFolder = new File(exportDir, "conf");
            FileUtils.forceMkdir((File)confFolder);
            ClusterManager clusterManager = (ClusterManager)SpringContext.getApplicationContext().getBean(ClusterManager.class);
            for (String serverId : NacosClusterManager.SERVER_IDS) {
                ServerInfoResponse server;
                if (targetServerId != null && !serverId.equals(targetServerId) || (server = clusterManager.getServerById(serverId)) == null) continue;
                Properties properties = ConfTool.fetchConf(headers, server.getHost());
                File propertiesFile = new File(confFolder, serverId + ".kylin.properties");
                if (!propertiesFile.createNewFile()) continue;
                FileOutputStream conf = new FileOutputStream(propertiesFile);
                Throwable throwable = null;
                try {
                    properties.store(conf, "");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (conf == null) continue;
                    if (throwable != null) {
                        try {
                            conf.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    conf.close();
                }
            }
        }
        catch (Exception e) {
            logger.warn("Failed to copy /conf, ", (Throwable)e);
        }
    }

    public static Properties fetchConf(HttpHeaders headers, String host) throws IOException {
        RestClient client = new RestClient(host);
        HttpResponse response = client.forwardGet(headers, "/config/all", false);
        String content = EntityUtils.toString((HttpEntity)response.getEntity());
        Properties properties = new Properties();
        if (content != null) {
            properties.putAll((Map<?, ?>)((Map)((EnvelopeResponse)JsonUtil.readValue((String)content, EnvelopeResponse.class)).getData()));
        }
        return properties;
    }

    public static void extractConf(File exportDir) {
        try {
            File confDir = new File(ToolUtil.getConfFolder());
            if (confDir.exists()) {
                FileUtils.copyDirectoryToDirectory((File)confDir, (File)exportDir);
            } else {
                logger.error("Can not find the /conf dir: {}!", (Object)confDir.getAbsolutePath());
            }
        }
        catch (Exception e) {
            logger.warn("Failed to copy /conf, ", (Throwable)e);
        }
    }

    public static void extractHadoopConf(File exportDir) {
        try {
            File hadoopConfDir = new File(ToolUtil.getHadoopConfFolder());
            if (hadoopConfDir.exists()) {
                FileUtils.copyDirectoryToDirectory((File)hadoopConfDir, (File)exportDir);
            } else {
                logger.error("Can not find the hadoop_conf: {}!", (Object)hadoopConfDir.getAbsolutePath());
            }
            KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
            String buildHadoopConf = kylinConfig.getBuildConf();
            if (StringUtils.isNotEmpty((CharSequence)buildHadoopConf)) {
                File buildHadoopConfDir = new File(buildHadoopConf);
                if (buildHadoopConfDir.exists()) {
                    FileUtils.copyDirectoryToDirectory((File)buildHadoopConfDir, (File)exportDir);
                } else {
                    logger.error("Can not find the write hadoop_conf: {}!", (Object)buildHadoopConfDir.getAbsolutePath());
                }
            }
        }
        catch (Exception e) {
            logger.error("Failed to copy /hadoop_conf, ", (Throwable)e);
        }
    }

    public static void extractBin(File exportDir) {
        File destBinDir = new File(exportDir, "bin");
        try {
            File[] binFiles;
            FileUtils.forceMkdir((File)destBinDir);
            File srcBinDir = new File(ToolUtil.getBinFolder());
            if (srcBinDir.exists() && null != (binFiles = srcBinDir.listFiles())) {
                for (File binFile : binFiles) {
                    String binFileName = binFile.getName();
                    if (!KYLIN_BIN_INCLUSION.contains(binFileName)) continue;
                    Files.copy(binFile.toPath(), new File(destBinDir, binFile.getName()).toPath(), new CopyOption[0]);
                    logger.info("copy file: {} {}", (Object)binFiles, (Object)destBinDir);
                }
            }
        }
        catch (Exception e) {
            logger.error("Failed to export bin.", (Throwable)e);
        }
    }
}

