/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.pretty.SqlPrettyWriter;
import org.apache.calcite.sql.validate.SqlValidatorException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.NativeQueryRealization;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.QueryTrace;
import org.apache.kylin.common.debug.BackdoorToggles;
import org.apache.kylin.common.exception.BigQueryException;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.KylinTimeoutException;
import org.apache.kylin.common.exception.NewQueryRefuseException;
import org.apache.kylin.common.exception.ResourceLimitExceededException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.exception.code.ErrorCodeSystem;
import org.apache.kylin.common.hystrix.NCircuitBreaker;
import org.apache.kylin.common.msg.Message;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.scheduler.EventBusFactory;
import org.apache.kylin.common.scheduler.SchedulerEventNotifier;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.common.util.CheckUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.engine.spark.filter.BloomFilterSkipCollector;
import org.apache.kylin.engine.spark.filter.ParquetPageFilterCollector;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.base.Joiner;
import org.apache.kylin.guava30.shaded.common.collect.Collections2;
import org.apache.kylin.guava30.shaded.common.collect.HashMultimap;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMap;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.SetMultimap;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.metadata.Manager;
import org.apache.kylin.metadata.acl.AclTCR;
import org.apache.kylin.metadata.acl.AclTCRManager;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.model.FusionModelManager;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.model.tool.CalciteParser;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.query.BigQueryThresholdUpdater;
import org.apache.kylin.metadata.query.QueryHistory;
import org.apache.kylin.metadata.query.QueryHistorySql;
import org.apache.kylin.metadata.query.QueryHistorySqlParam;
import org.apache.kylin.metadata.query.QueryMetrics;
import org.apache.kylin.metadata.query.QueryMetricsContext;
import org.apache.kylin.metadata.query.QueryRecord;
import org.apache.kylin.metadata.query.StructField;
import org.apache.kylin.metadata.query.util.QueryHistoryUtil;
import org.apache.kylin.metadata.querymeta.ColumnMeta;
import org.apache.kylin.metadata.querymeta.ColumnMetaWithType;
import org.apache.kylin.metadata.querymeta.SelectedColumnMeta;
import org.apache.kylin.metadata.querymeta.TableMeta;
import org.apache.kylin.metadata.querymeta.TableMetaWithType;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.NoRealizationFoundException;
import org.apache.kylin.metadata.realization.RoutingIndicatorException;
import org.apache.kylin.query.blacklist.SQLBlacklistItem;
import org.apache.kylin.query.blacklist.SQLBlacklistManager;
import org.apache.kylin.query.calcite.KEDialect;
import org.apache.kylin.query.engine.PrepareSqlStateParam;
import org.apache.kylin.query.engine.QueryExec;
import org.apache.kylin.query.engine.QueryRoutingEngine;
import org.apache.kylin.query.engine.SchemaMetaData;
import org.apache.kylin.query.engine.data.QueryResult;
import org.apache.kylin.query.engine.data.TableSchema;
import org.apache.kylin.query.exception.NotSupportedSQLException;
import org.apache.kylin.query.exception.UserStopQueryException;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.util.EscapeDialect;
import org.apache.kylin.query.util.PrepareSQLUtils;
import org.apache.kylin.query.util.QueryModelPriorities;
import org.apache.kylin.query.util.QueryParams;
import org.apache.kylin.query.util.QueryUtil;
import org.apache.kylin.query.util.RawSql;
import org.apache.kylin.query.util.RawSqlParser;
import org.apache.kylin.query.util.SlowQueryDetector;
import org.apache.kylin.query.util.TokenMgrError;
import org.apache.kylin.query.util.WhiteSpaceParser;
import org.apache.kylin.rest.config.AppConfig;
import org.apache.kylin.rest.model.Query;
import org.apache.kylin.rest.request.PrepareSqlRequest;
import org.apache.kylin.rest.request.QueryDetectRequest;
import org.apache.kylin.rest.request.SQLRequest;
import org.apache.kylin.rest.response.BigQueryResponse;
import org.apache.kylin.rest.response.QueryDetectResponse;
import org.apache.kylin.rest.response.SQLResponse;
import org.apache.kylin.rest.response.SQLResponseTrace;
import org.apache.kylin.rest.response.TableMetaCacheResult;
import org.apache.kylin.rest.response.TableMetaCacheResultV2;
import org.apache.kylin.rest.security.MutableAclRecord;
import org.apache.kylin.rest.service.AccessService;
import org.apache.kylin.rest.service.AclTCRServiceSupporter;
import org.apache.kylin.rest.service.AsyncQueryJob;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.CacheSignatureQuerySupporter;
import org.apache.kylin.rest.service.CommonQueryCacheSupporter;
import org.apache.kylin.rest.service.QueryCacheManager;
import org.apache.kylin.rest.service.QueryHistoryScheduler;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.rest.util.AclPermissionUtil;
import org.apache.kylin.rest.util.QueryCacheSignatureUtil;
import org.apache.kylin.rest.util.QueryRequestLimits;
import org.apache.kylin.rest.util.QueryUtils;
import org.apache.kylin.rest.util.SparderUIUtil;
import org.apache.kylin.rest.util.TableauInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;

@Component(value="queryService")
public class QueryService
extends BasicService
implements CacheSignatureQuerySupporter {
    private static final String JDBC_METADATA_SCHEMA = "metadata";
    private static final Logger logger = LoggerFactory.getLogger((String)"query");
    final SlowQueryDetector slowQueryDetector = new SlowQueryDetector();
    @Autowired
    private QueryCacheManager queryCacheManager;
    @Autowired
    protected AclEvaluate aclEvaluate;
    @Autowired
    private AccessService accessService;
    @Autowired
    private AppConfig appConfig;
    @Autowired
    @Qualifier(value="aclTCRService")
    private AclTCRServiceSupporter aclTCRService;
    protected QueryRoutingEngine queryRoutingEngine;
    @Autowired
    @Qualifier(value="sparderUIUtil")
    private SparderUIUtil sparderUIUtil;

    public QueryService() {
        this.slowQueryDetector.start();
        this.queryRoutingEngine = new QueryRoutingEngine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLResponse query(SQLRequest sqlRequest) throws Exception {
        try {
            this.slowQueryDetector.queryStart(sqlRequest.getStopId());
            this.markHighPriorityQueryIfNeeded();
            QueryParams queryParams = new QueryParams(NProjectManager.getProjectConfig((String)sqlRequest.getProject()), sqlRequest.getSql(), sqlRequest.getProject(), sqlRequest.getLimit().intValue(), sqlRequest.getOffset().intValue(), true, sqlRequest.getExecuteAs());
            queryParams.setForcedToPushDown(sqlRequest.isForcedToPushDown());
            queryParams.setForcedToIndex(sqlRequest.isForcedToIndex());
            queryParams.setPrepareStatementWithParams(QueryUtils.isPrepareStatementWithParams(sqlRequest));
            queryParams.setPartialMatchIndex(sqlRequest.isPartialMatchIndex());
            queryParams.setAcceptPartial(sqlRequest.isAcceptPartial());
            queryParams.setSelect(true);
            if (queryParams.isPrepareStatementWithParams()) {
                queryParams.setPrepareSql(PrepareSQLUtils.fillInParams((String)queryParams.getSql(), (PrepareSqlStateParam[])((PrepareSqlRequest)sqlRequest).getParams()));
                queryParams.setParams(((PrepareSqlRequest)sqlRequest).getParams());
            }
            queryParams.setAclInfo(this.getExecuteAclInfo(queryParams.getProject(), queryParams.getExecuteAs()));
            queryParams.setACLDisabledOrAdmin(this.isACLDisabledOrAdmin(queryParams.getProject(), queryParams.getAclInfo()));
            QueryContext.current().setForceTableIndex(queryParams.isForcedToIndex());
            if (QueryContext.current().getQueryTagInfo().isAsyncQuery() && NProjectManager.getProjectConfig((String)sqlRequest.getProject()).isUniqueAsyncQueryYarnQueue()) {
                logger.info("This query is an async query in project: {}", (Object)sqlRequest.getProject());
                if (StringUtils.isNotEmpty((CharSequence)sqlRequest.getSparkQueue())) {
                    queryParams.setSparkQueue(sqlRequest.getSparkQueue());
                }
                AsyncQueryJob asyncQueryJob = new AsyncQueryJob();
                asyncQueryJob.setProject(queryParams.getProject());
                this.slowQueryDetector.addJobIdForAsyncQueryJob(asyncQueryJob.getId());
                ExecuteResult result = asyncQueryJob.submit(queryParams);
                if (!result.succeed()) {
                    throw (Exception)result.getThrowable();
                }
                SQLResponse sQLResponse = this.buildSqlResponse(false, Collections.emptyList(), 0, Lists.newArrayList(), sqlRequest.getProject());
                return sQLResponse;
            }
            SQLResponse fakeResponse = TableauInterceptor.tableauIntercept(queryParams.getSql());
            if (null != fakeResponse) {
                logger.debug("Return fake response, is exception? {}", (Object)fakeResponse.isException());
                fakeResponse.setEngineType(QueryHistory.EngineType.CONSTANTS.name());
                QueryContext.current().getQueryTagInfo().setConstantQuery(true);
                QueryContext.currentTrace().startSpan("SPARK_JOB_EXECUTION");
                SQLResponse result = fakeResponse;
                return result;
            }
            QueryResult result = this.queryRoutingEngine.queryWithSqlMassage(queryParams);
            if (!QueryContext.current().getQueryTagInfo().isAsyncQuery()) {
                QueryContext.current().getMetrics().setResultRowCount((long)result.getSize());
            }
            SQLResponse sQLResponse = this.buildSqlResponse(QueryContext.current().getQueryTagInfo().isPushdown(), result.getRowsIterable(), result.getSize(), result.getColumnMetas(), sqlRequest.getProject());
            return sQLResponse;
        }
        finally {
            this.slowQueryDetector.queryEnd();
            Thread.interrupted();
        }
    }

    public void stopQuery(String id) {
        this.slowQueryDetector.stopQuery(id);
    }

    private void markHighPriorityQueryIfNeeded() {
        String vipRoleName = KylinConfig.getInstanceFromEnv().getQueryVIPRole();
        if (!StringUtils.isBlank((CharSequence)vipRoleName) && SecurityContextHolder.getContext().getAuthentication().getAuthorities().contains(new SimpleGrantedAuthority(vipRoleName))) {
            QueryContext.current().getQueryTagInfo().setHighPriorityQuery(true);
        }
    }

    public void saveQuery(String creator, String project, Query query) {
        this.aclEvaluate.checkProjectQueryPermission(project);
        UnitOfWork.doInTransactionWithRetry(() -> {
            Message msg = MsgPicker.getMsg();
            Manager manager = Manager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project, QueryRecord.class);
            manager.upsert(QueryRecord.generateResourceName((String)project, (String)creator), copyForWrite -> {
                List currentQueries = copyForWrite.getQueries();
                if (currentQueries.stream().map(Query::getName).collect(Collectors.toSet()).contains(query.getName())) {
                    throw new KylinException((ErrorCodeSupplier)ServerErrorCode.SAVE_QUERY_FAILED, String.format(Locale.ROOT, msg.getDuplicateQueryName(), query.getName()));
                }
                currentQueries.add(query);
            }, () -> new QueryRecord(project, creator));
            return null;
        }, (String)project);
    }

    public void removeSavedQuery(String creator, String project, String id) {
        this.aclEvaluate.checkProjectQueryPermission(project);
        UnitOfWork.doInTransactionWithRetry(() -> {
            Manager manager = Manager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project, QueryRecord.class);
            manager.update(QueryRecord.generateResourceName((String)project, (String)creator), copyForWrite -> copyForWrite.setQueries(copyForWrite.getQueries().stream().filter(q -> !q.getId().equals(id)).collect(Collectors.toList())));
            return null;
        }, (String)project);
    }

    public QueryRecord getSavedQueries(String creator, String project) {
        this.aclEvaluate.checkProjectQueryPermission(project);
        if (null == creator) {
            return null;
        }
        Manager manager = Manager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project, QueryRecord.class);
        return manager.get(QueryRecord.generateResourceName((String)project, (String)creator)).orElse(new QueryRecord(project, creator));
    }

    public String logQuery(SQLRequest request, SQLResponse response) {
        Collection snapShotFilters;
        Collection snapShots;
        String sql;
        String user = this.aclEvaluate.getCurrentUserName();
        Collection modelNames = Lists.newArrayList();
        Collection layoutIds = Lists.newArrayList();
        Collection isPartialMatchModel = Lists.newArrayList();
        float duration = (float)response.getDuration() / 1000.0f;
        if (CollectionUtils.isNotEmpty(response.getNativeRealizations())) {
            modelNames = response.getNativeRealizations().stream().map(NativeQueryRealization::getModelAlias).collect(Collectors.toList());
            layoutIds = Collections2.transform(response.getNativeRealizations(), realization -> String.valueOf(realization.getLayoutId()));
            isPartialMatchModel = Collections2.transform(response.getNativeRealizations(), realization -> String.valueOf(realization.isPartialMatchModel()));
        }
        int resultRowCount = 0;
        if (!response.isException() && response.getResults() != null) {
            resultRowCount = (int)response.getResultRowCount();
        }
        if (StringUtils.isEmpty((CharSequence)(sql = QueryContext.current().getUserSQL()))) {
            sql = request.getSql();
        }
        if (response.getNativeRealizations() == null) {
            snapShots = Lists.newArrayList();
            snapShotFilters = Lists.newArrayList();
        } else {
            snapShots = response.getNativeRealizations().stream().flatMap(nativeQueryRealization -> nativeQueryRealization.getLookupTables().stream()).distinct().collect(Collectors.toList());
            snapShotFilters = ContextUtil.listContexts().stream().flatMap(ctx -> ctx.getFilterColumns().stream().filter(col -> snapShots.contains(col.getTable())).map(TblColRef::getCanonicalName)).collect(Collectors.toList());
        }
        boolean isDerived = !snapShots.isEmpty() && layoutIds.stream().anyMatch(id -> !StringUtils.equals((CharSequence)"-1", (CharSequence)id));
        String errorMsg = response.getExceptionMessage();
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            int maxLength = 5000;
            errorMsg = errorMsg.length() > maxLength ? errorMsg.substring(0, maxLength) : errorMsg;
        }
        BloomFilterSkipCollector.logAndCleanStatus((String)QueryContext.current().getQueryId());
        ParquetPageFilterCollector.logParquetPages((String)QueryContext.current().getQueryId());
        QueryContext.current().record("end");
        QueryContext.current().setResponseStartTime(System.currentTimeMillis());
        LogReport report = new LogReport().put("id", QueryContext.current().getQueryId()).put("sql", sql).put("user", user).put("success", null == response.getExceptionMessage()).put("duration", Float.valueOf(duration)).put("project", request.getProject()).put("realization", modelNames).put("layout", layoutIds).put("is_partial_match", isPartialMatchModel).put("scan_rows", response.getScanRows()).put("total_scan_rows", response.getTotalScanRows()).put("is_derived", isDerived).put("snapshots", snapShots).put("snapshot_filters", snapShotFilters).put("scan_bytes", response.getScanBytes()).put("total_scan_bytes", response.getTotalScanBytes()).put("result_row_count", resultRowCount).put("shuffle_partitions", response.getShufflePartitions()).put("accept_partial", request.isAcceptPartial()).put("is_partial_result", response.isPartial()).put("hit_exception_cache", response.isHitExceptionCache()).put("storage_cache_used", response.isStorageCacheUsed()).put("storage_cache_type", response.getStorageCacheType()).put("data_fetch_time", response.getDataFetchTime()).put("push_down", response.isQueryPushDown()).put("is_prepare", response.isPrepare()).put("timeout", response.isTimeout()).put("timeline_schema", QueryContext.current().getSchema()).put("timeline", QueryContext.current().getTimeLine()).put("error_msg", errorMsg).put("user_defined_tag", request.getUser_defined_tag()).put("push_down_forced", request.isForcedToPushDown()).put("index_forced", request.isForcedToIndex()).put("user_agent", request.getUserAgent()).put("back_door_toggles", request.getBackdoorToggles()).put("scan_segment_count", QueryContext.current().getMetrics().getSegCount()).put("scan_file_count", QueryContext.current().getMetrics().getFileCount()).put("refuse", response.isRefused());
        String log = report.oldStyleLog();
        if (!QueryContext.current().getQueryTagInfo().isAsyncQuery() || !NProjectManager.getProjectConfig((String)request.getProject()).isUniqueAsyncQueryYarnQueue()) {
            logger.info(log);
            logger.debug(report.jsonStyleLog());
            if (request.getExecuteAs() != null) {
                logger.info("[EXECUTE AS USER]: User [{}] executes the sql as user [{}].", (Object)user, (Object)request.getExecuteAs());
            }
        }
        return log;
    }

    public BigQueryResponse ifBigQuery(SQLRequest sqlRequest) {
        String isBigQuery;
        SQLResponse sqlResponse = this.queryWithCache(sqlRequest);
        BigQueryResponse bigQueryResponse = new BigQueryResponse();
        String string = isBigQuery = sqlResponse.isBigQuery() ? "bigQuery" : "nonBigQuery";
        if (sqlRequest.isForcedToPushDown() || sqlResponse.isException() || sqlResponse.isQueryPushDown()) {
            isBigQuery = "others";
        }
        if (sqlResponse.isException()) {
            bigQueryResponse.setException(true);
            bigQueryResponse.setExceptionMessage(sqlResponse.getExceptionMessage());
        }
        bigQueryResponse.setCache(sqlResponse.isStorageCacheUsed());
        bigQueryResponse.setIfBigQuery(isBigQuery);
        bigQueryResponse.setScanRows(sqlResponse.getTotalScanRows());
        return bigQueryResponse;
    }

    /*
     * Exception decompiling
     */
    public SQLResponse queryWithCache(SQLRequest sqlRequest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkIfExecuteUserValid(SQLRequest sqlRequest) {
        List grantedProjects;
        String executeUser = sqlRequest.getExecuteAs();
        if (executeUser == null) {
            return;
        }
        if (!KylinConfig.getInstanceFromEnv().isExecuteAsEnabled()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, MsgPicker.getMsg().getExecuteAsNotEnabled());
        }
        AclTCRManager aclTCRManager = AclTCRManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)sqlRequest.getProject());
        String username = AclPermissionUtil.getCurrentUsername();
        Set groups = this.getCurrentUserGroups();
        if (!AclPermissionUtil.hasProjectAdminPermission((String)sqlRequest.getProject(), (Set)groups) && !aclTCRManager.isAllTablesAuthorized(username, groups)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, String.format(Locale.ROOT, MsgPicker.getMsg().getServiceAccountNotAllowed(), username, sqlRequest.getProject()));
        }
        try {
            grantedProjects = this.accessService.getGrantedProjectsOfUser(executeUser);
        }
        catch (IOException e) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.ACCESS_DENIED, (Throwable)e);
        }
        if (!grantedProjects.contains(sqlRequest.getProject())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.ACCESS_DENIED, "Access is denied.");
        }
        boolean isDataPermissionDefaultEnabled = KylinConfig.getInstanceFromEnv().isDataPermissionDefaultEnabled();
        if (isDataPermissionDefaultEnabled) {
            try {
                Set extPermissions = this.accessService.getUserNormalExtPermissionsByUserInProject(sqlRequest.getProject(), executeUser);
                if (!extPermissions.contains("DATA_QUERY")) {
                    throw new KylinException((ErrorCodeSupplier)ServerErrorCode.ACCESS_DENIED, "Access is denied.");
                }
            }
            catch (Exception e) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.ACCESS_DENIED, (Throwable)e);
            }
        }
    }

    private void checkSqlRequest(SQLRequest sqlRequest) {
        Message msg = MsgPicker.getMsg();
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        if (!kylinConfig.isQueryNode()) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeSystem.JOB_NODE_QUERY_API_INVALID, new Object[0]);
        }
        this.checkSqlRequestProject(sqlRequest, msg);
        if (NProjectManager.getInstance((KylinConfig)kylinConfig).getProject(sqlRequest.getProject()) == null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PROJECT_NOT_EXIST, new Object[]{sqlRequest.getProject()});
        }
        if (StringUtils.isBlank((CharSequence)sqlRequest.getSql())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_SQL_EXPRESSION, msg.getNullEmptySql());
        }
    }

    private void checkSqlRequestProject(SQLRequest sqlRequest, Message msg) {
        if (StringUtils.isBlank((CharSequence)sqlRequest.getProject())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PROJECT_NAME, msg.getEmptyProjectName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLResponse doQueryWithCache(SQLRequest sqlRequest) {
        SQLResponse sQLResponse;
        this.checkSqlRequest(sqlRequest);
        if (sqlRequest.getBackdoorToggles() != null) {
            BackdoorToggles.addToggles((Map)sqlRequest.getBackdoorToggles());
            QueryTrace queryTrace = QueryContext.currentTrace();
            Optional.ofNullable(BackdoorToggles.getConnectionCreatingTime()).ifPresent(duration -> queryTrace.appendSpanFromRequest("CONNECTION_CREATING_TIME", duration.longValue()));
            Optional.ofNullable(BackdoorToggles.getStatementToRequestTime()).ifPresent(duration -> queryTrace.appendSpanFromRequest("STATEMENT_TO_REQUEST_TIME", duration.longValue()));
        }
        QueryContext queryContext = QueryContext.current();
        QueryMetricsContext.start((String)queryContext.getQueryId(), (String)this.getDefaultServer());
        String project = sqlRequest.getProject();
        SQLResponse sqlResponse = null;
        try {
            Serializable serializable;
            Object ignored;
            QueryContext.currentTrace().startSpan("GET_ACL_INFO");
            queryContext.setAclInfo(this.getExecuteAclInfo(project, sqlRequest.getExecuteAs()));
            QueryContext.currentTrace().startSpan("SQL_TRANSFORMATION");
            queryContext.getMetrics().setServer(this.clusterManager.getLocalServer());
            queryContext.setProject(project);
            KylinConfig kylinConfig = NProjectManager.getProjectConfig((String)project);
            RawSql rawSql = new RawSqlParser(sqlRequest.getSql()).parse();
            rawSql.autoAppendLimit(kylinConfig, sqlRequest.getLimit().intValue(), sqlRequest.getOffset().intValue());
            WhiteSpaceParser whiteSpaceParser = new WhiteSpaceParser(EscapeDialect.DEFAULT, rawSql.getStatementString().trim());
            sqlRequest.setNormalizedSql(whiteSpaceParser.parse());
            sqlRequest.setSql(rawSql.getStatementString());
            queryContext.setUserSQL(rawSql.getFullTextString());
            queryContext.setFirstHintStr(rawSql.getFirstHintString());
            this.applyModelPriority(queryContext, rawSql);
            this.applyQuerySqlBlacklist(project, rawSql.getStatementString());
            if (kylinConfig.isQueryCacheEnabled() && !sqlRequest.isForcedToPushDown() && !queryContext.getQueryTagInfo().isAsyncQuery()) {
                sqlResponse = this.searchCache(sqlRequest, kylinConfig);
            }
            if (sqlResponse == null) {
                ignored = new QueryRequestLimits(project);
                serializable = null;
                try {
                    sqlResponse = this.queryAndUpdateCache(sqlRequest, kylinConfig);
                }
                catch (Throwable throwable) {
                    serializable = throwable;
                    throw throwable;
                }
                finally {
                    if (ignored != null) {
                        if (serializable != null) {
                            try {
                                ((QueryRequestLimits)ignored).close();
                            }
                            catch (Throwable throwable) {
                                serializable.addSuppressed(throwable);
                            }
                        } else {
                            ((QueryRequestLimits)ignored).close();
                        }
                    }
                }
            }
            if (sqlRequest.isIfBigQuery()) {
                ignored = sqlResponse;
                return ignored;
            }
            QueryUtils.updateQueryContextSQLMetrics(rawSql.getStatementString());
            QueryContext.currentTrace().amendLast("PREPARE_AND_SUBMIT_JOB", System.currentTimeMillis());
            QueryContext.currentTrace().endLastSpan();
            QueryContext.current().record("update_metrics_time");
            QueryContext.currentMetrics().setQueryEndTime(System.currentTimeMillis());
            sqlResponse.setServer(this.clusterManager.getLocalServer());
            sqlResponse.setQueryId(QueryContext.current().getQueryId());
            if (sqlResponse.isStorageCacheUsed() || sqlResponse.isHitExceptionCache()) {
                sqlResponse.setDuration(0L);
            } else {
                sqlResponse.setDuration(QueryContext.currentMetrics().duration());
                sqlResponse.setCpuTime(QueryContext.currentMetrics().getCpuTime());
            }
            this.logQuery(sqlRequest, sqlResponse);
            this.addToQueryHistory(sqlRequest, sqlResponse, rawSql.getFullTextString());
            if (this.isCollectQueryScanRowsAndTimeEnabled()) {
                BigQueryThresholdUpdater.collectQueryScanRowsAndTime((long)QueryContext.currentMetrics().duration(), (long)QueryContext.currentMetrics().getTotalScanRows());
            }
            FusionModelManager fusionManager = FusionModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)sqlRequest.getProject());
            if (CollectionUtils.isNotEmpty(sqlResponse.getNativeRealizations())) {
                sqlResponse.getNativeRealizations().forEach(realization -> realization.setModelId(fusionManager.getModelId(realization)));
            }
            NCircuitBreaker.verifyQueryResultRowCount((long)sqlResponse.getResultRowCount());
            serializable = sqlResponse;
            return serializable;
        }
        catch (Exception e) {
            QueryContext.current().getMetrics().setException(true);
            if (sqlResponse != null) {
                sqlResponse.setException(true);
                sqlResponse.setExceptionMessage(e.getMessage());
                sqlResponse.setResults(null);
                sQLResponse = sqlResponse;
                return sQLResponse;
            }
            sQLResponse = new SQLResponse(null, null, 0, true, e.getMessage());
            return sQLResponse;
        }
        catch (TokenMgrError t) {
            QueryContext.current().getMetrics().setException(true);
            sQLResponse = new SQLResponse(null, null, 0, true, t.getMessage());
            return sQLResponse;
        }
        finally {
            BackdoorToggles.cleanToggles();
            if (QueryMetricsContext.isStarted()) {
                QueryMetricsContext.reset();
            }
        }
    }

    public boolean isCollectQueryScanRowsAndTimeEnabled() {
        return KapConfig.getInstanceFromEnv().isAutoAdjustBigQueryRowsThresholdEnabled() && !QueryContext.current().getQueryTagInfo().isAsyncQuery() && !QueryContext.current().getQueryTagInfo().isStorageCacheUsed();
    }

    protected SQLResponse searchCache(SQLRequest sqlRequest, KylinConfig kylinConfig) {
        SQLResponse response = this.searchFailedCache(sqlRequest, kylinConfig);
        if (response == null) {
            response = this.searchSuccessCache(sqlRequest);
        }
        if (response != null) {
            response.setDuration(0L);
            this.collectToQueryContext(response);
            QueryContext.currentTrace().clear();
            QueryContext.currentTrace().startSpan("HIT_CACHE");
            QueryContext.currentTrace().endLastSpan();
        }
        return response;
    }

    private SQLResponse searchFailedCache(SQLRequest sqlRequest, KylinConfig kylinConfig) {
        SQLResponse response = this.queryCacheManager.getFromExceptionCache(sqlRequest);
        if (response != null && this.isFailTimesExceedThreshold(response, kylinConfig)) {
            logger.info("The sqlResponse is found in EXCEPTION_QUERY_CACHE");
            response.setHitExceptionCache(true);
            QueryContext.current().getMetrics().setException(true);
            QueryContext.current().getMetrics().setFinalCause(response.getThrowable());
            QueryContext.current().getMetrics().setQueryMsg(response.getExceptionMessage());
            return response;
        }
        return null;
    }

    private SQLResponse searchSuccessCache(SQLRequest sqlRequest) {
        SQLResponse response = this.queryCacheManager.searchSuccessCache(sqlRequest);
        if (response != null) {
            logger.info("The sqlResponse is found in SUCCESS_QUERY_CACHE");
            response.setStorageCacheUsed(true);
        }
        return response;
    }

    private void addToQueryHistory(SQLRequest sqlRequest, SQLResponse sqlResponse, String originalSql) {
        if (QueryContext.current().getQueryTagInfo().isQueryDetect()) {
            return;
        }
        if (!QueryContext.current().getQueryTagInfo().isAsyncQuery() || !NProjectManager.getProjectConfig((String)sqlRequest.getProject()).isUniqueAsyncQueryYarnQueue()) {
            try {
                if (!sqlResponse.isPrepare() && QueryMetricsContext.isStarted()) {
                    QueryMetricsContext queryMetricsContext = QueryMetricsContext.collect((QueryContext)QueryContext.current());
                    queryMetricsContext.setSql(this.constructQueryHistorySqlText(sqlRequest, sqlResponse, originalSql));
                    String normalizedSql = QueryContext.currentMetrics().getCorrectedSql();
                    queryMetricsContext.setSqlPattern(normalizedSql);
                    QueryHistoryScheduler queryHistoryScheduler = QueryHistoryScheduler.getInstance();
                    queryHistoryScheduler.offerQueryHistoryQueue((QueryMetrics)queryMetricsContext);
                    EventBusFactory.getInstance().postAsync((SchedulerEventNotifier)queryMetricsContext);
                }
            }
            catch (Throwable th) {
                logger.warn("Write metric error.", th);
            }
        }
    }

    private String constructQueryHistorySqlText(SQLRequest sqlRequest, SQLResponse sqlResponse, String originalSql) throws JsonProcessingException, ClassNotFoundException {
        QueryUtils.fillInPrepareStatParams(sqlRequest, sqlResponse.isQueryPushDown());
        ArrayList<QueryHistorySqlParam> params = null;
        if (QueryUtils.isPrepareStatementWithParams(sqlRequest)) {
            params = new ArrayList<QueryHistorySqlParam>();
            PrepareSqlStateParam[] requestParams = ((PrepareSqlRequest)sqlRequest).getParams();
            for (int i = 0; i < requestParams.length; ++i) {
                PrepareSqlStateParam p = requestParams[i];
                String dataType = QueryHistoryUtil.toDataType((String)p.getClassName());
                QueryHistorySqlParam param = new QueryHistorySqlParam(Integer.valueOf(i + 1), p.getClassName(), dataType, p.getValue());
                params.add(param);
            }
        }
        return QueryHistoryUtil.toQueryHistorySqlText((QueryHistorySql)new QueryHistorySql(originalSql, null, params));
    }

    private void collectToQueryContext(SQLResponse sqlResponse) {
        QueryContext queryContext = QueryContext.current();
        if (sqlResponse.getEngineType() != null) {
            queryContext.setEngineType(sqlResponse.getEngineType());
        }
        queryContext.getMetrics().setScanBytes(sqlResponse.getScanBytes());
        queryContext.getMetrics().setScanRows(sqlResponse.getScanRows());
        queryContext.getMetrics().setResultRowCount(sqlResponse.getResultRowCount());
        queryContext.setQueryRealizations(sqlResponse.getNativeRealizations());
    }

    private String getDefaultServer() {
        return AddressUtil.getLocalHostExactAddress() + ":" + this.appConfig.getPort();
    }

    @VisibleForTesting
    protected SQLResponse queryAndUpdateCache(SQLRequest sqlRequest, KylinConfig kylinConfig) {
        SQLResponse sqlResponse;
        block6: {
            boolean queryCacheEnabled = this.isQueryCacheEnabled(kylinConfig);
            try {
                boolean isSelect = QueryUtil.isSelectStatement((String)sqlRequest.getSql());
                if (!isSelect) {
                    throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, MsgPicker.getMsg().getnotSupportedSql());
                }
                sqlResponse = this.query(sqlRequest);
                if (CheckUtil.checkCondition((boolean)queryCacheEnabled, (String)"query cache is disabled", (Object[])new Object[0]) && !sqlRequest.isIfBigQuery()) {
                    sqlResponse.setDuration(QueryContext.currentMetrics().duration());
                    sqlResponse.setCpuTime(QueryContext.currentMetrics().getCpuTime());
                    this.queryCacheManager.cacheSuccessQuery(sqlRequest, sqlResponse);
                }
            }
            catch (Throwable e) {
                logger.error("Exception while executing query", e);
                QueryContext.current().getMetrics().setException(true);
                String errMsg = this.makeErrorMsgUserFriendly(e);
                if (errMsg == null) {
                    errMsg = e.getMessage() != null ? e.getMessage() : e.getClass().getCanonicalName();
                }
                sqlResponse = new SQLResponse(null, null, 0, true, errMsg, false, false);
                QueryContext queryContext = QueryContext.current();
                queryContext.getMetrics().setFinalCause(e);
                queryContext.getMetrics().setQueryMsg(errMsg);
                queryContext.getQueryTagInfo().setPushdown(false);
                QueryService.applyExceptionResponse(sqlResponse, e, queryContext);
                if (UserStopQueryException.causedByUserStop((Throwable)e)) {
                    sqlResponse.setStopByUser(true);
                    sqlResponse.setColumnMetas(Lists.newArrayList());
                    sqlResponse.setExceptionMessage(MsgPicker.getMsg().getStopByUserErrorMessage());
                }
                sqlResponse.wrapResultOfQueryContext(queryContext);
                sqlResponse.setRefused(queryContext.getQueryTagInfo().isRefused());
                sqlResponse.setTimeout(queryContext.getQueryTagInfo().isTimeout());
                this.setAppMaterURL(sqlResponse);
                sqlResponse.setDuration(QueryContext.currentMetrics().duration());
                sqlResponse.setCpuTime(QueryContext.currentMetrics().getCpuTime());
                if (!queryCacheEnabled || e.getCause() == null) break block6;
                this.putIntoExceptionCache(sqlRequest, sqlResponse, e);
            }
        }
        return sqlResponse;
    }

    private static void applyExceptionResponse(SQLResponse sqlResponse, Throwable e, QueryContext queryContext) {
        if (e.getCause() != null) {
            if (NewQueryRefuseException.causedByRefuse((Throwable)e)) {
                queryContext.getQueryTagInfo().setRefused(true);
            } else if (BigQueryException.causedByRefuse((Throwable)e)) {
                sqlResponse.setException(false);
                sqlResponse.setExceptionMessage("");
                sqlResponse.setScanRows(queryContext.getMetrics().getScanRows());
                sqlResponse.setBigQuery(queryContext.isBigQuery());
            } else if (KylinTimeoutException.causedByTimeout((Throwable)e)) {
                queryContext.getQueryTagInfo().setTimeout(true);
            }
        }
    }

    @VisibleForTesting
    public void putIntoExceptionCache(SQLRequest sqlRequest, SQLResponse sqlResponse, Throwable e) {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        if (e.getCause() != null && ExceptionUtils.getRootCause((Throwable)e) instanceof ResourceLimitExceededException) {
            this.queryCacheManager.cacheFailedQuery(sqlRequest, sqlResponse);
            return;
        }
        if (!this.isQueryExceptionCacheEnabled(kylinConfig)) {
            return;
        }
        if (this.noNeedCache(sqlResponse, kylinConfig, e)) {
            return;
        }
        SQLResponse cachedSqlResponse = this.queryCacheManager.getFromExceptionCache(sqlRequest);
        if (null == cachedSqlResponse) {
            sqlResponse.setFailTimes(1);
            this.queryCacheManager.putIntoExceptionCache(sqlRequest, sqlResponse);
        } else {
            int failCount = cachedSqlResponse.getFailTimes();
            sqlResponse.setFailTimes(failCount + 1);
            this.queryCacheManager.updateIntoExceptionCache(sqlRequest, sqlResponse);
        }
    }

    private boolean noNeedCache(SQLResponse sqlResponse, KylinConfig kylinConfig, Throwable e) {
        if (sqlResponse.getDuration() < (long)kylinConfig.getQueryExceptionCacheThresholdDuration()) {
            logger.info("Query duration has not exceed threshold, will not cache.");
            return true;
        }
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
        return rootCause instanceof NoRealizationFoundException || rootCause instanceof RoutingIndicatorException || rootCause instanceof NotSupportedSQLException || rootCause instanceof SqlValidatorException;
    }

    private boolean isFailTimesExceedThreshold(SQLResponse sqlResponse, KylinConfig kylinConfig) {
        int failTimes = sqlResponse.getFailTimes();
        if (failTimes < 0) {
            return true;
        }
        return kylinConfig.isQueryExceptionCacheEnabled() && failTimes >= kylinConfig.getQueryExceptionCacheThresholdTimes();
    }

    private void removeExceptionCache(SQLRequest sqlRequest) {
        if (!this.isQueryExceptionCacheEnabled(KylinConfig.getInstanceFromEnv())) {
            return;
        }
        if (null == this.queryCacheManager.getFromExceptionCache(sqlRequest)) {
            return;
        }
        if (!this.queryCacheManager.getCache().remove(CommonQueryCacheSupporter.Type.EXCEPTION_QUERY_CACHE.rootCacheName, sqlRequest.getProject(), sqlRequest.getCacheKey())) {
            logger.info("Remove cache failed");
        }
    }

    private boolean isQueryCacheEnabled(KylinConfig kylinConfig) {
        boolean isNotQueryDetect;
        boolean bl = isNotQueryDetect = !QueryContext.current().getQueryTagInfo().isQueryDetect();
        return CheckUtil.checkCondition((boolean)kylinConfig.isQueryCacheEnabled(), (String)"query cache disabled in KylinConfig", (Object[])new Object[0]) && CheckUtil.checkCondition((!BackdoorToggles.getDisableCache() ? 1 : 0) != 0, (String)"query cache disabled in BackdoorToggles", (Object[])new Object[0]) && CheckUtil.checkCondition((boolean)isNotQueryDetect, (String)"query cache disabled because it is query detect", (Object[])new Object[0]);
    }

    private boolean isQueryExceptionCacheEnabled(KylinConfig kylinConfig) {
        return CheckUtil.checkCondition((boolean)kylinConfig.isQueryExceptionCacheEnabled(), (String)"query exception cache disabled in KylinConfig", (Object[])new Object[0]) && CheckUtil.checkCondition((!BackdoorToggles.getDisableCache() ? 1 : 0) != 0, (String)"query cache disabled in BackdoorToggles", (Object[])new Object[0]);
    }

    private void applyQuerySqlBlacklist(String project, String sql) {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        if (!kylinConfig.isQueryBlacklistEnabled()) {
            return;
        }
        SQLBlacklistItem sqlBlacklistItem = this.matchSqlBlacklist(project, sql);
        if (null == sqlBlacklistItem) {
            return;
        }
        int concurrentLimit = sqlBlacklistItem.getConcurrentLimit();
        if (concurrentLimit == 0) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.BLACKLIST_QUERY_REJECTED, String.format(Locale.ROOT, MsgPicker.getMsg().getSqlBlacklistQueryRejected(), sqlBlacklistItem.getId()));
        }
        if (this.getSqlConcurrentCount(sqlBlacklistItem) >= concurrentLimit) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.BLACKLIST_EXCEEDED_CONCURRENT_LIMIT, String.format(Locale.ROOT, MsgPicker.getMsg().getSqlBlackListQueryConcurrentLimitExceeded(), sqlBlacklistItem.getId(), concurrentLimit));
        }
    }

    private SQLBlacklistItem matchSqlBlacklist(String project, String sql) {
        try {
            SQLBlacklistManager sqlBlacklistManager = SQLBlacklistManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
            return sqlBlacklistManager.matchSqlBlacklist(project, sql);
        }
        catch (Exception e) {
            logger.error("Match sql blacklist failed.", (Throwable)e);
            return null;
        }
    }

    private int getSqlConcurrentCount(SQLBlacklistItem sqlBlacklistItem) {
        int concurrentCount = 0;
        Collection runningQueries = SlowQueryDetector.getRunningQueries().values();
        for (SlowQueryDetector.QueryEntry query : runningQueries) {
            if (!sqlBlacklistItem.match(query.getSql())) continue;
            ++concurrentCount;
        }
        return concurrentCount;
    }

    boolean isACLDisabledOrAdmin(String project, QueryContext.AclInfo aclInfo) {
        if (!NProjectManager.getProjectConfig((String)project).isAclTCREnabled()) {
            return true;
        }
        if (aclInfo != null && aclInfo.getGroups() != null && AclPermissionUtil.isAdmin((Set)aclInfo.getGroups())) {
            return true;
        }
        return aclInfo != null && aclInfo.isHasAdminPermission();
    }

    public QueryExec newQueryExec(String project) {
        return this.newQueryExec(project, null);
    }

    public QueryExec newQueryExec(String project, String executeAs) {
        QueryContext.current().setAclInfo(this.getExecuteAclInfo(project, executeAs));
        return new QueryExec(project, NProjectManager.getProjectConfig((String)project), true);
    }

    protected QueryContext.AclInfo getExecuteAclInfo(String project) {
        return this.getExecuteAclInfo(project, null);
    }

    @VisibleForTesting
    public QueryContext.AclInfo getExecuteAclInfo(String project, String executeAs) {
        boolean hasAdminPermission;
        Set groupsOfExecuteUser;
        if (executeAs == null) {
            executeAs = AclPermissionUtil.getCurrentUsername();
        }
        if (QueryContext.current().getAclInfo() != null) {
            QueryContext.AclInfo aclInfo = QueryContext.current().getAclInfo();
            if (executeAs != null && executeAs.equals(aclInfo.getUsername())) {
                return aclInfo;
            }
        }
        try {
            groupsOfExecuteUser = this.accessService.getGroupsOfExecuteUser(executeAs);
            MutableAclRecord acl = AclPermissionUtil.getProjectAcl((String)project);
            Set groupsInProject = AclPermissionUtil.filterGroupsInProject((Set)groupsOfExecuteUser, (MutableAclRecord)acl);
            hasAdminPermission = AclPermissionUtil.isSpecificPermissionInProject((String)executeAs, (Set)groupsInProject, (Permission)BasePermission.ADMINISTRATION, (MutableAclRecord)acl);
        }
        catch (UsernameNotFoundException e) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_USER_NAME, String.format(Locale.ROOT, MsgPicker.getMsg().getInvalidExecuteAsUser(), executeAs));
        }
        return new QueryContext.AclInfo(executeAs, groupsOfExecuteUser, hasAdminPermission);
    }

    public List<TableMeta> getMetadata(String project) {
        if (!NProjectManager.getProjectConfig((String)project).isSchemaCacheEnabled()) {
            return this.doGetMetadata(project, null);
        }
        String userName = AclPermissionUtil.getCurrentUsername();
        List<TableMeta> cached = this.queryCacheManager.getSchemaCache(project, userName);
        if (cached != null) {
            logger.info("[schema cache log] Get meta data from cache, project: {}, username: {}.", (Object)project, (Object)userName);
            return cached;
        }
        List<TableMeta> tableMetas = this.doGetMetadata(project, null);
        List<String> tables = tableMetas.stream().map(meta -> meta.getTABLE_SCHEM() + "." + meta.getTABLE_NAME()).collect(Collectors.toList());
        TableMetaCacheResult cacheResult = new TableMetaCacheResult(tableMetas, QueryCacheSignatureUtil.createCacheSignature(tables, project, null));
        this.queryCacheManager.putSchemaCache(project, userName, cacheResult);
        return tableMetas;
    }

    public List<TableMeta> getMetadata(String project, String modelAlias) {
        return this.doGetMetadata(project, modelAlias);
    }

    private List<TableMeta> doGetMetadata(String project, String targetModelName) {
        if (StringUtils.isBlank((CharSequence)project)) {
            return Collections.emptyList();
        }
        List<NDataModel> models = this.getModels(project, targetModelName);
        List<String> targetModelTables = this.getTargetModelTables(targetModelName, models);
        List<String> targetModelColumns = this.getTargetModelColumns(targetModelName, models, project);
        QueryContext.current().setAclInfo(this.getExecuteAclInfo(project));
        SchemaMetaData schemaMetaData = new SchemaMetaData(project, NProjectManager.getProjectConfig((String)project));
        LinkedList<TableMeta> tableMetas = new LinkedList<TableMeta>();
        SetMultimap<String, String> tbl2ccNames = this.collectComputedColumns(project);
        for (TableSchema tableSchema : schemaMetaData.getTables()) {
            TableMeta tblMeta = new TableMeta(tableSchema.getCatalog(), tableSchema.getSchema(), tableSchema.getTable(), tableSchema.getType(), tableSchema.getRemarks(), null, null, null, null, null);
            if (JDBC_METADATA_SCHEMA.equalsIgnoreCase(tblMeta.getTABLE_SCHEM()) || targetModelTables != null && !targetModelTables.contains(tblMeta.getTABLE_SCHEM() + "." + tblMeta.getTABLE_NAME())) continue;
            tableMetas.add(tblMeta);
            int columnOrdinal = 1;
            for (StructField field : tableSchema.getFields()) {
                ColumnMeta columnMeta = this.constructColumnMeta(tableSchema, field, columnOrdinal);
                ++columnOrdinal;
                if (!this.shouldExposeColumn(project, columnMeta, tbl2ccNames)) continue;
                String qualifiedCol = columnMeta.getTABLE_SCHEM() + "." + columnMeta.getTABLE_NAME() + "." + columnMeta.getCOLUMN_NAME();
                if (columnMeta.getCOLUMN_NAME().toUpperCase(Locale.ROOT).startsWith("_KY_") || !this.isQualifiedColumn(targetModelColumns, qualifiedCol)) continue;
                tblMeta.addColumn(columnMeta);
            }
        }
        return tableMetas;
    }

    private boolean isQualifiedColumn(List<String> targetModelColumns, String qualifiedCol) {
        return targetModelColumns == null || targetModelColumns.contains(qualifiedCol);
    }

    public List<TableMetaWithType> getMetadataV2(String project, String modelAlias) {
        if (!NProjectManager.getProjectConfig((String)project).isSchemaCacheEnabled()) {
            return this.doGetMetadataV2(project, modelAlias);
        }
        String userName = AclPermissionUtil.getCurrentUsername();
        List<TableMetaWithType> cached = this.queryCacheManager.getSchemaV2Cache(project, modelAlias, userName);
        if (cached != null) {
            logger.info("[schema cache log] Get meta data v2 from cache, project: {}, username: {}.", (Object)project, (Object)userName);
            return cached;
        }
        List<TableMetaWithType> tableMetas = this.doGetMetadataV2(project, modelAlias);
        List<String> tables = tableMetas.stream().map(meta -> meta.getTABLE_SCHEM() + "." + meta.getTABLE_NAME()).collect(Collectors.toList());
        TableMetaCacheResultV2 cacheResult = new TableMetaCacheResultV2(tableMetas, QueryCacheSignatureUtil.createCacheSignature(tables, project, modelAlias));
        this.queryCacheManager.putSchemaV2Cache(project, modelAlias, userName, cacheResult);
        return tableMetas;
    }

    public List<String> format(List<String> sqls) {
        ArrayList pairs = Lists.newArrayList();
        int index = 0;
        for (String sql : sqls) {
            pairs.add(Pair.newPair((Object)index, (Object)sql));
        }
        return pairs.parallelStream().map(pair -> {
            try {
                SqlNode node = CalciteParser.parse((String)((String)pair.getSecond()));
                SqlPrettyWriter writer = new SqlPrettyWriter(KEDialect.DEFAULT);
                writer.setIndentation(2);
                writer.setSelectListExtraIndentFlag(true);
                writer.setSelectListItemsOnSeparateLines(true);
                return Pair.newPair((Object)pair.getFirst(), (Object)writer.format(node));
            }
            catch (SqlParseException e) {
                logger.info("Sql {} cannot be formatted", pair.getSecond());
                return pair;
            }
        }).sorted(Comparator.comparingInt(Pair::getFirst)).map(Pair::getSecond).collect(Collectors.toList());
    }

    public QueryDetectResponse queryDetect(QueryDetectRequest queryDetectRequest) {
        try (QueryContext queryContext = QueryContext.current();){
            queryContext.getQueryTagInfo().setQueryDetect(true);
            String project = queryDetectRequest.getProject();
            SQLRequest sqlRequest = new SQLRequest();
            sqlRequest.setSql(queryDetectRequest.getSql());
            sqlRequest.setProject(project);
            sqlRequest.setLimit(queryDetectRequest.getLimit());
            sqlRequest.setOffset(queryDetectRequest.getOffset());
            SQLResponse sqlResponse = this.queryWithCache(sqlRequest);
            if (sqlResponse.isException()) {
                QueryDetectResponse queryDetectResponse = new QueryDetectResponse().buildExceptionResponse(sqlResponse);
                return queryDetectResponse;
            }
            QueryDetectResponse queryDetectResponse = new QueryDetectResponse().buildResponse(project, sqlResponse, queryContext);
            return queryDetectResponse;
        }
    }

    private List<TableMetaWithType> doGetMetadataV2(String project, String targetModelName) {
        this.aclEvaluate.checkProjectQueryPermission(project);
        if (StringUtils.isBlank((CharSequence)project)) {
            return Collections.emptyList();
        }
        List<NDataModel> models = this.getModels(project, targetModelName);
        List<String> targetModelTables = this.getTargetModelTables(targetModelName, models);
        List<String> targetModelColumns = this.getTargetModelColumns(targetModelName, models, project);
        QueryContext.current().setAclInfo(this.getExecuteAclInfo(project));
        SchemaMetaData schemaMetaData = new SchemaMetaData(project, NProjectManager.getProjectConfig((String)project));
        LinkedHashMap<TableMetaIdentify, TableMetaWithType> tableMap = this.constructTableMeta(schemaMetaData, targetModelTables);
        LinkedHashMap<ColumnMetaIdentify, ColumnMetaWithType> columnMap = this.constructTblColMeta(schemaMetaData, project, targetModelColumns);
        columnMap.forEach((identify, columnMetaWithType) -> {
            TableMetaIdentify tableMetaIdentify = new TableMetaIdentify(identify.getTableSchema(), identify.getTableName());
            String tableType = ((TableMetaWithType)tableMap.get(tableMetaIdentify)).getTABLE_TYPE();
            if (tableType.equals("VIEW")) {
                NDataModelManager modelManager = NDataModelManager.getInstance((KylinConfig)this.getConfig(), (String)project);
                NDataModel model = modelManager.getDataModelDescByAlias(tableMetaIdentify.tableName);
                if (StringUtils.isNotBlank((CharSequence)model.getDescription())) {
                    ((TableMetaWithType)tableMap.get(tableMetaIdentify)).setREMARKS(model.getDescription());
                }
                int colIdInMode = model.getColumnByColumnNameInModel(columnMetaWithType.getCOLUMN_NAME()).getId();
                String fullyQualifiedName = model.getColRef(Integer.valueOf(colIdInMode)).getColumnWithTableAndSchema();
                columnMetaWithType.setFULLY_QUALIFIED_COLUMN_NAME(fullyQualifiedName);
            }
        });
        QueryService.addColsToTblMeta(tableMap, columnMap);
        for (NDataModel model : models) {
            this.clarifyTblTypeToFactOrLookup(model, tableMap);
            this.clarifyPkFkCols(model, columnMap);
        }
        ArrayList tableMetas = Lists.newArrayList();
        tableMap.forEach((name, tableMeta) -> tableMetas.add(tableMeta));
        return tableMetas;
    }

    List<String> getTargetModelColumns(String targetModelName, List<NDataModel> models, String project) {
        List targetModelColumns = null;
        if (targetModelName != null) {
            NIndexPlanManager indexPlanManager = (NIndexPlanManager)this.getManager(NIndexPlanManager.class, project);
            targetModelColumns = NProjectManager.getProjectConfig((String)project).exposeAllModelRelatedColumns() ? models.stream().filter(m -> m.getAlias().equals(targetModelName)).flatMap(m -> m.getEffectiveCols().values().stream().map(TblColRef::getColumnWithTableAndSchema)).collect(Collectors.toList()) : models.stream().filter(m -> m.getAlias().equals(targetModelName)).map(model -> {
                Set relatedColIds = indexPlanManager.getIndexPlan(model.getId()).getRelatedColIds();
                return relatedColIds.stream().map(id -> model.getColRef(id).getColumnWithTableAndSchema()).collect(Collectors.toList());
            }).flatMap(Collection::stream).collect(Collectors.toList());
        }
        return targetModelColumns;
    }

    private List<String> getTargetModelTables(String targetModelName, List<NDataModel> models) {
        return targetModelName == null ? null : models.stream().filter(m -> m.getAlias().equals(targetModelName)).flatMap(m -> m.getAllTableRefs().stream().map(TableRef::getTableIdentity)).collect(Collectors.toList());
    }

    private List<NDataModel> getModels(String project, String targetModelName) {
        return NDataModelManager.getInstance((KylinConfig)this.getConfig(), (String)project).listAllModels().stream().filter(m -> !m.isBroken() && (targetModelName == null || m.getAlias().equals(targetModelName))).collect(Collectors.toList());
    }

    private LinkedHashMap<TableMetaIdentify, TableMetaWithType> constructTableMeta(SchemaMetaData schemaMetaData, List<String> targetModelTables) {
        LinkedHashMap tableMap = Maps.newLinkedHashMap();
        for (TableSchema tableSchema : schemaMetaData.getTables()) {
            TableMetaWithType tblMeta = new TableMetaWithType(tableSchema.getCatalog(), tableSchema.getSchema(), tableSchema.getTable(), tableSchema.getType(), tableSchema.getRemarks(), null, null, null, null, null);
            if (JDBC_METADATA_SCHEMA.equalsIgnoreCase(tblMeta.getTABLE_SCHEM()) || targetModelTables != null && !targetModelTables.contains(tblMeta.getTABLE_SCHEM() + "." + tblMeta.getTABLE_NAME())) continue;
            tableMap.put(new TableMetaIdentify(tblMeta.getTABLE_SCHEM(), tblMeta.getTABLE_NAME()), tblMeta);
        }
        return tableMap;
    }

    private LinkedHashMap<ColumnMetaIdentify, ColumnMetaWithType> constructTblColMeta(SchemaMetaData schemaMetaData, String project, List<String> targetModelColumns) {
        LinkedHashMap columnMap = Maps.newLinkedHashMap();
        SetMultimap<String, String> tbl2ccNames = this.collectComputedColumns(project);
        for (TableSchema tableSchema : schemaMetaData.getTables()) {
            int columnOrdinal = 1;
            for (StructField field : tableSchema.getFields()) {
                ColumnMetaWithType columnMeta = ColumnMetaWithType.ofColumnMeta((ColumnMeta)this.constructColumnMeta(tableSchema, field, columnOrdinal));
                ++columnOrdinal;
                if (!this.shouldExposeColumn(project, (ColumnMeta)columnMeta, tbl2ccNames) || JDBC_METADATA_SCHEMA.equalsIgnoreCase(columnMeta.getTABLE_SCHEM()) || columnMeta.getCOLUMN_NAME().toUpperCase(Locale.ROOT).startsWith("_KY_") || targetModelColumns != null && !targetModelColumns.contains(columnMeta.getTABLE_SCHEM() + "." + columnMeta.getTABLE_NAME() + "." + columnMeta.getCOLUMN_NAME())) continue;
                columnMap.put(new ColumnMetaIdentify(columnMeta.getTABLE_SCHEM(), columnMeta.getTABLE_NAME(), columnMeta.getCOLUMN_NAME()), columnMeta);
            }
        }
        return columnMap;
    }

    private ColumnMeta constructColumnMeta(TableSchema tableSchema, StructField field, int columnOrdinal) {
        int NUM_PREC_RADIX = 10;
        int columnSize = -1;
        if (field.getDataType() == 93 || field.getDataType() == 3 || field.getDataType() == 12 || field.getDataType() == 1) {
            columnSize = field.getPrecision();
        }
        int charOctetLength = columnSize;
        int decimalDigit = field.getDataType() == 3 ? field.getScale() : 0;
        int nullable = field.isNullable() ? 1 : 0;
        String isNullable = field.isNullable() ? "YES" : "NO";
        int sourceDataType = -1;
        return new ColumnMeta(tableSchema.getCatalog(), tableSchema.getSchema(), tableSchema.getTable(), field.getName(), field.getDataType(), field.getDataTypeName(), columnSize, -1, decimalDigit, 10, nullable, null, null, -1, -1, charOctetLength, columnOrdinal, isNullable, null, null, null, -1, "");
    }

    private SetMultimap<String, String> collectComputedColumns(String project) {
        HashMultimap tbl2ccNames = HashMultimap.create();
        ((NProjectManager)this.getManager(NProjectManager.class)).listAllRealizations(project).forEach(arg_0 -> QueryService.lambda$collectComputedColumns$30((SetMultimap)tbl2ccNames, arg_0));
        return tbl2ccNames;
    }

    private boolean shouldExposeColumn(String project, ColumnMeta columnMeta, SetMultimap<String, String> tbl2ccNames) {
        if (NProjectManager.getProjectConfig((String)project).exposeComputedColumn()) {
            return true;
        }
        return !this.isComputedColumn(columnMeta.getCOLUMN_NAME().toUpperCase(Locale.ROOT), columnMeta.getTABLE_NAME(), tbl2ccNames);
    }

    private boolean isComputedColumn(String ccName, String table, SetMultimap<String, String> tbl2ccNames) {
        return CollectionUtils.isNotEmpty((Collection)tbl2ccNames.get((Object)table.toUpperCase(Locale.ROOT))) && tbl2ccNames.get((Object)table.toUpperCase(Locale.ROOT)).contains(ccName.toUpperCase(Locale.ROOT));
    }

    static void addColsToTblMeta(Map<TableMetaIdentify, TableMetaWithType> tblMap, Map<ColumnMetaIdentify, ColumnMetaWithType> columnMetaWithTypeMap) {
        columnMetaWithTypeMap.forEach((identify, columnMetaWithType) -> {
            TableMetaIdentify tableMetaIdentify = new TableMetaIdentify(identify.getTableSchema(), identify.getTableName());
            ((TableMetaWithType)tblMap.get(tableMetaIdentify)).addColumn((ColumnMeta)columnMetaWithType);
        });
    }

    private void clarifyTblTypeToFactOrLookup(NDataModel dataModelDesc, Map<TableMetaIdentify, TableMetaWithType> tableMap) {
        TableMetaIdentify tableMetaIdentify;
        String tableName;
        String tableSchema;
        for (TableRef factTable : dataModelDesc.getFactTables()) {
            tableSchema = factTable.getTableIdentity().split("\\.")[0];
            tableMetaIdentify = new TableMetaIdentify(tableSchema, tableName = factTable.getTableIdentity().split("\\.")[1]);
            if (!tableMap.containsKey(tableMetaIdentify)) continue;
            tableMap.get(tableMetaIdentify).getTYPE().add(TableMetaWithType.tableTypeEnum.FACT);
        }
        for (TableRef lookupTable : dataModelDesc.getLookupTables()) {
            tableSchema = lookupTable.getTableIdentity().split("\\.")[0];
            tableMetaIdentify = new TableMetaIdentify(tableSchema, tableName = lookupTable.getTableIdentity().split("\\.")[1]);
            if (!tableMap.containsKey(tableMetaIdentify)) continue;
            tableMap.get(tableMetaIdentify).getTYPE().add(TableMetaWithType.tableTypeEnum.LOOKUP);
        }
    }

    private void clarifyPkFkCols(NDataModel dataModelDesc, Map<ColumnMetaIdentify, ColumnMetaWithType> columnMap) {
        for (JoinTableDesc joinTableDesc : dataModelDesc.getJoinTables()) {
            ColumnMetaIdentify columnMetaIdentify;
            JoinDesc joinDesc = joinTableDesc.getJoin();
            for (String pk : joinDesc.getPrimaryKey()) {
                columnMetaIdentify = this.getColumnMetaIdentify(dataModelDesc, pk);
                if (!columnMap.containsKey(columnMetaIdentify)) continue;
                columnMap.get(columnMetaIdentify).getTYPE().add(ColumnMetaWithType.columnTypeEnum.PK);
            }
            for (String fk : joinDesc.getForeignKey()) {
                columnMetaIdentify = this.getColumnMetaIdentify(dataModelDesc, fk);
                if (!columnMap.containsKey(columnMetaIdentify)) continue;
                columnMap.get(columnMetaIdentify).getTYPE().add(ColumnMetaWithType.columnTypeEnum.FK);
            }
        }
    }

    private ColumnMetaIdentify getColumnMetaIdentify(NDataModel model, String joinKey) {
        String tableName = joinKey.substring(0, joinKey.indexOf(46));
        String tableSchema = model.findTable(tableName).getTableIdentity().split("\\.")[0];
        String columnName = joinKey.substring(joinKey.indexOf(46) + 1);
        return new ColumnMetaIdentify(tableSchema, tableName, columnName);
    }

    protected String makeErrorMsgUserFriendly(Throwable e) {
        return QueryUtil.makeErrorMsgUserFriendly((Throwable)e);
    }

    private SQLResponse buildSqlResponse(boolean isPushDown, Iterable<List<String>> results, int resultSize, List<SelectedColumnMeta> columnMetas, String project) {
        SQLResponse response = new SQLResponse(columnMetas, results, resultSize, 0, false, null, QueryContext.current().getQueryTagInfo().isPartial(), isPushDown);
        QueryContext queryContext = QueryContext.current();
        response.wrapResultOfQueryContext(queryContext);
        response.setNativeRealizations(queryContext.getQueryRealizations());
        response.updateDataFetchTime(queryContext);
        if (queryContext.isExplainSql()) {
            response.setQueryPlan(queryContext.getQueryPlan());
            response.setExplain(queryContext.isExplainSql());
        }
        if (!queryContext.getQueryTagInfo().isVacant()) {
            this.setAppMaterURL(response);
        }
        if (isPushDown) {
            response.setEngineType(queryContext.getPushdownEngine());
            return response;
        }
        if (CollectionUtils.isEmpty(response.getNativeRealizations())) {
            QueryContext.current().getQueryTagInfo().setConstantQuery(true);
            response.setEngineType(QueryHistory.EngineType.CONSTANTS.name());
            return response;
        }
        response.setEngineType(QueryHistory.EngineType.NATIVE.name());
        response.setSignature(QueryCacheSignatureUtil.createCacheSignature(response, project));
        response.setVacant(QueryContext.current().getQueryTagInfo().isVacant());
        if (QueryContext.current().getMetrics().getQueryExecutedPlan() != null) {
            response.setExecutedPlan(QueryContext.current().getMetrics().getQueryExecutedPlan());
        }
        return response;
    }

    private void setAppMaterURL(SQLResponse response) {
        if (!KylinConfig.getInstanceFromEnv().isUTEnv()) {
            try {
                String executionID = QueryContext.current().getExecutionID();
                if (executionID != null && !executionID.isEmpty()) {
                    response.setAppMasterURL(this.sparderUIUtil.getSQLTrackingPath(executionID));
                }
            }
            catch (Throwable th) {
                logger.error("Get app master for sql failed", th);
            }
        }
    }

    public String onCreateAclSignature(String project) throws IOException {
        return this.createAclSignature(project);
    }

    public String createAclSignature(String project) throws IOException {
        String username;
        LinkedList aclTimes = Lists.newLinkedList();
        LinkedList aclNames = Lists.newLinkedList();
        QueryContext.AclInfo aclInfo = QueryContext.current().getAclInfo();
        if (aclInfo == null) {
            aclInfo = this.getExecuteAclInfo(project);
        }
        if (this.aclTCRService.hasAdminPermissionInProject(username = aclInfo.getUsername(), true, project)) {
            return "ADMIN";
        }
        AclTCRManager aclManager = AclTCRManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        Set userGroups = aclInfo.getGroups();
        List aclGroups = aclManager.getAclTCRs(username, userGroups);
        for (AclTCR group : aclGroups) {
            aclNames.add(group.resourceName());
            aclTimes.add(group.getLastModified());
        }
        return Joiner.on((String)";").join((Object)Joiner.on((String)"_").join((Iterable)aclNames), (Object)Joiner.on((String)"_").join((Iterable)aclTimes), new Object[0]);
    }

    private void applyModelPriority(QueryContext queryContext, RawSql rawSql) {
        queryContext.setModelPriorities(QueryModelPriorities.getModelPrioritiesFromHintStrOrComment((String)rawSql.getFirstHintString(), (String)rawSql.getFullTextString()));
    }

    public List<TableMetaWithType> getMetadataAddType(String project, String modelAlias) {
        List<TableMeta> tableMetas = this.getMetadata(project, modelAlias);
        LinkedHashMap tableMap = Maps.newLinkedHashMap();
        LinkedHashMap columnMap = Maps.newLinkedHashMap();
        for (TableMeta tableMeta : tableMetas) {
            TableMetaWithType tblMeta = TableMetaWithType.ofColumnMeta((TableMeta)tableMeta);
            tableMap.put(new TableMetaIdentify(tblMeta.getTABLE_SCHEM(), tblMeta.getTABLE_NAME()), tblMeta);
            for (ColumnMeta columnMeta : tblMeta.getColumns()) {
                columnMap.put(new ColumnMetaIdentify(columnMeta.getTABLE_SCHEM(), columnMeta.getTABLE_NAME(), columnMeta.getCOLUMN_NAME()), (ColumnMetaWithType)columnMeta);
            }
        }
        List<NDataModel> models = this.getModels(project, modelAlias);
        for (NDataModel model : models) {
            this.clarifyTblTypeToFactOrLookup(model, tableMap);
            this.clarifyPkFkCols(model, columnMap);
        }
        return Lists.newArrayList(tableMap.values());
    }

    private static /* synthetic */ void lambda$collectComputedColumns$30(SetMultimap tbl2ccNames, IRealization rea) {
        List upperCaseCcNames = rea.getModel().getComputedColumnNames().stream().map(str -> str.toUpperCase(Locale.ROOT)).collect(Collectors.toList());
        tbl2ccNames.putAll((Object)rea.getModel().getRootFactTable().getAlias().toUpperCase(Locale.ROOT), upperCaseCcNames);
        tbl2ccNames.putAll((Object)rea.getModel().getRootFactTableName().toUpperCase(Locale.ROOT), upperCaseCcNames);
    }

    private static /* synthetic */ SQLResponseTrace lambda$queryWithCache$12(QueryTrace.Span span) {
        if ("PREPARE_AND_SUBMIT_JOB".equals(span.getName())) {
            return new SQLResponseTrace("SPARK_JOB_EXECUTION", (String)QueryTrace.SPAN_GROUPS.get("SPARK_JOB_EXECUTION"), span.getDuration());
        }
        return new SQLResponseTrace(span.getName(), span.getGroup(), span.getDuration());
    }

    public static class ColumnMetaIdentify {
        private String tableSchema;
        private String tableName;
        private String columnName;

        @Generated
        public String getTableSchema() {
            return this.tableSchema;
        }

        @Generated
        public String getTableName() {
            return this.tableName;
        }

        @Generated
        public String getColumnName() {
            return this.columnName;
        }

        @Generated
        public void setTableSchema(String tableSchema) {
            this.tableSchema = tableSchema;
        }

        @Generated
        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Generated
        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ColumnMetaIdentify)) {
                return false;
            }
            ColumnMetaIdentify other = (ColumnMetaIdentify)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$tableSchema = this.getTableSchema();
            String other$tableSchema = other.getTableSchema();
            if (this$tableSchema == null ? other$tableSchema != null : !this$tableSchema.equals(other$tableSchema)) {
                return false;
            }
            String this$tableName = this.getTableName();
            String other$tableName = other.getTableName();
            if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
                return false;
            }
            String this$columnName = this.getColumnName();
            String other$columnName = other.getColumnName();
            return !(this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ColumnMetaIdentify;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $tableSchema = this.getTableSchema();
            result = result * 59 + ($tableSchema == null ? 43 : $tableSchema.hashCode());
            String $tableName = this.getTableName();
            result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
            String $columnName = this.getColumnName();
            result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "QueryService.ColumnMetaIdentify(tableSchema=" + this.getTableSchema() + ", tableName=" + this.getTableName() + ", columnName=" + this.getColumnName() + ")";
        }

        @Generated
        public ColumnMetaIdentify(String tableSchema, String tableName, String columnName) {
            this.tableSchema = tableSchema;
            this.tableName = tableName;
            this.columnName = columnName;
        }
    }

    public static class TableMetaIdentify {
        private String tableSchema;
        private String tableName;

        @Generated
        public String getTableSchema() {
            return this.tableSchema;
        }

        @Generated
        public String getTableName() {
            return this.tableName;
        }

        @Generated
        public void setTableSchema(String tableSchema) {
            this.tableSchema = tableSchema;
        }

        @Generated
        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableMetaIdentify)) {
                return false;
            }
            TableMetaIdentify other = (TableMetaIdentify)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$tableSchema = this.getTableSchema();
            String other$tableSchema = other.getTableSchema();
            if (this$tableSchema == null ? other$tableSchema != null : !this$tableSchema.equals(other$tableSchema)) {
                return false;
            }
            String this$tableName = this.getTableName();
            String other$tableName = other.getTableName();
            return !(this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TableMetaIdentify;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $tableSchema = this.getTableSchema();
            result = result * 59 + ($tableSchema == null ? 43 : $tableSchema.hashCode());
            String $tableName = this.getTableName();
            result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "QueryService.TableMetaIdentify(tableSchema=" + this.getTableSchema() + ", tableName=" + this.getTableName() + ")";
        }

        @Generated
        public TableMetaIdentify(String tableSchema, String tableName) {
            this.tableSchema = tableSchema;
            this.tableName = tableName;
        }
    }

    public static class LogReport {
        static final String QUERY_ID = "id";
        static final String SQL = "sql";
        static final String USER = "user";
        static final String SUCCESS = "success";
        static final String DURATION = "duration";
        static final String PROJECT = "project";
        static final String REALIZATION_NAMES = "realization";
        static final String INDEX_LAYOUT_IDS = "layout";
        static final String SNAPSHOTS = "snapshots";
        static final String IS_DERIVED = "is_derived";
        static final String SNAPSHOT_FILTERS = "snapshot_filters";
        static final String IS_PARTIAL_MATCH_MODEL = "is_partial_match";
        static final String SCAN_ROWS = "scan_rows";
        static final String TOTAL_SCAN_ROWS = "total_scan_rows";
        static final String SCAN_BYTES = "scan_bytes";
        static final String TOTAL_SCAN_BYTES = "total_scan_bytes";
        static final String RESULT_ROW_COUNT = "result_row_count";
        static final String SHUFFLE_PARTITIONS = "shuffle_partitions";
        static final String ACCEPT_PARTIAL = "accept_partial";
        static final String PARTIAL_RESULT = "is_partial_result";
        static final String HIT_EXCEPTION_CACHE = "hit_exception_cache";
        static final String STORAGE_CACHE_USED = "storage_cache_used";
        static final String STORAGE_CACHE_TYPE = "storage_cache_type";
        static final String DATA_FETCH_TIME = "data_fetch_time";
        static final String PUSH_DOWN = "push_down";
        static final String IS_PREPARE = "is_prepare";
        static final String TIMEOUT = "timeout";
        static final String TRACE_URL = "trace_url";
        static final String TIMELINE_SCHEMA = "timeline_schema";
        static final String TIMELINE = "timeline";
        static final String ERROR_MSG = "error_msg";
        static final String USER_TAG = "user_defined_tag";
        static final String PUSH_DOWN_FORCED = "push_down_forced";
        static final String INDEX_FORCED = "index_forced";
        static final String USER_AGENT = "user_agent";
        static final String BACK_DOOR_TOGGLES = "back_door_toggles";
        static final String SCAN_SEGMENT_COUNT = "scan_segment_count";
        static final String SCAN_FILE_COUNT = "scan_file_count";
        static final String REFUSE = "refuse";
        static final ImmutableMap<String, String> O2N = new ImmutableMap.Builder().put((Object)"id", (Object)"Query Id: ").put((Object)"sql", (Object)"SQL: ").put((Object)"user", (Object)"User: ").put((Object)"success", (Object)"Success: ").put((Object)"duration", (Object)"Duration: ").put((Object)"project", (Object)"Project: ").put((Object)"realization", (Object)"Realization Names: ").put((Object)"layout", (Object)"Index Layout Ids: ").put((Object)"is_derived", (Object)"Is Dervied: ").put((Object)"snapshots", (Object)"Snapshot Names: ").put((Object)"snapshot_filters", (Object)"Snapshot Filter: ").put((Object)"is_partial_match", (Object)"Is Partial Match Model: ").put((Object)"scan_rows", (Object)"Scan rows: ").put((Object)"total_scan_rows", (Object)"Total Scan rows: ").put((Object)"scan_bytes", (Object)"Scan bytes: ").put((Object)"total_scan_bytes", (Object)"Total Scan Bytes: ").put((Object)"result_row_count", (Object)"Result Row Count: ").put((Object)"shuffle_partitions", (Object)"Shuffle partitions: ").put((Object)"accept_partial", (Object)"Accept Partial: ").put((Object)"is_partial_result", (Object)"Is Partial Result: ").put((Object)"hit_exception_cache", (Object)"Hit Exception Cache: ").put((Object)"storage_cache_used", (Object)"Storage Cache Used: ").put((Object)"storage_cache_type", (Object)"Storage Cache Type: ").put((Object)"data_fetch_time", (Object)"Data Fetch Time: ").put((Object)"push_down", (Object)"Is Query Push-Down: ").put((Object)"is_prepare", (Object)"Is Prepare: ").put((Object)"timeout", (Object)"Is Timeout: ").put((Object)"trace_url", (Object)"Trace URL: ").put((Object)"timeline_schema", (Object)"Time Line Schema: ").put((Object)"timeline", (Object)"Time Line: ").put((Object)"error_msg", (Object)"Message: ").put((Object)"user_defined_tag", (Object)"User Defined Tag: ").put((Object)"push_down_forced", (Object)"Is forced to Push-Down: ").put((Object)"user_agent", (Object)"User Agent: ").put((Object)"back_door_toggles", (Object)"Back door toggles: ").put((Object)"scan_segment_count", (Object)"Scan Segment Count: ").put((Object)"scan_file_count", (Object)"Scan File Count: ").put((Object)"refuse", (Object)"Is Refused: ").build();
        private Map<String, Object> logs = new HashMap<String, Object>(100);

        public LogReport put(String key, String value) {
            if (!StringUtils.isEmpty((CharSequence)value)) {
                this.logs.put(key, value);
            }
            return this;
        }

        public LogReport put(String key, Object value) {
            if (value != null) {
                this.logs.put(key, value);
            }
            return this;
        }

        private String get(String key) {
            Object value = this.logs.get(key);
            if (value == null) {
                return "null";
            }
            return value.toString();
        }

        public String oldStyleLog() {
            String newLine = System.lineSeparator();
            String delimiter = "==========================[QUERY]===============================";
            return newLine + delimiter + newLine + (String)O2N.get((Object)QUERY_ID) + this.get(QUERY_ID) + newLine + (String)O2N.get((Object)SQL) + this.get(SQL) + newLine + (String)O2N.get((Object)USER) + this.get(USER) + newLine + (String)O2N.get((Object)SUCCESS) + this.get(SUCCESS) + newLine + (String)O2N.get((Object)DURATION) + this.get(DURATION) + newLine + (String)O2N.get((Object)PROJECT) + this.get(PROJECT) + newLine + (String)O2N.get((Object)REALIZATION_NAMES) + this.get(REALIZATION_NAMES) + newLine + (String)O2N.get((Object)INDEX_LAYOUT_IDS) + this.get(INDEX_LAYOUT_IDS) + newLine + (String)O2N.get((Object)IS_DERIVED) + this.get(IS_DERIVED) + newLine + (String)O2N.get((Object)SNAPSHOTS) + this.get(SNAPSHOTS) + newLine + (String)O2N.get((Object)SNAPSHOT_FILTERS) + this.get(SNAPSHOT_FILTERS) + newLine + (String)O2N.get((Object)IS_PARTIAL_MATCH_MODEL) + this.get(IS_PARTIAL_MATCH_MODEL) + newLine + (String)O2N.get((Object)SCAN_ROWS) + this.get(SCAN_ROWS) + newLine + (String)O2N.get((Object)TOTAL_SCAN_ROWS) + this.get(TOTAL_SCAN_ROWS) + newLine + (String)O2N.get((Object)SCAN_BYTES) + this.get(SCAN_BYTES) + newLine + (String)O2N.get((Object)TOTAL_SCAN_BYTES) + this.get(TOTAL_SCAN_BYTES) + newLine + (String)O2N.get((Object)RESULT_ROW_COUNT) + this.get(RESULT_ROW_COUNT) + newLine + (String)O2N.get((Object)SHUFFLE_PARTITIONS) + this.get(SHUFFLE_PARTITIONS) + newLine + (String)O2N.get((Object)ACCEPT_PARTIAL) + this.get(ACCEPT_PARTIAL) + newLine + (String)O2N.get((Object)PARTIAL_RESULT) + this.get(PARTIAL_RESULT) + newLine + (String)O2N.get((Object)HIT_EXCEPTION_CACHE) + this.get(HIT_EXCEPTION_CACHE) + newLine + (String)O2N.get((Object)STORAGE_CACHE_USED) + this.get(STORAGE_CACHE_USED) + newLine + (String)O2N.get((Object)STORAGE_CACHE_TYPE) + this.get(STORAGE_CACHE_TYPE) + newLine + (String)O2N.get((Object)DATA_FETCH_TIME) + this.get(DATA_FETCH_TIME) + newLine + (String)O2N.get((Object)PUSH_DOWN) + this.get(PUSH_DOWN) + newLine + (String)O2N.get((Object)IS_PREPARE) + this.get(IS_PREPARE) + newLine + (String)O2N.get((Object)TIMEOUT) + this.get(TIMEOUT) + newLine + (String)O2N.get((Object)TRACE_URL) + this.get(TRACE_URL) + newLine + (String)O2N.get((Object)TIMELINE_SCHEMA) + this.get(TIMELINE_SCHEMA) + newLine + (String)O2N.get((Object)TIMELINE) + this.get(TIMELINE) + newLine + (String)O2N.get((Object)ERROR_MSG) + this.get(ERROR_MSG) + newLine + (String)O2N.get((Object)USER_TAG) + this.get(USER_TAG) + newLine + (String)O2N.get((Object)PUSH_DOWN_FORCED) + this.get(PUSH_DOWN_FORCED) + newLine + (String)O2N.get((Object)USER_AGENT) + this.get(USER_AGENT) + newLine + (String)O2N.get((Object)BACK_DOOR_TOGGLES) + this.get(BACK_DOOR_TOGGLES) + newLine + (String)O2N.get((Object)SCAN_SEGMENT_COUNT) + this.get(SCAN_SEGMENT_COUNT) + newLine + (String)O2N.get((Object)SCAN_FILE_COUNT) + this.get(SCAN_FILE_COUNT) + newLine + (String)O2N.get((Object)REFUSE) + this.get(REFUSE) + newLine + delimiter + newLine;
        }

        public String jsonStyleLog() {
            return "[QUERY SUMMARY]: ".concat(new Gson().toJson(this.logs));
        }
    }
}

