/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.Body;
import com.github.sommeri.less4j.core.ast.BodyOwner;
import com.github.sommeri.less4j.core.ast.Directive;
import com.github.sommeri.less4j.core.ast.GeneralBody;
import com.github.sommeri.less4j.core.ast.RuleSet;
import com.github.sommeri.less4j.core.ast.Selector;
import com.github.sommeri.less4j.core.compiler.selectors.UselessLessElementsRemover;
import com.github.sommeri.less4j.core.compiler.stages.ASTManipulator;
import com.github.sommeri.less4j.core.compiler.stages.AstLogic;
import com.github.sommeri.less4j.core.compiler.stages.NestedInRulesetStack;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.List;

public class UnNestingAndBubbling {
    private final ASTManipulator manipulator = new ASTManipulator();
    private final UselessLessElementsRemover uselessLessElementsRemover = new UselessLessElementsRemover();

    public void unnestRulesetsAndDirectives(Body generalBody) {
        ArrayList<ASTCssNode> childs = new ArrayList<ASTCssNode>(generalBody.getChilds());
        block3: for (ASTCssNode kid : childs) {
            BodyOwner bodyOwner;
            switch (kid.getType()) {
                case RULE_SET: {
                    List<ASTCssNode> nestedRulesets = this.collectNestedRuleSets((RuleSet)kid);
                    this.manipulator.addIntoBody(nestedRulesets, kid);
                    this.uselessLessElementsRemover.removeFrom((RuleSet)kid);
                    continue block3;
                }
            }
            if (AstLogic.isBubleableDirective(kid)) {
                Directive directive = (Directive)kid;
                this.unnestRulesetsAndDirectives((Body)directive.getBody());
                continue;
            }
            if (!(kid instanceof BodyOwner) || (bodyOwner = (BodyOwner)((Object)kid)).getBody() == null) continue;
            this.unnestRulesetsAndDirectives((Body)bodyOwner.getBody());
        }
    }

    private List<ASTCssNode> collectNestedRuleSets(RuleSet topLevelNode) {
        NestedInRulesetStack nestedNodesStack = new NestedInRulesetStack(topLevelNode);
        this.collectChildRuleSets(topLevelNode, nestedNodesStack);
        return nestedNodesStack.getRulesets();
    }

    private void collectChildRuleSets(ASTCssNode ownerNode, NestedInRulesetStack nestedNodes) {
        ArrayList<? extends ASTCssNode> childs = new ArrayList<ASTCssNode>(ownerNode.getChilds());
        block3: for (ASTCssNode aSTCssNode : childs) {
            switch (aSTCssNode.getType()) {
                case RULE_SET: {
                    RuleSet nestedSet = (RuleSet)aSTCssNode;
                    this.manipulator.removeFromBody(nestedSet);
                    nestedNodes.collect(nestedSet);
                    nestedNodes.pushSelectors(nestedSet);
                    this.collectChildRuleSets(aSTCssNode, nestedNodes);
                    nestedNodes.popSelectors();
                    continue block3;
                }
            }
            if (AstLogic.isBubleableDirective(aSTCssNode)) {
                Directive directive = (Directive)aSTCssNode;
                this.manipulator.removeFromBody(directive);
                nestedNodes.collect(directive);
                if (!directive.bubleUpWithoutChanges()) {
                    List<Selector> outerSelectors = ArraysUtils.deeplyClonedList(nestedNodes.currentSelectors());
                    this.putBodyIntoRuleset(directive, outerSelectors);
                }
                this.unnestRulesetsAndDirectives((Body)directive.getBody());
                continue;
            }
            if (!(aSTCssNode instanceof BodyOwner)) {
                this.collectChildRuleSets(aSTCssNode, nestedNodes);
                continue;
            }
            BodyOwner bodyOwner = (BodyOwner)((Object)aSTCssNode);
            if (bodyOwner.getBody() == null) continue;
            this.unnestRulesetsAndDirectives((Body)bodyOwner.getBody());
        }
    }

    private void putBodyIntoRuleset(Directive bodyOwner, List<Selector> selectors) {
        RuleSet newRuleset = new RuleSet(bodyOwner.getUnderlyingStructure(), (GeneralBody)bodyOwner.getBody(), selectors);
        newRuleset.setVisibility(bodyOwner.getVisibility());
        GeneralBody newBodyForOwner = new GeneralBody(bodyOwner.getUnderlyingStructure());
        newBodyForOwner.setVisibility(bodyOwner.getVisibility());
        newBodyForOwner.addMember(newRuleset);
        bodyOwner.setBody(newBodyForOwner);
        newBodyForOwner.configureParentToAllChilds();
        bodyOwner.configureParentToAllChilds();
        newRuleset.configureParentToAllChilds();
    }
}

