
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.lang.instrument.Instrumentation;
import java.io.*;
import java.util.*;

public class Mng4747Agent
{

    public static void premain( String agentArgs, Instrumentation instrumentation )
    {
        try
        {
            Properties props = new Properties();
            props.put( Mng4747Agent.class.getName(), "" + Mng4747Agent.class.hashCode() );

            File file = new File( "target/agent.properties" );
            file.getParentFile().mkdirs();

            FileOutputStream fos = new FileOutputStream( file );
            try
            {
                props.store( fos, "MAVEN-CORE-IT" );
            }
            finally
            {
                fos.close();
            }
        }
        catch ( Exception e )
        {
            e.printStackTrace();
        }
    }

}
