/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.cipher;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.interfaces.ECKey;
import java.security.spec.ECField;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.OptionalFeature;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.digest.BuiltinDigests;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.digest.DigestFactory;
import org.apache.sshd.common.keyprovider.KeySizeIndicator;
import org.apache.sshd.common.keyprovider.KeyTypeIndicator;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.security.SecurityUtils;

public enum ECCurves implements KeyTypeIndicator,
KeySizeIndicator,
NamedResource,
OptionalFeature
{
    nistp256("nistp256", "secp256r1", new int[]{1, 2, 840, 10045, 3, 1, 7}, 32, BuiltinDigests.sha256),
    nistp384("nistp384", "secp384r1", new int[]{1, 3, 132, 0, 34}, 48, BuiltinDigests.sha384),
    nistp521("nistp521", "secp521r1", new int[]{1, 3, 132, 0, 35}, 66, BuiltinDigests.sha512);

    public static final Set<ECCurves> VALUES;
    public static final NavigableSet<String> NAMES;
    public static final NavigableSet<String> KEY_TYPES;
    public static final Comparator<ECCurves> BY_KEY_SIZE;
    public static final List<ECCurves> SORTED_KEY_SIZE;
    private final String name;
    private final String secName;
    private final String keyType;
    private final String oidString;
    private final List<Integer> oidValue;
    private final int numOctets;
    private final DigestFactory digestFactory;
    private ECParameterSpec params;
    private volatile int keySize = -1;

    private ECCurves(String name, String secName, int[] oid, int numOctets, DigestFactory digestFactory) {
        this.name = ValidateUtils.checkNotNullAndNotEmpty(name, "No curve name");
        this.secName = ValidateUtils.checkNotNullAndNotEmpty(secName, "No SEC curve name");
        this.oidString = NumberUtils.join('.', ValidateUtils.checkNotNullAndNotEmpty(oid, "No OID"));
        this.oidValue = Collections.unmodifiableList(NumberUtils.asList(oid));
        this.keyType = "ecdsa-sha2-" + name;
        this.numOctets = numOctets;
        this.digestFactory = Objects.requireNonNull(digestFactory, "No digestFactory");
    }

    private ECParameterSpec getParams(String secName) {
        try {
            AlgorithmParameters paramsFactory = SecurityUtils.getAlgorithmParameters("EC");
            paramsFactory.init(new ECGenParameterSpec(secName));
            return paramsFactory.getParameterSpec(ECParameterSpec.class);
        }
        catch (GeneralSecurityException e) {
            return null;
        }
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final String getOID() {
        return this.oidString;
    }

    public final List<Integer> getOIDValue() {
        return this.oidValue;
    }

    @Override
    public final String getKeyType() {
        return this.keyType;
    }

    @Override
    public final boolean isSupported() {
        return this.digestFactory.isSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ECParameterSpec getParameters() {
        ECCurves eCCurves = this;
        synchronized (eCCurves) {
            if (this.params == null) {
                this.params = ValidateUtils.checkNotNull(this.getParams(this.secName), "No EC params for %s", (Object)this.name);
            }
            return this.params;
        }
    }

    @Override
    public final int getKeySize() {
        int sz = this.keySize;
        if (sz < 0) {
            this.keySize = sz = ECCurves.getCurveSize(this.getParameters());
        }
        return sz;
    }

    public final int getNumPointOctets() {
        return this.numOctets;
    }

    public final Digest getDigestForParams() {
        return (Digest)this.digestFactory.create();
    }

    public static ECCurves fromKeyType(String type) {
        if (GenericUtils.isEmpty(type)) {
            return null;
        }
        for (ECCurves c : VALUES) {
            if (!type.equalsIgnoreCase(c.getKeyType())) continue;
            return c;
        }
        return null;
    }

    public static ECCurves fromCurveName(String name) {
        return NamedResource.findByName(name, String.CASE_INSENSITIVE_ORDER, VALUES);
    }

    public static ECCurves fromECKey(ECKey key) {
        return ECCurves.fromCurveParameters(key == null ? null : key.getParams());
    }

    public static ECCurves fromCurveParameters(ECParameterSpec params) {
        if (params == null) {
            return null;
        }
        return ECCurves.fromCurveSize(ECCurves.getCurveSize(params));
    }

    public static ECCurves fromCurveSize(int keySize) {
        if (keySize <= 0) {
            return null;
        }
        for (ECCurves c : VALUES) {
            if (keySize != c.getKeySize()) continue;
            return c;
        }
        return null;
    }

    public static ECCurves fromOIDValue(List<? extends Number> oid) {
        if (GenericUtils.isEmpty(oid)) {
            return null;
        }
        for (ECCurves c : VALUES) {
            List<Integer> v = c.getOIDValue();
            if (oid.size() != v.size()) continue;
            boolean matches = true;
            for (int index = 0; index < v.size(); ++index) {
                Number exp = v.get(index);
                Number act = oid.get(index);
                if (exp.intValue() == act.intValue()) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return c;
        }
        return null;
    }

    public static ECCurves fromOID(String oid) {
        if (GenericUtils.isEmpty(oid)) {
            return null;
        }
        for (ECCurves c : VALUES) {
            if (!oid.equalsIgnoreCase(c.getOID())) continue;
            return c;
        }
        return null;
    }

    public static int getCurveSize(ECParameterSpec params) {
        EllipticCurve curve = Objects.requireNonNull(params, "No EC params").getCurve();
        ECField field = Objects.requireNonNull(curve, "No EC curve").getField();
        return Objects.requireNonNull(field, "No EC field").getFieldSize();
    }

    public static byte[] encodeECPoint(ECPoint group, ECParameterSpec params) {
        return ECCurves.encodeECPoint(group, params.getCurve());
    }

    public static byte[] encodeECPoint(ECPoint group, EllipticCurve curve) {
        int elementSize = (curve.getField().getFieldSize() + 7) / 8;
        byte[] m = new byte[2 * elementSize + 1];
        m[0] = 4;
        byte[] affineX = ECCurves.removeLeadingZeroes(group.getAffineX().toByteArray());
        System.arraycopy(affineX, 0, m, 1 + elementSize - affineX.length, affineX.length);
        byte[] affineY = ECCurves.removeLeadingZeroes(group.getAffineY().toByteArray());
        System.arraycopy(affineY, 0, m, 1 + elementSize + elementSize - affineY.length, affineY.length);
        return m;
    }

    private static byte[] removeLeadingZeroes(byte[] input) {
        int pos;
        if (input[0] != 0) {
            return input;
        }
        for (pos = 1; pos < input.length - 1 && input[pos] == 0; ++pos) {
        }
        byte[] output = new byte[input.length - pos];
        System.arraycopy(input, pos, output, 0, output.length);
        return output;
    }

    public static BigInteger octetStringToInteger(byte ... octets) {
        if (octets == null) {
            return null;
        }
        if (octets.length == 0) {
            return BigInteger.ZERO;
        }
        return new BigInteger(1, octets);
    }

    public static ECPoint octetStringToEcPoint(byte ... octets) {
        if (NumberUtils.isEmpty(octets)) {
            return null;
        }
        int startIndex = ECCurves.findFirstNonZeroIndex(octets);
        if (startIndex < 0) {
            throw new IllegalArgumentException("All zeroes ECPoint N/A");
        }
        byte indicator = octets[startIndex];
        ECPointCompression compression = ECPointCompression.fromIndicatorValue(indicator);
        if (compression == null) {
            throw new UnsupportedOperationException("Unknown compression indicator value: 0x" + Integer.toHexString(indicator & 0xFF));
        }
        return compression.octetStringToEcPoint(octets, startIndex + 1, octets.length - startIndex - 1);
    }

    private static int findFirstNonZeroIndex(byte ... octets) {
        if (NumberUtils.isEmpty(octets)) {
            return -1;
        }
        for (int index = 0; index < octets.length; ++index) {
            if (octets[index] == 0) continue;
            return index;
        }
        return -1;
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(ECCurves.class));
        NAMES = Collections.unmodifiableNavigableSet(GenericUtils.mapSort(VALUES, ECCurves::getName, String.CASE_INSENSITIVE_ORDER));
        KEY_TYPES = Collections.unmodifiableNavigableSet(GenericUtils.mapSort(VALUES, ECCurves::getKeyType, String.CASE_INSENSITIVE_ORDER));
        BY_KEY_SIZE = (o1, o2) -> {
            int k1 = o1 == null ? Integer.MAX_VALUE : o1.getKeySize();
            int k2 = o2 == null ? Integer.MAX_VALUE : o2.getKeySize();
            return Integer.compare(k1, k2);
        };
        SORTED_KEY_SIZE = Collections.unmodifiableList(VALUES.stream().sorted(BY_KEY_SIZE).collect(Collectors.toList()));
    }

    public static final class Constants {
        public static final String ECDSA_SHA2_PREFIX = "ecdsa-sha2-";
        public static final String NISTP256 = "nistp256";
        public static final String NISTP384 = "nistp384";
        public static final String NISTP521 = "nistp521";

        private Constants() {
            throw new UnsupportedOperationException("No instance allowed");
        }
    }

    public static enum ECPointCompression {
        VARIANT2(2){

            @Override
            public ECPoint octetStringToEcPoint(byte[] octets, int startIndex, int len) {
                byte[] xp = new byte[len];
                System.arraycopy(octets, startIndex, xp, 0, len);
                BigInteger x = ECCurves.octetStringToInteger(xp);
                throw new UnsupportedOperationException("octetStringToEcPoint(" + this.name() + ")(X=" + x + ") compression support N/A");
            }
        }
        ,
        VARIANT3(3){

            @Override
            public ECPoint octetStringToEcPoint(byte[] octets, int startIndex, int len) {
                byte[] xp = new byte[len];
                System.arraycopy(octets, startIndex, xp, 0, len);
                BigInteger x = ECCurves.octetStringToInteger(xp);
                throw new UnsupportedOperationException("octetStringToEcPoint(" + this.name() + ")(X=" + x + ") compression support N/A");
            }
        }
        ,
        UNCOMPRESSED(4){

            @Override
            public ECPoint octetStringToEcPoint(byte[] octets, int startIndex, int len) {
                int numElements = len / 2;
                if (len != numElements * 2) {
                    throw new IllegalArgumentException("octetStringToEcPoint(" + this.name() + ")  invalid remainder octets representation:  expected=" + 2 * numElements + ", actual=" + len);
                }
                byte[] xp = new byte[numElements];
                byte[] yp = new byte[numElements];
                System.arraycopy(octets, startIndex, xp, 0, numElements);
                System.arraycopy(octets, startIndex + numElements, yp, 0, numElements);
                BigInteger x = ECCurves.octetStringToInteger(xp);
                BigInteger y = ECCurves.octetStringToInteger(yp);
                return new ECPoint(x, y);
            }

            @Override
            public void writeECPoint(OutputStream s, String curveName, ECPoint p) throws IOException {
                ECCurves curve = ECCurves.fromCurveName(curveName);
                if (curve == null) {
                    throw new StreamCorruptedException("writeECPoint(" + this.name() + ")[" + curveName + "] cannot determine octets count");
                }
                int numElements = curve.getNumPointOctets();
                KeyEntryResolver.encodeInt(s, 1 + 2 * numElements);
                s.write(this.getIndicatorValue());
                this.writeCoordinate(s, "X", p.getAffineX(), numElements);
                this.writeCoordinate(s, "Y", p.getAffineY(), numElements);
            }
        };

        public static final Set<ECPointCompression> VALUES;
        private final byte indicatorValue;

        private ECPointCompression(byte indicator) {
            this.indicatorValue = indicator;
        }

        public final byte getIndicatorValue() {
            return this.indicatorValue;
        }

        public abstract ECPoint octetStringToEcPoint(byte[] var1, int var2, int var3);

        public byte[] ecPointToOctetString(String curveName, ECPoint p) {
            byte[] byArray;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(196);
            try {
                this.writeECPoint(baos, curveName, p);
                byArray = baos.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        baos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("ecPointToOctetString(" + curveName + ") failed (" + e.getClass().getSimpleName() + ") to write data: " + e.getMessage(), e);
                }
            }
            baos.close();
            return byArray;
        }

        public void writeECPoint(OutputStream s, String curveName, ECPoint p) throws IOException {
            if (s == null) {
                throw new EOFException("No output stream");
            }
            throw new StreamCorruptedException("writeECPoint(" + this.name() + ")[" + p + "] N/A");
        }

        protected void writeCoordinate(OutputStream s, String n, BigInteger v, int numElements) throws IOException {
            byte[] vp = v.toByteArray();
            int startIndex = 0;
            int vLen = vp.length;
            if (vLen > numElements && vp[0] == 0) {
                ++startIndex;
                --vLen;
            }
            if (vLen > numElements) {
                throw new StreamCorruptedException("writeCoordinate(" + this.name() + ")[" + n + "] value length (" + vLen + ") exceeds max. (" + numElements + ") for " + v);
            }
            if (vLen < numElements) {
                byte[] tmp = new byte[numElements];
                System.arraycopy(vp, startIndex, tmp, numElements - vLen, vLen);
                vp = tmp;
                startIndex = 0;
                vLen = vp.length;
            }
            s.write(vp, startIndex, vLen);
        }

        public static ECPointCompression fromIndicatorValue(int value) {
            if (value < 0 || value > 255) {
                return null;
            }
            for (ECPointCompression c : VALUES) {
                if (value != c.getIndicatorValue()) continue;
                return c;
            }
            return null;
        }

        static {
            VALUES = Collections.unmodifiableSet(EnumSet.allOf(ECPointCompression.class));
        }
    }
}

