/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi;

import jakarta.faces.FacesException;
import jakarta.faces.context.ExternalContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.myfaces.spi.FacesConfigResourceProvider;
import org.apache.myfaces.spi.impl.DefaultFacesConfigResourceProviderFactory;
import org.apache.myfaces.spi.impl.SpiUtils;

public abstract class FacesConfigResourceProviderFactory {
    protected static final String FACTORY_DEFAULT = DefaultFacesConfigResourceProviderFactory.class.getName();
    private static final String FACTORY_KEY = FacesConfigResourceProviderFactory.class.getName();

    public static FacesConfigResourceProviderFactory getFacesConfigResourceProviderFactory(ExternalContext ctx) {
        FacesConfigResourceProviderFactory instance = (FacesConfigResourceProviderFactory)ctx.getApplicationMap().get(FACTORY_KEY);
        if (instance != null) {
            return instance;
        }
        FacesConfigResourceProviderFactory lpf = null;
        try {
            if (System.getSecurityManager() != null) {
                final ExternalContext ectx = ctx;
                lpf = (FacesConfigResourceProviderFactory)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws PrivilegedActionException {
                        return SpiUtils.build(ectx, FacesConfigResourceProviderFactory.class, FACTORY_DEFAULT);
                    }
                });
            } else {
                lpf = (FacesConfigResourceProviderFactory)SpiUtils.build(ctx, FacesConfigResourceProviderFactory.class, FACTORY_DEFAULT);
            }
        }
        catch (PrivilegedActionException pae) {
            throw new FacesException((Throwable)pae);
        }
        if (lpf != null) {
            FacesConfigResourceProviderFactory.setFacesConfigResourceProviderFactory(ctx, lpf);
        }
        return lpf;
    }

    public static void setFacesConfigResourceProviderFactory(ExternalContext ctx, FacesConfigResourceProviderFactory instance) {
        ctx.getApplicationMap().put(FACTORY_KEY, instance);
    }

    public abstract FacesConfigResourceProvider createFacesConfigResourceProvider(ExternalContext var1);
}

