/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config.annotation;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.util.lang.ClassUtils;

class PackageInfo {
    private static final Logger LOG = Logger.getLogger(PackageInfo.class.getName());

    PackageInfo() {
    }

    public static Class[] getClasses(String pckgname) throws ClassNotFoundException {
        Enumeration<URL> resources;
        ClassLoader cld;
        String path;
        ArrayList<Class> classes = new ArrayList<Class>();
        try {
            path = pckgname.replace('.', '/');
            cld = ClassUtils.getContextClassLoader();
            if (cld == null) {
                throw new ClassNotFoundException("Can't get class loader.");
            }
            resources = cld.getResources(path);
            if (resources == null || !resources.hasMoreElements()) {
                throw new ClassNotFoundException("No resource for " + path);
            }
        }
        catch (IOException | NullPointerException e) {
            throw new ClassNotFoundException(pckgname + " does not appear to be a valid package", e);
        }
        while (resources.hasMoreElements()) {
            File file;
            URL resource = resources.nextElement();
            URLConnection connection = null;
            try {
                connection = resource.openConnection();
            }
            catch (IOException e) {
                throw new ClassNotFoundException(pckgname + " does not appear to be a valid package", e);
            }
            if (connection instanceof JarURLConnection) {
                JarURLConnection juc = (JarURLConnection)connection;
                JarFile jarFile = null;
                try {
                    jarFile = juc.getJarFile();
                }
                catch (IOException e) {
                    throw new ClassNotFoundException(pckgname + " does not appear to be a valid package", e);
                }
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry jarEntry = entries.nextElement();
                    String entryName = jarEntry.getName();
                    if (!entryName.startsWith(path) || !entryName.toLowerCase().endsWith(".class")) continue;
                    String className = PackageInfo.filenameToClassname(entryName);
                    PackageInfo.loadClass(classes, cld, className);
                }
                continue;
            }
            try {
                file = new File(connection.getURL().toURI());
            }
            catch (URISyntaxException e) {
                LOG.log(Level.WARNING, "error loading directory " + String.valueOf(connection), e);
                continue;
            }
            PackageInfo.listFilesRecursive(classes, file, cld, pckgname);
        }
        if (classes.size() < 1) {
            throw new ClassNotFoundException(pckgname + " does not appear to be a valid package");
        }
        Class[] resolvedClasses = new Class[classes.size()];
        classes.toArray(resolvedClasses);
        return resolvedClasses;
    }

    protected static String filenameToClassname(String entryName) {
        return entryName.substring(0, entryName.length() - 6).replace('/', '.');
    }

    protected static void loadClass(List<Class> classes, ClassLoader cld, String className) {
        try {
            classes.add(cld.loadClass(className));
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            LOG.log(Level.WARNING, "error loading class " + className, e);
        }
    }

    protected static void listFilesRecursive(final List<Class> classes, File base, final ClassLoader cld, final String pckgname) {
        base.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    PackageInfo.listFilesRecursive(classes, file, cld, pckgname + "." + file.getName());
                    return false;
                }
                if (!file.getName().toLowerCase().endsWith(".class")) {
                    return false;
                }
                String className = PackageInfo.filenameToClassname(pckgname + "." + file.getName());
                PackageInfo.loadClass(classes, cld, className);
                return false;
            }
        });
    }
}

