/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.inputHtml;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.UserRoleUtils;
import org.apache.myfaces.custom.inputHtml.InputHtml;
import org.apache.myfaces.custom.tabbedpane.AbstractHtmlPanelTabbedPane;
import org.apache.myfaces.custom.tabbedpane.HtmlPanelTab;
import org.apache.myfaces.custom.tabbedpane.HtmlPanelTabbedPane;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.HTMLEncoder;

public class InputHtmlRenderer
extends HtmlRenderer {
    private static final Log log = LogFactory.getLog(HtmlRendererUtils.class);

    protected boolean isDisabled(FacesContext facesContext, UIComponent uiComponent) {
        if (!UserRoleUtils.isEnabledOnUserRole(uiComponent)) {
            return false;
        }
        return ((InputHtml)uiComponent).isDisabled();
    }

    private static boolean useFallback(InputHtml editor) {
        return editor.getFallback().equals("true");
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext context, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(context, uiComponent, InputHtml.class);
        UIComponent compositeFacet = uiComponent.getFacet("javax.faces.component.COMPOSITE_FACET_NAME");
        if (compositeFacet == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)("facet UIComponent.COMPOSITE_FACET_NAME not found when rendering composite component " + uiComponent.getClientId(context)));
            }
            return;
        }
        InputHtml editor = (InputHtml)uiComponent;
        if (HtmlRendererUtils.isDisplayValueOnly((UIComponent)editor)) {
            this.encodeDisplayValueOnly(context, editor);
        } else if (InputHtmlRenderer.useFallback(editor)) {
            this.encodeEndFallBackMode(context, editor);
        } else if (!this.isVisible(editor)) {
            this.encodeHidden(context, editor);
        } else if (!InputHtmlRenderer.hasThisPageAlreadyRenderedAnInputHtml(context)) {
            compositeFacet.encodeAll(context);
            InputHtmlRenderer.setThisPageAlreadyRenderedAnInputHtml(context);
        } else {
            log.warn((Object)("Only one inputHtml can be displayed at the same time. The component will be rendered isung a textarea.\nConpoment : " + RendererUtils.getPathToComponent((UIComponent)editor)));
            this.encodeEndFallBackMode(context, editor);
        }
    }

    private static boolean hasThisPageAlreadyRenderedAnInputHtml(FacesContext context) {
        return context.getExternalContext().getRequestMap().containsKey(InputHtmlRenderer.class.getName());
    }

    private static void setThisPageAlreadyRenderedAnInputHtml(FacesContext context) {
        context.getExternalContext().getRequestMap().put(InputHtmlRenderer.class.getName(), Boolean.TRUE);
    }

    private boolean isVisible(InputHtml editor) {
        for (Object parent = editor.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof HtmlPanelTab)) continue;
            HtmlPanelTab panelTab = (HtmlPanelTab)parent;
            AbstractHtmlPanelTabbedPane panelTabbedPane = null;
            for (UIComponent panelAncestor = panelTab.getParent(); panelAncestor != null; panelAncestor = panelAncestor.getParent()) {
                if (!(panelAncestor instanceof HtmlPanelTabbedPane)) continue;
                panelTabbedPane = (HtmlPanelTabbedPane)panelAncestor;
                break;
            }
            if (panelTabbedPane != null) {
                if (panelTabbedPane.isClientSide()) {
                    parent = panelTabbedPane;
                    continue;
                }
                int selectedIndex = ((HtmlPanelTabbedPane)panelTabbedPane).getSelectedIndex();
                List children = panelTabbedPane.getChildren();
                int tabIdx = 0;
                int len = children.size();
                for (int i = 0; i < len && tabIdx <= selectedIndex; ++i) {
                    UIComponent child = this.htmlTabbedPaneRenderer_getUIComponent((UIComponent)children.get(i));
                    if (!(child instanceof HtmlPanelTab)) continue;
                    if (child == panelTab) {
                        if (!child.isRendered() || tabIdx != selectedIndex) {
                            return false;
                        }
                        parent = panelTabbedPane;
                        continue;
                    }
                    ++tabIdx;
                }
                continue;
            }
            log.debug((Object)("pannelTabbedPane == null for component " + RendererUtils.getPathToComponent((UIComponent)panelTab)));
        }
        return true;
    }

    private UIComponent htmlTabbedPaneRenderer_getUIComponent(UIComponent uiComponent) {
        if (uiComponent instanceof UIForm || uiComponent instanceof UINamingContainer) {
            List children = uiComponent.getChildren();
            int len = children.size();
            for (int i = 0; i < len; ++i) {
                uiComponent = this.htmlTabbedPaneRenderer_getUIComponent((UIComponent)children.get(i));
            }
        }
        return uiComponent;
    }

    private void encodeHidden(FacesContext context, InputHtml editor) throws IOException {
        String clientId = editor.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("textarea", (UIComponent)editor);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("style", (Object)"display:none", null);
        String text = RendererUtils.getStringValue(context, (UIComponent)editor);
        writer.writeText((Object)text, "value");
        writer.endElement("textarea");
    }

    private void encodeDisplayValueOnly(FacesContext context, InputHtml editor) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", (UIComponent)editor);
        HtmlRendererUtils.writeIdIfNecessary(writer, (UIComponent)editor, context);
        HtmlRendererUtils.renderDisplayValueOnlyAttributes((UIComponent)editor, writer);
        String text = RendererUtils.getStringValue(context, (UIComponent)editor);
        writer.write(editor.getHtmlBody(text));
        writer.endElement("span");
    }

    private void encodeEndFallBackMode(FacesContext context, InputHtml editor) throws IOException {
        String clientId = editor.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("textarea", (UIComponent)editor);
        writer.writeAttribute("name", (Object)clientId, null);
        HtmlRendererUtils.writeIdIfNecessary(writer, (UIComponent)editor, context);
        if (editor.getStyle() != null) {
            writer.writeAttribute("style", (Object)editor.getStyle(), null);
        }
        if (editor.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)editor.getStyleClass(), null);
        }
        if (this.isDisabled(context, (UIComponent)editor)) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        String text = RendererUtils.getStringValue(context, (UIComponent)editor);
        writer.write(InputHtmlRenderer.htmlToPlainText(text, editor));
        writer.endElement("textarea");
    }

    private static String htmlToPlainText(String html, InputHtml editor) {
        return editor.getHtmlBody(html).replaceAll("<br.*>", "\n").replaceAll("<.+?>", "");
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        RendererUtils.checkParamValidity(facesContext, uiComponent, InputHtml.class);
        InputHtml editor = (InputHtml)uiComponent;
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        String clientId = uiComponent.getClientId(facesContext);
        if (paramMap.containsKey(clientId)) {
            String submitedText = (String)paramMap.get(clientId);
            String htmlText = InputHtmlRenderer.useFallback(editor) ? HTMLEncoder.encode(submitedText, true, true) : submitedText;
            editor.setSubmittedValue(htmlText);
        } else {
            log.warn((Object)("There should always be a submitted value for an input if it is rendered, its form is submitted, and it was not originally rendered disabled or read-only.  You cannot submit a form after disabling an input element via javascript.  Consider setting read-only to true instead or resetting the disabled value back to false prior to form submission. Component : " + RendererUtils.getPathToComponent((UIComponent)editor)));
        }
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, InputHtml.class);
        InputHtml editor = (InputHtml)uiComponent;
        String submittedDocument = editor.getValueFromDocument((String)submittedValue);
        return RendererUtils.getConvertedUIOutputValue(facesContext, (UIOutput)editor, submittedDocument);
    }
}

