/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tomahawk.application.jsp;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_tomahawk.config.MyfacesConfig;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.JavascriptUtils;
import org.apache.myfaces.shared_tomahawk.webapp.webxml.ServletMapping;
import org.apache.myfaces.shared_tomahawk.webapp.webxml.WebXml;
import org.apache.myfaces.tomahawk.application.jsp.ViewResponseWrapper;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.Definition;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.TilesException;
import org.apache.tiles.access.TilesAccess;
import org.apache.tiles.context.BasicAttributeContext;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.definition.NoSuchDefinitionException;
import org.apache.tiles.factory.TilesContainerFactory;
import org.apache.tiles.impl.BasicTilesContainer;
import org.apache.tiles.preparer.NoSuchPreparerException;
import org.apache.tiles.preparer.ViewPreparer;
import org.apache.tiles.servlet.context.ServletTilesApplicationContext;
import org.apache.tiles.servlet.context.ServletTilesRequestContext;

public class JspTilesTwoViewHandlerImpl
extends ViewHandler {
    private ViewHandler _viewHandler;
    public static final String FORM_STATE_MARKER = "<!--@@JSF_FORM_STATE_MARKER@@-->";
    public static final int FORM_STATE_MARKER_LEN = "<!--@@JSF_FORM_STATE_MARKER@@-->".length();
    private static final Log log = LogFactory.getLog(JspTilesTwoViewHandlerImpl.class);
    private static final String TILES_DEF_EXT = ".tiles";
    private String tilesExtension = ".tiles";
    private static final String AFTER_VIEW_TAG_CONTENT_PARAM = JspTilesTwoViewHandlerImpl.class + ".AFTER_VIEW_TAG_CONTENT";

    public JspTilesTwoViewHandlerImpl(ViewHandler viewHandler) {
        this._viewHandler = viewHandler;
    }

    private void initContainer(ExternalContext context) {
        if (TilesAccess.getContainer((Object)context.getContext()) == null) {
            try {
                TilesContainerFactory factory = TilesContainerFactory.getFactory((Object)context.getContext());
                TilesContainer container = factory.createTilesContainer(context.getContext());
                TilesAccess.setContainer((Object)context.getContext(), (TilesContainer)container);
            }
            catch (Exception e) {
                throw new FacesException("Error reading tiles definitions : " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void renderView(FacesContext facesContext, UIViewRoot viewToRender) throws IOException, FacesException {
        if (viewToRender == null) {
            log.fatal((Object)"viewToRender must not be null");
            throw new NullPointerException("viewToRender must not be null");
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        String viewId = this.deriveViewId(externalContext, viewToRender.getViewId());
        if (viewId == null) {
            this._viewHandler.renderView(facesContext, viewToRender);
            return;
        }
        this.initContainer(externalContext);
        String tilesId = this.deriveTileFromViewId(viewId);
        TilesContainer container = TilesAccess.getContainer((Object)externalContext.getContext());
        Object[] requestObjects = new Object[]{externalContext.getRequest(), externalContext.getResponse()};
        if (container.isValidDefinition(tilesId, requestObjects)) {
            this.setViewId(viewToRender, viewId, facesContext);
            this.renderTilesView(facesContext, requestObjects, container, viewToRender, viewId, tilesId);
        } else {
            this._viewHandler.renderView(facesContext, viewToRender);
        }
    }

    private void renderTilesView(FacesContext facesContext, Object[] requestObjects, TilesContainer container, UIViewRoot viewToRender, String viewId, String tilesId) throws IOException {
        ExternalContext externalContext = facesContext.getExternalContext();
        this.handleCharacterEncoding(viewId, externalContext, viewToRender);
        container.startContext(requestObjects);
        try {
            this.buildTilesViewLikeContainer(externalContext, container, tilesId, requestObjects);
        }
        catch (TilesException e) {
            throw new FacesException((Throwable)e);
        }
        finally {
            container.endContext(requestObjects);
        }
        this.handleCharacterEncodingPostDispatch(externalContext);
        RenderKitFactory renderFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit renderKit = renderFactory.getRenderKit(facesContext, viewToRender.getRenderKitId());
        ServletResponse response = (ServletResponse)requestObjects[1];
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        if (responseWriter == null) {
            responseWriter = renderKit.createResponseWriter((Writer)response.getWriter(), null, ((HttpServletRequest)externalContext.getRequest()).getCharacterEncoding());
            facesContext.setResponseWriter(responseWriter);
        }
        ResponseWriter oldResponseWriter = responseWriter;
        StateMarkerAwareWriter stateAwareWriter = null;
        StateManager stateManager = facesContext.getApplication().getStateManager();
        if (stateManager.isSavingStateInClient(facesContext)) {
            stateAwareWriter = new StateMarkerAwareWriter();
            responseWriter = oldResponseWriter.cloneWithWriter((Writer)stateAwareWriter);
            facesContext.setResponseWriter(responseWriter);
        }
        this.actuallyRenderView(facesContext, viewToRender);
        if (stateManager.isSavingStateInClient(facesContext)) {
            stateAwareWriter.flushToWriter(response.getWriter());
        } else {
            stateManager.saveView(facesContext);
        }
        ViewResponseWrapper afterViewTagResponse = (ViewResponseWrapper)((Object)externalContext.getRequestMap().get(AFTER_VIEW_TAG_CONTENT_PARAM));
        externalContext.getRequestMap().remove(AFTER_VIEW_TAG_CONTENT_PARAM);
        if (afterViewTagResponse != null) {
            afterViewTagResponse.flushToWriter(response.getWriter(), facesContext.getExternalContext().getResponseCharacterEncoding());
        }
        response.flushBuffer();
    }

    private String deriveTileFromViewId(String viewId) {
        String tilesId = viewId;
        int idx = tilesId.lastIndexOf(46);
        tilesId = idx > 0 ? tilesId.substring(0, idx) + this.tilesExtension : tilesId + this.tilesExtension;
        return tilesId;
    }

    private String deriveViewId(ExternalContext externalContext, String viewId) {
        String suffix;
        ServletMapping servletMapping = JspTilesTwoViewHandlerImpl.getServletMapping(externalContext);
        String defaultSuffix = externalContext.getInitParameter("javax.faces.DEFAULT_SUFFIX");
        String string = suffix = defaultSuffix != null ? defaultSuffix : ".xhtml .jsp";
        if (servletMapping.isExtensionMapping()) {
            if (!viewId.endsWith(suffix)) {
                int dot = viewId.lastIndexOf(46);
                if (dot == -1) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Current viewId has no extension, appending default suffix " + suffix));
                    }
                    return viewId + suffix;
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Replacing extension of current viewId by suffix " + suffix));
                }
                return viewId.substring(0, dot) + suffix;
            }
            return viewId;
        }
        if (!viewId.endsWith(suffix)) {
            return null;
        }
        return viewId;
    }

    private void handleCharacterEncodingPostDispatch(ExternalContext externalContext) {
        if (externalContext.getRequest() instanceof HttpServletRequest) {
            HttpServletResponse response = (HttpServletResponse)externalContext.getResponse();
            HttpServletRequest request = (HttpServletRequest)externalContext.getRequest();
            HttpSession session = request.getSession(false);
            if (session != null) {
                session.setAttribute("javax.faces.request.charset", (Object)response.getCharacterEncoding());
            }
        }
    }

    private void handleCharacterEncoding(String viewId, ExternalContext externalContext, UIViewRoot viewToRender) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Dispatching to " + viewId));
        }
        if (externalContext.getResponse() instanceof ServletResponse) {
            ServletResponse response = (ServletResponse)externalContext.getResponse();
            response.setLocale(viewToRender.getLocale());
        }
    }

    private void buildTilesViewLikeContainer(ExternalContext externalContext, TilesContainer container, String definitionName, Object ... requestItems) throws TilesException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Render request recieved for definition '" + definitionName + "'"));
        }
        TilesRequestContext tilesRequest = ((BasicTilesContainer)container).getContextFactory().createRequestContext(container.getApplicationContext(), requestItems);
        Definition definition = ((BasicTilesContainer)container).getDefinitionsFactory().getDefinition(definitionName, tilesRequest);
        if (definition == null) {
            if (log.isWarnEnabled()) {
                String message = "Unable to find the definition '" + definitionName + "'";
                log.warn((Object)message);
            }
            throw new NoSuchDefinitionException(definitionName);
        }
        if (!this.isPermitted(tilesRequest, definition.getRole())) {
            log.info((Object)("Access to definition '" + definitionName + "' denied. User not in role '" + definition.getRole()));
            return;
        }
        AttributeContext originalContext = container.getAttributeContext(requestItems);
        BasicAttributeContext subContext = new BasicAttributeContext(originalContext);
        subContext.addMissing(definition.getAttributes());
        BasicAttributeContext.pushContext((AttributeContext)subContext, (TilesRequestContext)tilesRequest);
        try {
            if (definition.getPreparer() != null) {
                this.prepare(container, tilesRequest, definition.getPreparer(), true);
            }
            String dispatchPath = definition.getTemplate();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Dispatching to definition path '" + definition.getTemplate() + " '"));
            }
            if (!this.buildView(container, tilesRequest, externalContext, dispatchPath)) {
                return;
            }
        }
        catch (TilesException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)"Error rendering tile", (Throwable)e);
            throw new TilesException(e.getMessage(), e);
        }
        finally {
            BasicAttributeContext.popContext((TilesRequestContext)tilesRequest);
        }
    }

    private boolean isPermitted(TilesRequestContext request, String role) {
        if (role == null) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(role, ",");
        while (st.hasMoreTokens()) {
            if (!request.isUserInRole(st.nextToken())) continue;
            return true;
        }
        return false;
    }

    private void prepare(TilesContainer container, TilesRequestContext context, String preparerName, boolean ignoreMissing) throws TilesException {
        ViewPreparer preparer;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Prepare request received for '" + preparerName));
        }
        if ((preparer = ((BasicTilesContainer)container).getPreparerFactory().getPreparer(preparerName, context)) == null && ignoreMissing) {
            return;
        }
        if (preparer == null) {
            throw new NoSuchPreparerException("Preparer '" + preparerName + " not found");
        }
        AttributeContext attributeContext = BasicAttributeContext.getContext((TilesRequestContext)context);
        preparer.execute(context, attributeContext);
    }

    private boolean buildView(TilesContainer container, TilesRequestContext tilesRequest, ExternalContext externalContext, String viewId) throws IOException {
        boolean errorResponse;
        HttpServletResponse response = (HttpServletResponse)tilesRequest.getResponse();
        ViewResponseWrapper wrappedResponse = new ViewResponseWrapper(response);
        tilesRequest = new ServletTilesRequestContext(((ServletTilesApplicationContext)container.getApplicationContext()).getServletContext(), (HttpServletRequest)tilesRequest.getRequest(), (HttpServletResponse)wrappedResponse);
        tilesRequest.dispatch(viewId);
        tilesRequest = new ServletTilesRequestContext(((ServletTilesApplicationContext)container.getApplicationContext()).getServletContext(), (HttpServletRequest)tilesRequest.getRequest(), response);
        boolean bl = errorResponse = wrappedResponse.getStatus() < 200 || wrappedResponse.getStatus() > 299;
        if (errorResponse) {
            wrappedResponse.flushToWrappedResponse();
            return false;
        }
        externalContext.getRequestMap().put(AFTER_VIEW_TAG_CONTENT_PARAM, wrappedResponse);
        return true;
    }

    private void actuallyRenderView(FacesContext facesContext, UIViewRoot viewToRender) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.startDocument();
        viewToRender.encodeAll(facesContext);
        responseWriter.endDocument();
        responseWriter.flush();
    }

    private void setViewId(UIViewRoot viewToRender, String viewId, FacesContext facesContext) {
        viewToRender.setViewId(viewId);
        if (facesContext.getViewRoot() != null) {
            facesContext.getViewRoot().setViewId(viewId);
        }
    }

    private static ServletMapping getServletMapping(ExternalContext externalContext) {
        String servletPath = externalContext.getRequestServletPath();
        String requestPathInfo = externalContext.getRequestPathInfo();
        WebXml webxml = WebXml.getWebXml(externalContext);
        List mappings = webxml.getFacesServletMappings();
        boolean isExtensionMapping = requestPathInfo == null;
        int size = mappings.size();
        for (int i = 0; i < size; ++i) {
            String extension;
            ServletMapping servletMapping = (ServletMapping)mappings.get(i);
            if (servletMapping.isExtensionMapping() != isExtensionMapping) continue;
            String urlpattern = servletMapping.getUrlPattern();
            if (!(isExtensionMapping ? servletPath.endsWith(extension = urlpattern.substring(1, urlpattern.length())) : servletPath.equals(urlpattern = urlpattern.substring(0, urlpattern.length() - 2)))) continue;
            return servletMapping;
        }
        log.error((Object)("could not find pathMapping for servletPath = " + servletPath + " requestPathInfo = " + requestPathInfo));
        throw new IllegalArgumentException("could not find pathMapping for servletPath = " + servletPath + " requestPathInfo = " + requestPathInfo);
    }

    public Locale calculateLocale(FacesContext context) {
        return this._viewHandler.calculateLocale(context);
    }

    public String calculateRenderKitId(FacesContext context) {
        return this._viewHandler.calculateRenderKitId(context);
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        return this._viewHandler.createView(context, viewId);
    }

    public String getActionURL(FacesContext context, String viewId) {
        return this._viewHandler.getActionURL(context, viewId);
    }

    public String getResourceURL(FacesContext context, String path) {
        return this._viewHandler.getResourceURL(context, path);
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        return this._viewHandler.restoreView(context, viewId);
    }

    public void writeState(FacesContext context) throws IOException {
        this._viewHandler.writeState(context);
    }

    private static class StateMarkerAwareWriter
    extends Writer {
        private StringBuilder buf = new StringBuilder();

        public void close() throws IOException {
        }

        public void flush() throws IOException {
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            this.buf.append(cbuf, off, len);
        }

        public StringBuilder getStringBuilder() {
            return this.buf;
        }

        public void flushToWriter(Writer writer) throws IOException {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            StateManager stateManager = facesContext.getApplication().getStateManager();
            StringWriter stateWriter = new StringWriter();
            ResponseWriter realWriter = facesContext.getResponseWriter();
            facesContext.setResponseWriter(realWriter.cloneWithWriter((Writer)stateWriter));
            Object serializedView = stateManager.saveView(facesContext);
            stateManager.writeState(facesContext, serializedView);
            facesContext.setResponseWriter(realWriter);
            StringBuilder contentBuffer = this.getStringBuilder();
            String state = stateWriter.getBuffer().toString();
            ExternalContext extContext = facesContext.getExternalContext();
            if (JavascriptUtils.isJavascriptAllowed(extContext) && MyfacesConfig.getCurrentInstance(extContext).isViewStateJavascript()) {
                this.write(contentBuffer, 0, contentBuffer.length(), writer);
                writer.write(state);
            } else {
                int lastFormMarkerPos = 0;
                int formMarkerPos = 0;
                while ((formMarkerPos = contentBuffer.indexOf(JspTilesTwoViewHandlerImpl.FORM_STATE_MARKER, formMarkerPos)) > -1) {
                    this.write(contentBuffer, lastFormMarkerPos, formMarkerPos, writer);
                    writer.write(state);
                    lastFormMarkerPos = formMarkerPos += FORM_STATE_MARKER_LEN;
                }
                if (lastFormMarkerPos < contentBuffer.length()) {
                    this.write(contentBuffer, lastFormMarkerPos, contentBuffer.length(), writer);
                }
            }
        }

        private void write(StringBuilder contentBuffer, int beginIndex, int endIndex, Writer writer) throws IOException {
            int bufferSize = 2048;
            char[] bufToWrite = new char[bufferSize];
            for (int index = beginIndex; index < endIndex; index += bufferSize) {
                int maxSize = Math.min(bufferSize, endIndex - index);
                contentBuffer.getChars(index, index + maxSize, bufToWrite, 0);
                writer.write(bufToWrite, 0, maxSize);
            }
        }
    }
}

