/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap.command;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.nifi.bootstrap.command.BootstrapCommand;
import org.apache.nifi.bootstrap.command.BootstrapCommandProvider;
import org.apache.nifi.bootstrap.command.ManagementServerBootstrapCommand;
import org.apache.nifi.bootstrap.command.StandardBootstrapCommandProvider;
import org.apache.nifi.bootstrap.command.io.FileResponseStreamHandler;
import org.apache.nifi.bootstrap.command.io.HttpRequestMethod;
import org.apache.nifi.bootstrap.command.io.LoggerResponseStreamHandler;
import org.apache.nifi.bootstrap.command.io.ResponseStreamHandler;
import org.apache.nifi.bootstrap.command.process.ProcessHandleProvider;
import org.apache.nifi.bootstrap.configuration.ManagementServerPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DiagnosticsBootstrapCommandProvider
implements BootstrapCommandProvider {
    private static final String VERBOSE_REQUESTED = "--verbose";
    private static final String VERBOSE_QUERY = "verbose=true";
    private static final int FIRST_ARGUMENT = 1;
    private final ProcessHandleProvider processHandleProvider;

    DiagnosticsBootstrapCommandProvider(ProcessHandleProvider processHandleProvider) {
        this.processHandleProvider = Objects.requireNonNull(processHandleProvider, "Process Handle Provider required");
    }

    @Override
    public BootstrapCommand getBootstrapCommand(String[] arguments) {
        String verboseQuery = this.getVerboseQuery(arguments);
        ResponseStreamHandler responseStreamHandler = this.getDiagnosticsResponseStreamHandler(arguments);
        return new ManagementServerBootstrapCommand(this.processHandleProvider, HttpRequestMethod.GET, ManagementServerPath.HEALTH_DIAGNOSTICS, verboseQuery, 200, responseStreamHandler);
    }

    private String getVerboseQuery(String[] arguments) {
        String query = null;
        for (String argument : arguments) {
            if (!VERBOSE_REQUESTED.contentEquals(argument)) continue;
            query = VERBOSE_QUERY;
            break;
        }
        return query;
    }

    private ResponseStreamHandler getDiagnosticsResponseStreamHandler(String[] arguments) {
        ResponseStreamHandler responseStreamHandler;
        Optional<Path> outputPathFound = Arrays.stream(arguments).skip(1L).filter(Predicate.not(VERBOSE_REQUESTED::contentEquals)).findFirst().map(x$0 -> Paths.get(x$0, new String[0]));
        if (outputPathFound.isPresent()) {
            Path outputPath = outputPathFound.get();
            responseStreamHandler = new FileResponseStreamHandler(outputPath);
        } else {
            Logger logger = LoggerFactory.getLogger(StandardBootstrapCommandProvider.class);
            responseStreamHandler = new LoggerResponseStreamHandler(logger);
        }
        return responseStreamHandler;
    }
}

