/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap.command.process;

import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.nifi.bootstrap.command.process.ProcessHandleProvider;
import org.apache.nifi.bootstrap.configuration.ConfigurationProvider;
import org.apache.nifi.bootstrap.configuration.SystemProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualMachineProcessHandleProvider
implements ProcessHandleProvider {
    private static final Logger logger = LoggerFactory.getLogger(VirtualMachineProcessHandleProvider.class);
    private final ConfigurationProvider configurationProvider;

    public VirtualMachineProcessHandleProvider(ConfigurationProvider configurationProvider) {
        this.configurationProvider = Objects.requireNonNull(configurationProvider);
    }

    @Override
    public Optional<ProcessHandle> findApplicationProcessHandle() {
        Path applicationProperties = this.configurationProvider.getApplicationProperties();
        return this.findProcessHandle(SystemProperty.APPLICATION_PROPERTIES, applicationProperties);
    }

    @Override
    public Optional<ProcessHandle> findBootstrapProcessHandle() {
        Path bootstrapConfiguration = this.configurationProvider.getBootstrapConfiguration();
        return this.findProcessHandle(SystemProperty.BOOTSTRAP_CONFIGURATION, bootstrapConfiguration);
    }

    private Optional<ProcessHandle> findProcessHandle(SystemProperty systemProperty, Path configuration) {
        VirtualMachineDescriptor virtualMachineDescriptor;
        String virtualMachineId;
        ProcessHandle currentProcessHandle = ProcessHandle.current();
        String currentProcessId = Long.toString(currentProcessHandle.pid());
        Optional<ProcessHandle> processHandleFound = Optional.empty();
        List<VirtualMachineDescriptor> virtualMachineDescriptors = VirtualMachine.list();
        Iterator<VirtualMachineDescriptor> iterator = virtualMachineDescriptors.iterator();
        while (iterator.hasNext() && (currentProcessId.equals(virtualMachineId = (virtualMachineDescriptor = iterator.next()).id()) || !(processHandleFound = this.findProcessHandle(virtualMachineDescriptor, systemProperty, configuration)).isPresent())) {
        }
        return processHandleFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<ProcessHandle> findProcessHandle(VirtualMachineDescriptor descriptor, SystemProperty systemProperty, Path configuration) {
        AttachProvider attachProvider = descriptor.provider();
        String virtualMachineId = descriptor.id();
        Optional<ProcessHandle> processHandle = Optional.empty();
        try {
            VirtualMachine virtualMachine = attachProvider.attachVirtualMachine(virtualMachineId);
            logger.debug("Attached Virtual Machine [{}]", (Object)virtualMachine.id());
            try {
                processHandle = this.findProcessHandle(virtualMachine, systemProperty, configuration);
            }
            finally {
                virtualMachine.detach();
            }
        }
        catch (Exception e) {
            logger.debug("Attach Virtual Machine [{}] failed", (Object)virtualMachineId, (Object)e);
        }
        return processHandle;
    }

    private Optional<ProcessHandle> findProcessHandle(VirtualMachine virtualMachine, SystemProperty systemProperty, Path configuration) throws IOException {
        Optional<ProcessHandle> processHandle;
        Properties systemProperties = virtualMachine.getSystemProperties();
        String configurationProperty = systemProperties.getProperty(systemProperty.getProperty());
        String configurationPath = configuration.toString();
        if (configurationPath.equals(configurationProperty)) {
            String virtualMachineId = virtualMachine.id();
            long processId = Long.parseLong(virtualMachineId);
            processHandle = ProcessHandle.of(processId);
        } else {
            processHandle = Optional.empty();
        }
        return processHandle;
    }
}

