/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.volume;

import java.io.IOException;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.fs.SpaceUsageCheckFactory;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.MutableVolumeSet;
import org.apache.hadoop.ozone.container.common.volume.StorageVolume;
import org.apache.hadoop.ozone.container.common.volume.StorageVolumeFactory;

public class HddsVolumeFactory
extends StorageVolumeFactory {
    public HddsVolumeFactory(ConfigurationSource conf, SpaceUsageCheckFactory usageCheckFactory, MutableVolumeSet volumeSet, String datanodeUuid, String clusterID) {
        super(conf, usageCheckFactory, volumeSet, datanodeUuid, clusterID);
    }

    @Override
    public StorageVolume createVolume(String locationString, StorageType storageType) throws IOException {
        HddsVolume.Builder volumeBuilder = (HddsVolume.Builder)((HddsVolume.Builder)((HddsVolume.Builder)((HddsVolume.Builder)((HddsVolume.Builder)((HddsVolume.Builder)new HddsVolume.Builder(locationString).conf(this.getConf())).datanodeUuid(this.getDatanodeUuid())).clusterID(this.getClusterID())).usageCheckFactory(this.getUsageCheckFactory())).storageType(storageType)).volumeSet(this.getVolumeSet());
        HddsVolume volume = volumeBuilder.build();
        this.checkAndSetClusterID(volume.getClusterID());
        return volume;
    }

    @Override
    public StorageVolume createFailedVolume(String locationString) throws IOException {
        HddsVolume.Builder volumeBuilder = (HddsVolume.Builder)new HddsVolume.Builder(locationString).failedVolume(true);
        return volumeBuilder.build();
    }
}

