/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.spi.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.ha.InterSCMGrpcClient;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.db.DBCheckpoint;
import org.apache.hadoop.hdds.utils.db.RocksDBCheckpoint;
import org.apache.hadoop.ozone.ClientVersion;
import org.apache.hadoop.ozone.recon.ReconContext;
import org.apache.hadoop.ozone.recon.ReconUtils;
import org.apache.hadoop.ozone.recon.scm.ReconStorageConfig;
import org.apache.hadoop.ozone.recon.security.ReconCertificateClient;
import org.apache.hadoop.ozone.recon.spi.StorageContainerServiceProvider;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ratis.proto.RaftProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageContainerServiceProviderImpl
implements StorageContainerServiceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(StorageContainerServiceProviderImpl.class);
    private StorageContainerLocationProtocol scmClient;
    private final OzoneConfiguration configuration;
    private File scmSnapshotDBParentDir;
    private ReconUtils reconUtils;
    private ReconStorageConfig reconStorage;
    private ReconContext reconContext;

    @Inject
    public StorageContainerServiceProviderImpl(StorageContainerLocationProtocol scmClient, ReconUtils reconUtils, OzoneConfiguration configuration, ReconStorageConfig reconStorage, ReconContext reconContext) {
        this.scmSnapshotDBParentDir = ReconUtils.getReconScmDbDir((ConfigurationSource)configuration);
        this.reconUtils = reconUtils;
        this.scmClient = scmClient;
        this.configuration = configuration;
        this.reconStorage = reconStorage;
        this.reconContext = reconContext;
    }

    @Override
    public List<Pipeline> getPipelines() throws IOException {
        return this.scmClient.listPipelines();
    }

    @Override
    public Pipeline getPipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        return this.scmClient.getPipeline(pipelineID);
    }

    @Override
    public ContainerWithPipeline getContainerWithPipeline(long containerId) throws IOException {
        return this.scmClient.getContainerWithPipeline(containerId);
    }

    @Override
    public List<ContainerWithPipeline> getExistContainerWithPipelinesInBatch(List<Long> containerIDs) {
        return this.scmClient.getExistContainerWithPipelinesInBatch(containerIDs);
    }

    @Override
    public List<HddsProtos.Node> getNodes() throws IOException {
        return this.scmClient.queryNode(null, null, HddsProtos.QueryScope.CLUSTER, "", ClientVersion.CURRENT_VERSION);
    }

    @Override
    public long getContainerCount() throws IOException {
        return this.scmClient.getContainerCount();
    }

    @Override
    public long getContainerCount(HddsProtos.LifeCycleState state) throws IOException {
        return this.scmClient.getContainerCount(state);
    }

    @Override
    public DBCheckpoint getSCMDBSnapshot() {
        String snapshotFileName = "scm.snapshot.db_" + System.currentTimeMillis();
        File targetFile = new File(this.scmSnapshotDBParentDir, snapshotFileName + ".tar");
        try {
            try {
                List ratisRoles = this.scmClient.getScmInfo().getPeerRoles();
                for (String ratisRole : ratisRoles) {
                    String[] role = ratisRole.split(":");
                    if (!role[2].equals(RaftProtos.RaftPeerRole.LEADER.toString())) continue;
                    String hostAddress = role[4].trim();
                    int grpcPort = this.configuration.getInt("ozone.scm.grpc.port", 9895);
                    SecurityConfig secConf = new SecurityConfig((ConfigurationSource)this.configuration);
                    SCMSecurityProtocolClientSideTranslatorPB scmSecurityClient = HddsServerUtil.getScmSecurityClientWithMaxRetry((OzoneConfiguration)this.configuration, (UserGroupInformation)UserGroupInformation.getCurrentUser());
                    try (ReconCertificateClient certClient = new ReconCertificateClient(secConf, scmSecurityClient, this.reconStorage, null, null);
                         InterSCMGrpcClient downloadClient = new InterSCMGrpcClient(hostAddress, grpcPort, (ConfigurationSource)this.configuration, (CertificateClient)certClient);){
                        downloadClient.download(targetFile.toPath()).get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        LOG.error("Rocks DB checkpoint downloading failed: {}", (Throwable)e);
                        throw new IOException(e);
                    }
                    LOG.info("Downloaded SCM Snapshot from Leader SCM");
                    break;
                }
            }
            catch (Throwable throwable) {
                LOG.error("Unexpected runtime error while downloading SCM Rocks DB snapshot/checkpoint : {}", throwable);
                throw throwable;
            }
            return this.getRocksDBCheckpoint(snapshotFileName, targetFile);
        }
        catch (Throwable e) {
            this.reconContext.updateHealthStatus(new AtomicBoolean(false));
            this.reconContext.getErrors().add(ReconContext.ErrorCode.GET_SCM_DB_SNAPSHOT_FAILED);
            LOG.error("Unable to obtain SCM DB Snapshot: {} ", e);
            return null;
        }
    }

    @NotNull
    private RocksDBCheckpoint getRocksDBCheckpoint(String snapshotFileName, File targetFile) throws IOException {
        Path untarredDbDir = Paths.get(this.scmSnapshotDBParentDir.getAbsolutePath(), snapshotFileName);
        this.reconUtils.untarCheckpointFile(targetFile, untarredDbDir);
        FileUtils.deleteQuietly((File)targetFile);
        return new RocksDBCheckpoint(untarredDbDir);
    }

    @Override
    public List<ContainerInfo> getListOfContainers(long startContainerID, int count, HddsProtos.LifeCycleState state) throws IOException {
        return this.scmClient.getListOfContainers(startContainerID, count, state);
    }
}

