/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.key.OmKeyResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"openKeyTable", "bucketTable"})
public class OMAllocateBlockResponse
extends OmKeyResponse {
    private OmKeyInfo omKeyInfo;
    private long clientID;

    public OMAllocateBlockResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull OmKeyInfo omKeyInfo, long clientID, @Nonnull BucketLayout bucketLayout) {
        super(omResponse, bucketLayout);
        this.omKeyInfo = omKeyInfo;
        this.clientID = clientID;
    }

    public OMAllocateBlockResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull BucketLayout bucketLayout) {
        super(omResponse, bucketLayout);
        this.checkStatusNotOK();
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        String openKey = omMetadataManager.getOpenKey(this.omKeyInfo.getVolumeName(), this.omKeyInfo.getBucketName(), this.omKeyInfo.getKeyName(), this.clientID);
        omMetadataManager.getOpenKeyTable(this.getBucketLayout()).putWithBatch(batchOperation, (Object)openKey, (Object)this.omKeyInfo);
    }

    protected OmKeyInfo getOmKeyInfo() {
        return this.omKeyInfo;
    }

    protected long getClientID() {
        return this.clientID;
    }
}

