/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.proxy;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigType;

@ConfigGroup(prefix="hdds.scmclient")
public class SCMClientConfig {
    public static final String SCM_CLIENT_RPC_TIME_OUT = "rpc.timeout";
    public static final String SCM_CLIENT_FAILOVER_MAX_RETRY = "failover.max.retry";
    public static final String SCM_CLIENT_MAX_RETRY_TIMEOUT = "max.retry.timeout";
    public static final String SCM_CLIENT_RETRY_INTERVAL = "failover.retry.interval";
    @Config(key="rpc.timeout", defaultValue="15m", type=ConfigType.TIME, tags={ConfigTag.OZONE, ConfigTag.SCM, ConfigTag.CLIENT}, timeUnit=TimeUnit.MILLISECONDS, description="RpcClient timeout on waiting for the response from SCM. The default value is set to 15 minutes. If ipc.client.ping is set to true and this rpc-timeout is greater than the value of ipc.ping.interval, the effective value of the rpc-timeout is rounded up to multiple of ipc.ping.interval.")
    private long rpcTimeOut = 900000L;
    @Config(key="max.retry.timeout", defaultValue="10m", type=ConfigType.TIME, timeUnit=TimeUnit.MILLISECONDS, tags={ConfigTag.OZONE, ConfigTag.SCM, ConfigTag.CLIENT}, description="Max retry timeout for SCM Client")
    private long maxRetryTimeout = 600000L;
    @Config(key="failover.max.retry", defaultValue="15", type=ConfigType.INT, tags={ConfigTag.OZONE, ConfigTag.SCM, ConfigTag.CLIENT}, description="Max retry count for SCM Client when failover happens.")
    private int retryCount = 15;
    @Config(key="failover.retry.interval", defaultValue="2s", type=ConfigType.TIME, tags={ConfigTag.OZONE, ConfigTag.SCM, ConfigTag.CLIENT}, timeUnit=TimeUnit.MILLISECONDS, description="SCM Client timeout on waiting for the next connection retry to other SCM IP. The default value is set to 2 seconds. ")
    private long retryInterval = 2000L;

    public long getRpcTimeOut() {
        return this.rpcTimeOut;
    }

    public void setRpcTimeOut(long timeOut) {
        if (this.rpcTimeOut > Integer.MAX_VALUE) {
            this.rpcTimeOut = Integer.MAX_VALUE;
        }
        this.rpcTimeOut = timeOut;
    }

    public int getRetryCount() {
        long duration = this.getMaxRetryTimeout();
        int retryCountFromMaxTimeOut = (int)(duration / this.getRetryInterval());
        return retryCountFromMaxTimeOut > this.retryCount ? retryCountFromMaxTimeOut : this.retryCount;
    }

    public long getMaxRetryTimeout() {
        return this.maxRetryTimeout;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
    }

    public void setMaxRetryTimeout(long timeout) {
        this.maxRetryTimeout = timeout;
    }
}

