/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import com.google.common.base.Strings;
import com.google.protobuf.BlockingService;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.lang3.SystemUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.SecretKeyProtocolScm;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.protocolPB.SecretKeyProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.protocolPB.SecretKeyProtocolDatanodePB;
import org.apache.hadoop.hdds.protocolPB.SecretKeyProtocolOmPB;
import org.apache.hadoop.hdds.protocolPB.SecretKeyProtocolScmPB;
import org.apache.hadoop.hdds.ratis.ServerNotLeaderException;
import org.apache.hadoop.hdds.scm.proxy.SCMClientConfig;
import org.apache.hadoop.hdds.scm.proxy.SCMSecurityProtocolFailoverProxyProvider;
import org.apache.hadoop.hdds.scm.proxy.SecretKeyProtocolFailoverProxyProvider;
import org.apache.hadoop.hdds.scm.proxy.SingleSecretKeyProtocolProxyProvider;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.hdds.utils.Archiver;
import org.apache.hadoop.hdds.utils.CpuMetrics;
import org.apache.hadoop.hdds.utils.SignalLogger;
import org.apache.hadoop.hdds.utils.VersionInfo;
import org.apache.hadoop.hdds.utils.db.DBCheckpoint;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ShutdownHookManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HddsServerUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HddsServerUtil.class);
    private static final int SHUTDOWN_HOOK_PRIORITY = 0;
    public static final String OZONE_RATIS_SNAPSHOT_COMPLETE_FLAG_NAME = "OZONE_RATIS_SNAPSHOT_COMPLETE";

    private HddsServerUtil() {
    }

    public static void addPBProtocol(Configuration conf, Class<?> protocol, BlockingService service, RPC.Server server) {
        RPC.setProtocolEngine((Configuration)conf, protocol, ProtobufRpcEngine.class);
        server.addProtocol(RPC.RpcKind.RPC_PROTOCOL_BUFFER, protocol, (Object)service);
    }

    public static InetSocketAddress getScmClientBindAddress(ConfigurationSource conf) {
        String host = HddsUtils.getHostNameFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{"ozone.scm.client.bind.host"}).orElse("0.0.0.0");
        int port = HddsUtils.getPortNumberFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{"ozone.scm.client.address"}).orElse(conf.getInt("ozone.scm.client.port", 9860));
        return NetUtils.createSocketAddr((String)(host + ":" + port));
    }

    public static InetSocketAddress getScmBlockClientBindAddress(ConfigurationSource conf) {
        String host = HddsUtils.getHostNameFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{"ozone.scm.block.client.bind.host"}).orElse("0.0.0.0");
        int port = HddsUtils.getPortNumberFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{"ozone.scm.block.client.address"}).orElse(conf.getInt("ozone.scm.block.client.port", 9863));
        return NetUtils.createSocketAddr((String)(host + ":" + port));
    }

    public static InetSocketAddress getScmSecurityInetAddress(ConfigurationSource conf) {
        String host = HddsUtils.getHostNameFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{"ozone.scm.security.service.bind.host"}).orElse("0.0.0.0");
        OptionalInt port = HddsUtils.getPortNumberFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{"ozone.scm.security.service.address"});
        return NetUtils.createSocketAddr((String)(host + ":" + port.orElse(conf.getInt("ozone.scm.security.service.port", 9961))));
    }

    public static InetSocketAddress getScmDataNodeBindAddress(ConfigurationSource conf) {
        Optional host = HddsUtils.getHostNameFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{"ozone.scm.datanode.bind.host"});
        OptionalInt port = HddsUtils.getPortNumberFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{"ozone.scm.datanode.address"});
        return NetUtils.createSocketAddr((String)(host.orElse("0.0.0.0") + ":" + port.orElse(conf.getInt("ozone.scm.datanode.port", 9861))));
    }

    public static InetSocketAddress getReconDataNodeBindAddress(ConfigurationSource conf) {
        Optional host = HddsUtils.getHostNameFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{"ozone.recon.datanode.bind.host"});
        OptionalInt port = HddsUtils.getPortNumberFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{"ozone.recon.datanode.address"});
        return NetUtils.createSocketAddr((String)(host.orElse("0.0.0.0") + ":" + port.orElse(9891)));
    }

    public static long getScmheartbeatCheckerInterval(ConfigurationSource conf) {
        return conf.getTimeDuration("ozone.scm.heartbeat.thread.interval", "3s", TimeUnit.MILLISECONDS);
    }

    public static long getScmHeartbeatInterval(ConfigurationSource conf) {
        return conf.getTimeDuration("hdds.heartbeat.interval", "30s", TimeUnit.MILLISECONDS);
    }

    public static long getScmInitialHeartbeatInterval(ConfigurationSource conf) {
        return conf.getTimeDuration("hdds.heartbeat.initial-interval", "2s", TimeUnit.MILLISECONDS);
    }

    public static long getReconHeartbeatInterval(ConfigurationSource conf) {
        return conf.getTimeDuration("hdds.heartbeat.recon.interval", "60s", TimeUnit.MILLISECONDS);
    }

    public static long getInitialReconHeartbeatInterval(ConfigurationSource conf) {
        return conf.getTimeDuration("hdds.heartbeat.recon.initial-interval", "2s", TimeUnit.MILLISECONDS);
    }

    public static long getStaleNodeInterval(ConfigurationSource conf) {
        long staleNodeIntervalMs = conf.getTimeDuration("ozone.scm.stale.node.interval", "5m", TimeUnit.MILLISECONDS);
        long heartbeatThreadFrequencyMs = HddsServerUtil.getScmheartbeatCheckerInterval(conf);
        long heartbeatIntervalMs = HddsServerUtil.getScmHeartbeatInterval(conf);
        staleNodeIntervalMs = ServerUtils.sanitizeUserArgs("ozone.scm.stale.node.interval", staleNodeIntervalMs, "ozone.scm.heartbeat.thread.interval", heartbeatThreadFrequencyMs, 5L, 1000L);
        staleNodeIntervalMs = ServerUtils.sanitizeUserArgs("ozone.scm.stale.node.interval", staleNodeIntervalMs, "hdds.heartbeat.interval", heartbeatIntervalMs, 3L, 1000L);
        return staleNodeIntervalMs;
    }

    public static long getDeadNodeInterval(ConfigurationSource conf) {
        long staleNodeIntervalMs = HddsServerUtil.getStaleNodeInterval(conf);
        long deadNodeIntervalMs = conf.getTimeDuration("ozone.scm.dead.node.interval", "10m", TimeUnit.MILLISECONDS);
        return ServerUtils.sanitizeUserArgs("ozone.scm.dead.node.interval", deadNodeIntervalMs, "ozone.scm.stale.node.interval", staleNodeIntervalMs, 2L, 1000L);
    }

    public static long getScmRpcTimeOutInMilliseconds(ConfigurationSource conf) {
        return conf.getTimeDuration("ozone.scm.heartbeat.rpc-timeout", "5s", TimeUnit.MILLISECONDS);
    }

    public static int getScmRpcRetryCount(ConfigurationSource conf) {
        return conf.getInt("ozone.scm.heartbeat.rpc-retry-count", 15);
    }

    public static long getScmRpcRetryInterval(ConfigurationSource conf) {
        return conf.getTimeDuration("ozone.scm.heartbeat.rpc-retry-interval", "1s", TimeUnit.MILLISECONDS);
    }

    public static int getLogWarnInterval(ConfigurationSource conf) {
        return conf.getInt("ozone.scm.heartbeat.log.warn.interval.count", 10);
    }

    public static int getContainerPort(ConfigurationSource conf) {
        return conf.getInt("hdds.container.ipc.port", 9859);
    }

    public static Collection<String> getOzoneDatanodeRatisDirectory(ConfigurationSource conf) {
        ArrayList<String> rawLocations = conf.getTrimmedStringCollection("hdds.container.ratis.datanode.storage.dir");
        if (rawLocations.isEmpty()) {
            rawLocations = new ArrayList<String>(1);
            rawLocations.add(ServerUtils.getDefaultRatisDirectory(conf));
        }
        return rawLocations;
    }

    public static long requiredReplicationSpace(long defaultContainerSize) {
        return 2L * defaultContainerSize;
    }

    public static Collection<String> getDatanodeStorageDirs(ConfigurationSource conf) {
        Collection rawLocations = conf.getTrimmedStringCollection("hdds.datanode.dir");
        if (rawLocations.isEmpty()) {
            throw new IllegalArgumentException("No location configured in hdds.datanode.dir");
        }
        return rawLocations;
    }

    public static Collection<String> getDatanodeDbDirs(ConfigurationSource conf) {
        return conf.getTrimmedStringCollection("hdds.datanode.container.db.dir");
    }

    public static String getDatanodeIdFilePath(ConfigurationSource conf) {
        String dataNodeIDDirPath = conf.getTrimmed("ozone.scm.datanode.id.dir");
        if (Strings.isNullOrEmpty((String)dataNodeIDDirPath)) {
            File metaDirPath = ServerUtils.getOzoneMetaDirPath(conf);
            if (metaDirPath == null) {
                throw new IllegalArgumentException("Unable to locate meta datadirectory when getting datanode id path");
            }
            dataNodeIDDirPath = metaDirPath.toString();
        }
        return new File(dataNodeIDDirPath, "datanode.id").toString();
    }

    public static SCMSecurityProtocolClientSideTranslatorPB getScmSecurityClient(ConfigurationSource conf) throws IOException {
        SecurityConfig.initSecurityProvider((ConfigurationSource)conf);
        return new SCMSecurityProtocolClientSideTranslatorPB(new SCMSecurityProtocolFailoverProxyProvider(conf, UserGroupInformation.getCurrentUser()));
    }

    public static SCMSecurityProtocolClientSideTranslatorPB getScmSecurityClientWithMaxRetry(OzoneConfiguration conf, UserGroupInformation ugi) throws IOException {
        OzoneConfiguration configuration = new OzoneConfiguration((Configuration)conf);
        SecurityConfig.initSecurityProvider((ConfigurationSource)configuration);
        SCMClientConfig scmClientConfig = (SCMClientConfig)conf.getObject(SCMClientConfig.class);
        int retryCount = Integer.MAX_VALUE;
        scmClientConfig.setRetryCount(retryCount);
        configuration.setFromObject((Object)scmClientConfig);
        return new SCMSecurityProtocolClientSideTranslatorPB(new SCMSecurityProtocolFailoverProxyProvider((ConfigurationSource)configuration, ugi == null ? UserGroupInformation.getCurrentUser() : ugi));
    }

    public static SCMSecurityProtocolClientSideTranslatorPB getScmSecurityClient(OzoneConfiguration conf, UserGroupInformation ugi) throws IOException {
        SecurityConfig.initSecurityProvider((ConfigurationSource)conf);
        SCMSecurityProtocolClientSideTranslatorPB scmSecurityClient = new SCMSecurityProtocolClientSideTranslatorPB(new SCMSecurityProtocolFailoverProxyProvider((ConfigurationSource)conf, ugi));
        return (SCMSecurityProtocolClientSideTranslatorPB)TracingUtil.createProxy((Object)scmSecurityClient, SCMSecurityProtocolClientSideTranslatorPB.class, (ConfigurationSource)conf);
    }

    public static SecretKeyProtocolScm getSecretKeyClientForSCM(ConfigurationSource conf) throws IOException {
        SecretKeyProtocolClientSideTranslatorPB scmSecretClient = new SecretKeyProtocolClientSideTranslatorPB(new SecretKeyProtocolFailoverProxyProvider<SecretKeyProtocolScmPB>(conf, UserGroupInformation.getCurrentUser(), SecretKeyProtocolScmPB.class), SecretKeyProtocolScmPB.class);
        return (SecretKeyProtocolScm)TracingUtil.createProxy((Object)scmSecretClient, SecretKeyProtocolScm.class, (ConfigurationSource)conf);
    }

    public static SecretKeyProtocolClientSideTranslatorPB getSecretKeyClientForDatanode(ConfigurationSource conf) throws IOException {
        return new SecretKeyProtocolClientSideTranslatorPB(new SecretKeyProtocolFailoverProxyProvider<SecretKeyProtocolDatanodePB>(conf, UserGroupInformation.getCurrentUser(), SecretKeyProtocolDatanodePB.class), SecretKeyProtocolDatanodePB.class);
    }

    public static SecretKeyProtocolClientSideTranslatorPB getSecretKeyClientForOm(ConfigurationSource conf) throws IOException {
        return new SecretKeyProtocolClientSideTranslatorPB(new SecretKeyProtocolFailoverProxyProvider<SecretKeyProtocolOmPB>(conf, UserGroupInformation.getCurrentUser(), SecretKeyProtocolOmPB.class), SecretKeyProtocolOmPB.class);
    }

    public static SecretKeyProtocolClientSideTranslatorPB getSecretKeyClientForDatanode(ConfigurationSource conf, UserGroupInformation ugi) {
        return new SecretKeyProtocolClientSideTranslatorPB(new SecretKeyProtocolFailoverProxyProvider<SecretKeyProtocolDatanodePB>(conf, ugi, SecretKeyProtocolDatanodePB.class), SecretKeyProtocolDatanodePB.class);
    }

    public static SecretKeyProtocolClientSideTranslatorPB getSecretKeyClientForScm(ConfigurationSource conf, String scmNodeId, UserGroupInformation ugi) {
        return new SecretKeyProtocolClientSideTranslatorPB(new SingleSecretKeyProtocolProxyProvider<SecretKeyProtocolScmPB>(conf, ugi, SecretKeyProtocolScmPB.class, scmNodeId), SecretKeyProtocolScmPB.class);
    }

    public static MetricsSystem initializeMetrics(OzoneConfiguration configuration, String serverName) {
        MetricsSystem metricsSystem = DefaultMetricsSystem.initialize((String)serverName);
        try {
            JvmMetrics.create((String)serverName, (String)configuration.get("hdds.metrics.session-id"), (MetricsSystem)DefaultMetricsSystem.instance());
            CpuMetrics.create();
        }
        catch (MetricsException e) {
            LOG.info("Metrics source JvmMetrics already added to DataNode.");
        }
        return metricsSystem;
    }

    public static void writeDBCheckpointToStream(DBCheckpoint checkpoint, OutputStream destination, Set<String> toExcludeList) throws IOException {
        try (ArchiveOutputStream<TarArchiveEntry> archiveOutputStream = Archiver.tar(destination);
             Stream<Path> files = Files.list(checkpoint.getCheckpointLocation());){
            for (Path path : files.collect(Collectors.toList())) {
                String fileName;
                Path fileNamePath;
                if (path == null || (fileNamePath = path.getFileName()) == null || toExcludeList.contains(fileName = fileNamePath.toString())) continue;
                Archiver.includeFile(path.toFile(), fileName, archiveOutputStream);
            }
            HddsServerUtil.includeRatisSnapshotCompleteFlag(archiveOutputStream);
        }
    }

    public static void includeRatisSnapshotCompleteFlag(ArchiveOutputStream<TarArchiveEntry> archiveOutput) throws IOException {
        File file = File.createTempFile(OZONE_RATIS_SNAPSHOT_COMPLETE_FLAG_NAME, "");
        Archiver.includeFile(file, OZONE_RATIS_SNAPSHOT_COMPLETE_FLAG_NAME, archiveOutput);
    }

    static boolean ratisSnapshotComplete(Path dir) {
        return new File(dir.toString(), OZONE_RATIS_SNAPSHOT_COMPLETE_FLAG_NAME).exists();
    }

    public static UserGroupInformation getRemoteUser() throws IOException {
        UserGroupInformation ugi = Server.getRemoteUser();
        return ugi != null ? ugi : UserGroupInformation.getCurrentUser();
    }

    public static void addSuppressedLoggingExceptions(RPC.Server server) {
        server.addSuppressedLoggingExceptions(new Class[]{ServerNotLeaderException.class});
    }

    public static void startupShutdownMessage(VersionInfo versionInfo, Class<?> clazz, String[] args, Logger log, OzoneConfiguration conf) {
        String hostname = NetUtils.getHostname();
        String className = clazz.getSimpleName();
        if (log.isInfoEnabled()) {
            log.info(HddsServerUtil.createStartupMessage(versionInfo, className, hostname, args, HddsUtils.processForLogging((OzoneConfiguration)conf)));
        }
        if (SystemUtils.IS_OS_UNIX) {
            try {
                SignalLogger.INSTANCE.register(log);
            }
            catch (Throwable t) {
                log.warn("failed to register any UNIX signal loggers: ", t);
            }
        }
        ShutdownHookManager.get().addShutdownHook(() -> log.info(HddsServerUtil.toStartupShutdownString("SHUTDOWN_MSG: ", "Shutting down " + className + " at " + hostname)), 0);
    }

    public static String toStartupShutdownString(String prefix, String ... msg) {
        StringBuilder b = new StringBuilder(prefix);
        b.append("\n/************************************************************");
        for (String s : msg) {
            b.append('\n').append(prefix).append(s);
        }
        b.append("\n************************************************************/");
        return b.toString();
    }

    private static String createStartupMessage(VersionInfo versionInfo, String className, String hostname, String[] args, Map<String, String> conf) {
        return HddsServerUtil.toStartupShutdownString("STARTUP_MSG: ", "Starting " + className, "       host = " + hostname, "    version = " + versionInfo.getVersion(), "      build = " + versionInfo.getUrl() + "/" + versionInfo.getRevision(), "       java = " + System.getProperty("java.version"), "       args = " + (args != null ? Arrays.asList(args) : new ArrayList()), "  classpath = " + System.getProperty("java.class.path"), "       conf = " + conf);
    }
}

