/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(FetchMetrics.class);
    private transient MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
    private transient JsonFactory jsonFactory = new JsonFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMetrics(String qry) {
        try {
            ByteArrayOutputStream opStream = new ByteArrayOutputStream();
            try (JsonGenerator jg = null;){
                jg = this.jsonFactory.createGenerator((OutputStream)opStream, JsonEncoding.UTF8);
                jg.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
                jg.useDefaultPrettyPrinter();
                jg.writeStartObject();
                if (qry == null) {
                    qry = "*:*";
                }
                this.listBeans(jg, new ObjectName(qry));
            }
            return new String(opStream.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (IOException | MalformedObjectNameException ex) {
            LOG.error("Caught an exception while processing getMetrics request", (Throwable)ex);
            return null;
        }
    }

    private void listBeans(JsonGenerator jg, ObjectName qry) throws IOException {
        LOG.debug("Listing beans for " + qry);
        Set<ObjectName> names = null;
        names = this.mBeanServer.queryNames(qry, null);
        jg.writeArrayFieldStart("beans");
        for (ObjectName oname : names) {
            MBeanAttributeInfo[] attrs;
            MBeanInfo minfo;
            String code = "";
            try {
                minfo = this.mBeanServer.getMBeanInfo(oname);
                code = minfo.getClassName();
                String prs = "";
                try {
                    if ("org.apache.commons.modeler.BaseModelMBean".equals(code)) {
                        prs = "modelerType";
                        code = (String)this.mBeanServer.getAttribute(oname, prs);
                    }
                }
                catch (RuntimeException | AttributeNotFoundException | MBeanException | ReflectionException ex) {
                    LOG.error("getting attribute " + prs + " of " + oname + " threw an exception", (Throwable)ex);
                }
            }
            catch (InstanceNotFoundException var17) {
                continue;
            }
            catch (IntrospectionException | ReflectionException ex) {
                LOG.error("Problem while trying to process JMX query: " + qry + " with MBean " + oname, (Throwable)ex);
                continue;
            }
            jg.writeStartObject();
            jg.writeStringField("name", oname.toString());
            jg.writeStringField("modelerType", code);
            for (MBeanAttributeInfo attr : attrs = minfo.getAttributes()) {
                this.writeAttribute(jg, oname, attr);
            }
            jg.writeEndObject();
        }
        jg.writeEndArray();
    }

    private void writeAttribute(JsonGenerator jg, ObjectName oname, MBeanAttributeInfo attr) throws IOException {
        String attName;
        if (attr.isReadable() && !"modelerType".equals(attName = attr.getName()) && attName.indexOf("=") < 0 && attName.indexOf(":") < 0 && attName.indexOf(" ") < 0) {
            Object value = null;
            try {
                value = this.mBeanServer.getAttribute(oname, attName);
            }
            catch (RuntimeMBeanException var7) {
                if (var7.getCause() instanceof UnsupportedOperationException) {
                    LOG.debug("getting attribute " + attName + " of " + oname + " threw an exception", (Throwable)var7);
                } else {
                    LOG.error("getting attribute " + attName + " of " + oname + " threw an exception", (Throwable)var7);
                }
                return;
            }
            catch (RuntimeErrorException var8) {
                LOG.error("getting attribute {} of {} threw an exception", new Object[]{attName, oname, var8});
                return;
            }
            catch (RuntimeException | MBeanException | ReflectionException ex) {
                LOG.error("getting attribute " + attName + " of " + oname + " threw an exception", (Throwable)ex);
                return;
            }
            catch (AttributeNotFoundException | InstanceNotFoundException ex) {
                return;
            }
            this.writeAttribute(jg, attName, value);
        }
    }

    private void writeAttribute(JsonGenerator jg, String attName, Object value) throws IOException {
        jg.writeFieldName(attName);
        this.writeObject(jg, value);
    }

    private void writeObject(JsonGenerator jg, Object value) throws IOException {
        if (value == null) {
            jg.writeNull();
        } else {
            Class<?> c = value.getClass();
            if (c.isArray()) {
                jg.writeStartArray();
                int len = Array.getLength(value);
                for (int j = 0; j < len; ++j) {
                    Object entry = Array.get(value, j);
                    this.writeObject(jg, entry);
                }
                jg.writeEndArray();
            } else if (value instanceof Number) {
                Number n = (Number)value;
                jg.writeNumber(n.toString());
            } else if (value instanceof Boolean) {
                Boolean b = (Boolean)value;
                jg.writeBoolean(b.booleanValue());
            } else if (value instanceof CompositeData) {
                CompositeData cds = (CompositeData)value;
                CompositeType comp = cds.getCompositeType();
                Set<String> keys = comp.keySet();
                jg.writeStartObject();
                for (String key : keys) {
                    this.writeAttribute(jg, key, cds.get(key));
                }
                jg.writeEndObject();
            } else if (value instanceof TabularData) {
                TabularData tds = (TabularData)value;
                jg.writeStartArray();
                for (Object entry : tds.values()) {
                    this.writeObject(jg, entry);
                }
                jg.writeEndArray();
            } else {
                jg.writeString(value.toString());
            }
        }
    }
}

