/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node.states;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.DatanodeID;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.node.DatanodeInfo;
import org.apache.hadoop.hdds.scm.node.NodeStatus;
import org.apache.hadoop.hdds.scm.node.states.DatanodeEntry;
import org.apache.hadoop.hdds.scm.node.states.NodeAlreadyExistsException;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;

public class NodeStateMap {
    private final Map<DatanodeID, DatanodeEntry> nodeMap = new HashMap<DatanodeID, DatanodeEntry>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public void addNode(DatanodeInfo datanode) throws NodeAlreadyExistsException {
        DatanodeID id = datanode.getID();
        this.lock.writeLock().lock();
        try {
            if (this.nodeMap.containsKey(id)) {
                throw new NodeAlreadyExistsException(id);
            }
            this.nodeMap.put(id, new DatanodeEntry(datanode));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void removeNode(DatanodeID datanodeID) {
        this.lock.writeLock().lock();
        try {
            this.nodeMap.remove(datanodeID);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatanodeInfo updateNode(DatanodeInfo datanode) throws NodeNotFoundException {
        DatanodeInfo oldInfo;
        DatanodeID id = datanode.getID();
        this.lock.writeLock().lock();
        try {
            oldInfo = this.getNodeInfo(id);
            if (oldInfo == null) {
                throw new NodeNotFoundException(id);
            }
            this.nodeMap.put(id, new DatanodeEntry(datanode));
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return oldInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeStatus updateNodeHealthState(DatanodeID nodeId, HddsProtos.NodeState newHealth) throws NodeNotFoundException {
        this.lock.writeLock().lock();
        try {
            DatanodeInfo dn = this.getExisting(nodeId).getInfo();
            NodeStatus newStatus = dn.getNodeStatus().newNodeState(newHealth);
            dn.setNodeStatus(newStatus);
            NodeStatus nodeStatus = newStatus;
            return nodeStatus;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeStatus updateNodeOperationalState(DatanodeID nodeId, HddsProtos.NodeOperationalState newOpState, long opStateExpiryEpochSeconds) throws NodeNotFoundException {
        this.lock.writeLock().lock();
        try {
            DatanodeInfo dn = this.getExisting(nodeId).getInfo();
            NodeStatus newStatus = dn.getNodeStatus().newOperationalState(newOpState, opStateExpiryEpochSeconds);
            dn.setNodeStatus(newStatus);
            NodeStatus nodeStatus = newStatus;
            return nodeStatus;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public DatanodeInfo getNodeInfo(DatanodeID datanodeID) throws NodeNotFoundException {
        this.lock.readLock().lock();
        try {
            DatanodeInfo datanodeInfo = this.getExisting(datanodeID).getInfo();
            return datanodeInfo;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getNodeCount() {
        this.lock.readLock().lock();
        try {
            int n = this.nodeMap.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<DatanodeInfo> getAllDatanodeInfos() {
        this.lock.readLock().lock();
        try {
            List<DatanodeInfo> list = this.nodeMap.values().stream().map(DatanodeEntry::getInfo).collect(Collectors.toList());
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<DatanodeInfo> getDatanodeInfos(NodeStatus status) {
        return this.filterNodes(NodeStateMap.matching(status));
    }

    public List<DatanodeInfo> getDatanodeInfos(HddsProtos.NodeOperationalState opState, HddsProtos.NodeState health) {
        return opState != null && health != null ? this.filterNodes(NodeStateMap.matching(opState, health)) : (opState != null ? this.filterNodes(NodeStateMap.matching(opState)) : (health != null ? this.filterNodes(NodeStateMap.matching(health)) : this.getAllDatanodeInfos()));
    }

    public int getNodeCount(NodeStatus status) {
        return this.countNodes(NodeStateMap.matching(status));
    }

    public int getNodeCount(HddsProtos.NodeOperationalState opState, HddsProtos.NodeState health) {
        return opState != null && health != null ? this.countNodes(NodeStateMap.matching(opState, health)) : (opState != null ? this.countNodes(NodeStateMap.matching(opState)) : (health != null ? this.countNodes(NodeStateMap.matching(health)) : this.getTotalNodeCount()));
    }

    public int getTotalNodeCount() {
        this.lock.readLock().lock();
        try {
            int n = this.nodeMap.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public NodeStatus getNodeStatus(DatanodeID datanodeID) throws NodeNotFoundException {
        this.lock.readLock().lock();
        try {
            NodeStatus nodeStatus = this.getExisting(datanodeID).getInfo().getNodeStatus();
            return nodeStatus;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void addContainer(DatanodeID datanodeID, ContainerID containerId) throws NodeNotFoundException {
        this.lock.writeLock().lock();
        try {
            this.getExisting(datanodeID).add(containerId);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void setContainersForTesting(DatanodeID id, Set<ContainerID> containers) throws NodeNotFoundException {
        this.lock.writeLock().lock();
        try {
            this.getExisting(id).setContainersForTesting(containers);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Set<ContainerID> getContainers(DatanodeID id) throws NodeNotFoundException {
        this.lock.readLock().lock();
        try {
            Set<ContainerID> set = this.getExisting(id).copyContainers();
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getContainerCount(DatanodeID datanodeID) throws NodeNotFoundException {
        this.lock.readLock().lock();
        try {
            int n = this.getExisting(datanodeID).getContainerCount();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void removeContainer(DatanodeID datanodeID, ContainerID containerID) throws NodeNotFoundException {
        this.lock.writeLock().lock();
        try {
            this.getExisting(datanodeID).remove(containerID);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Total number of nodes: ").append(this.getTotalNodeCount());
        return builder.toString();
    }

    private DatanodeEntry getExisting(DatanodeID id) throws NodeNotFoundException {
        DatanodeEntry entry = this.nodeMap.get(id);
        if (entry == null) {
            throw new NodeNotFoundException(id);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countNodes(Predicate<DatanodeInfo> filter) {
        long count;
        this.lock.readLock().lock();
        try {
            count = this.nodeMap.values().stream().map(DatanodeEntry::getInfo).filter(filter).count();
        }
        finally {
            this.lock.readLock().unlock();
        }
        return Math.toIntExact(count);
    }

    private List<DatanodeInfo> filterNodes(Predicate<DatanodeInfo> filter) {
        this.lock.readLock().lock();
        try {
            List<DatanodeInfo> list = this.nodeMap.values().stream().map(DatanodeEntry::getInfo).filter(filter).collect(Collectors.toList());
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private static Predicate<DatanodeInfo> matching(NodeStatus status) {
        return dn -> status.equals(dn.getNodeStatus());
    }

    private static Predicate<DatanodeInfo> matching(HddsProtos.NodeOperationalState op, HddsProtos.NodeState health) {
        return dn -> NodeStateMap.matching(op).test((DatanodeInfo)((Object)dn)) && NodeStateMap.matching(health).test((DatanodeInfo)((Object)dn));
    }

    private static Predicate<DatanodeInfo> matching(HddsProtos.NodeOperationalState state) {
        return dn -> state.equals((Object)dn.getNodeStatus().getOperationalState());
    }

    private static Predicate<DatanodeInfo> matching(HddsProtos.NodeState health) {
        return dn -> health.equals((Object)dn.getNodeStatus().getHealth());
    }
}

