/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.io;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.scm.storage.BlockExtendedInputStream;
import org.apache.hadoop.hdds.scm.storage.ByteReaderStrategy;
import org.apache.hadoop.io.ByteBufferPool;
import org.apache.hadoop.ozone.client.io.ECBlockReconstructedStripeInputStream;

public class ECBlockReconstructedInputStream
extends BlockExtendedInputStream {
    private ECReplicationConfig repConfig;
    private ECBlockReconstructedStripeInputStream stripeReader;
    private ByteBuffer[] bufs;
    private final ByteBufferPool byteBufferPool;
    private boolean closed = false;
    private boolean unBuffered = false;
    private long position = 0L;

    public ECBlockReconstructedInputStream(ECReplicationConfig repConfig, ByteBufferPool byteBufferPool, ECBlockReconstructedStripeInputStream stripeReader) {
        this.repConfig = repConfig;
        this.byteBufferPool = byteBufferPool;
        this.stripeReader = stripeReader;
    }

    @Override
    public synchronized BlockID getBlockID() {
        return this.stripeReader.getBlockID();
    }

    @Override
    public synchronized long getRemaining() {
        return this.getLength() - this.position;
    }

    @Override
    public synchronized long getLength() {
        return this.stripeReader.getLength();
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        return this.read(ByteBuffer.wrap(b, off, len));
    }

    @Override
    public synchronized int read(ByteBuffer buf) throws IOException {
        this.ensureNotClosed();
        if (!this.hasRemaining()) {
            return -1;
        }
        this.allocateBuffers();
        if (this.unBuffered) {
            this.seek(this.getPos());
            this.unBuffered = false;
        }
        int totalRead = 0;
        while (buf.hasRemaining() && this.getRemaining() > 0L) {
            ByteBuffer b = this.selectNextBuffer();
            if (b == null) {
                throw new IOException(this.getRemaining() + " bytes remaining but unable to select a buffer with data");
            }
            long read = this.readBufferToDest(b, buf);
            totalRead = (int)((long)totalRead + read);
        }
        if (!this.hasRemaining()) {
            this.freeBuffers();
        }
        return totalRead;
    }

    private void ensureNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException("The input stream is closed");
        }
    }

    private ByteBuffer selectNextBuffer() throws IOException {
        for (ByteBuffer b : this.bufs) {
            if (!b.hasRemaining()) continue;
            return b;
        }
        long read = this.readStripe();
        if (read == -1L) {
            return null;
        }
        return this.selectNextBuffer();
    }

    private long readBufferToDest(ByteBuffer src, ByteBuffer dest) {
        int initialRemaining = dest.remaining();
        while (dest.hasRemaining() && src.hasRemaining()) {
            dest.put(src.get());
        }
        int read = initialRemaining - dest.remaining();
        this.position += (long)read;
        return read;
    }

    @Override
    protected synchronized int readWithStrategy(ByteReaderStrategy strategy) throws IOException {
        throw new IOException("Not Implemented");
    }

    public synchronized void unbuffer() {
        this.stripeReader.unbuffer();
        this.freeBuffers();
        this.unBuffered = true;
    }

    @Override
    public synchronized long getPos() {
        return this.position;
    }

    @Override
    public synchronized void close() throws IOException {
        this.stripeReader.close();
        this.freeBuffers();
        this.closed = true;
    }

    private void freeBuffers() {
        if (this.bufs != null) {
            for (int i = 0; i < this.bufs.length; ++i) {
                this.byteBufferPool.putBuffer(this.bufs[i]);
                this.bufs[i] = null;
            }
            this.bufs = null;
        }
    }

    @Override
    public synchronized void seek(long pos) throws IOException {
        this.ensureNotClosed();
        if (pos < 0L || pos > this.getLength()) {
            if (pos == 0L) {
                return;
            }
            throw new EOFException("EOF encountered at pos: " + pos + " for block: " + this.getBlockID());
        }
        long stripeSize = (long)this.repConfig.getEcChunkSize() * (long)this.repConfig.getData();
        long stripeNum = pos / stripeSize;
        int partial = (int)(pos % stripeSize);
        this.stripeReader.seek(stripeNum * stripeSize);
        this.readAndSeekStripe(partial);
        this.position = pos;
    }

    private void readAndSeekStripe(int offset) throws IOException {
        this.allocateBuffers();
        this.readStripe();
        if (offset == 0) {
            return;
        }
        for (ByteBuffer b : this.bufs) {
            int newPos = Math.min(b.remaining(), offset);
            b.position(newPos);
            if ((offset -= newPos) == 0) break;
        }
    }

    private long readStripe() throws IOException {
        this.clearBuffers();
        return this.stripeReader.readStripe(this.bufs);
    }

    private void allocateBuffers() {
        if (this.bufs != null) {
            return;
        }
        this.bufs = new ByteBuffer[this.repConfig.getData()];
        for (int i = 0; i < this.repConfig.getData(); ++i) {
            this.bufs[i] = this.byteBufferPool.getBuffer(false, this.repConfig.getEcChunkSize());
            this.bufs[i].limit(0);
        }
    }

    private void clearBuffers() {
        for (ByteBuffer b : this.bufs) {
            b.clear();
            b.limit(this.repConfig.getEcChunkSize());
        }
    }

    private boolean hasRemaining() {
        return this.getRemaining() > 0L;
    }
}

