/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class S3VolumeContext {
    private final OmVolumeArgs omVolumeArgs;
    private final String userPrincipal;

    public S3VolumeContext(OmVolumeArgs omVolumeArgs, String userPrincipal) {
        this.omVolumeArgs = omVolumeArgs;
        this.userPrincipal = userPrincipal;
    }

    public OmVolumeArgs getOmVolumeArgs() {
        return this.omVolumeArgs;
    }

    public String getUserPrincipal() {
        return this.userPrincipal;
    }

    public static S3VolumeContext fromProtobuf(OzoneManagerProtocolProtos.GetS3VolumeContextResponse resp) {
        return new S3VolumeContext(OmVolumeArgs.getFromProtobuf(resp.getVolumeInfo()), resp.getUserPrincipal());
    }

    public OzoneManagerProtocolProtos.GetS3VolumeContextResponse getProtobuf() {
        return OzoneManagerProtocolProtos.GetS3VolumeContextResponse.newBuilder().setVolumeInfo(this.omVolumeArgs.getProtobuf()).setUserPrincipal(this.userPrincipal).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private OmVolumeArgs omVolumeArgs;
        private String userPrincipal;

        private Builder() {
        }

        public Builder setOmVolumeArgs(OmVolumeArgs omVolumeArgs) {
            this.omVolumeArgs = omVolumeArgs;
            return this;
        }

        public Builder setUserPrincipal(String userPrincipal) {
            this.userPrincipal = userPrincipal;
            return this;
        }

        public S3VolumeContext build() {
            return new S3VolumeContext(this.omVolumeArgs, this.userPrincipal);
        }
    }
}

