/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.lock;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import org.apache.hadoop.ozone.om.lock.LockUsageInfo;
import org.apache.hadoop.ozone.om.lock.OMLockDetails;
import org.apache.hadoop.ozone.om.lock.OMLockMetrics;

public interface IOzoneManagerLock {
    public OMLockDetails acquireReadLock(Resource var1, String ... var2);

    public OMLockDetails acquireReadLocks(Resource var1, Collection<String[]> var2);

    public OMLockDetails acquireWriteLock(Resource var1, String ... var2);

    public OMLockDetails acquireWriteLocks(Resource var1, Collection<String[]> var2);

    public OMLockDetails acquireResourceWriteLock(Resource var1);

    public boolean acquireMultiUserLock(String var1, String var2);

    public void releaseMultiUserLock(String var1, String var2);

    public OMLockDetails releaseWriteLock(Resource var1, String ... var2);

    public OMLockDetails releaseWriteLocks(Resource var1, Collection<String[]> var2);

    public OMLockDetails releaseResourceWriteLock(Resource var1);

    public OMLockDetails releaseReadLock(Resource var1, String ... var2);

    public OMLockDetails releaseReadLocks(Resource var1, Collection<String[]> var2);

    @VisibleForTesting
    public int getReadHoldCount(Resource var1, String ... var2);

    @VisibleForTesting
    public int getWriteHoldCount(Resource var1, String ... var2);

    @VisibleForTesting
    public boolean isWriteLockedByCurrentThread(Resource var1, String ... var2);

    public void cleanup();

    public OMLockMetrics getOMLockMetrics();

    public static class ResourceManager {
        private final ThreadLocal<LockUsageInfo> readLockTimeStampNanos = ThreadLocal.withInitial(LockUsageInfo::new);
        private final ThreadLocal<LockUsageInfo> writeLockTimeStampNanos = ThreadLocal.withInitial(LockUsageInfo::new);

        ResourceManager() {
        }

        void setStartReadHeldTimeNanos(long startReadHeldTimeNanos) {
            this.readLockTimeStampNanos.get().setStartReadHeldTimeNanos(startReadHeldTimeNanos);
        }

        void setStartWriteHeldTimeNanos(long startWriteHeldTimeNanos) {
            this.writeLockTimeStampNanos.get().setStartWriteHeldTimeNanos(startWriteHeldTimeNanos);
        }

        long getStartReadHeldTimeNanos() {
            long startReadHeldTimeNanos = this.readLockTimeStampNanos.get().getStartReadHeldTimeNanos();
            this.readLockTimeStampNanos.remove();
            return startReadHeldTimeNanos;
        }

        long getStartWriteHeldTimeNanos() {
            long startWriteHeldTimeNanos = this.writeLockTimeStampNanos.get().getStartWriteHeldTimeNanos();
            this.writeLockTimeStampNanos.remove();
            return startWriteHeldTimeNanos;
        }
    }

    public static interface Resource {
        public String getName();

        public ResourceManager getResourceManager();
    }
}

