/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.utils;

import java.util.Objects;
import org.apache.hadoop.hdds.cli.GenericCli;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.ratis.util.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import picocli.AutoComplete;
import picocli.CommandLine;

@CommandLine.Command(name="ozone completion", header={"Generate autocompletion script for the specified shell."}, synopsisHeading="%nUsage: ", description={"%nThe generated shell code must be evaluated to provide interactive completion of ozone commands. See each sub-command's help for details on how to use the generated script.%n"}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true)
public final class AutoCompletion
extends GenericCli {
    public static final String DESCRIPTION = "%nThe generated shell code must be evaluated to provide interactive completion of ozone commands. See each sub-command's help for details on how to use the generated script.%n";
    private static final String BASH_DESCRIPTION = "%nTo load completions in your current shell session: %n%n\t source <(ozone completion bash) %n%nTo load completions for every new session automatically, %nadd this to your `~/.bash_profile`: %n%n\t eval \"$(ozone completion bash)\" %n";
    private static final String ZSH_DESCRIPTION = "%nTo load completions in your current shell session: %n%n\t source <(ozone completion zsh)%n%nTo load completions for every new session automatically, %ngenerate a `_ozone` completion script and put it in your `$fpath`: %n%n\t ozone completion zsh > \"$${fpath[1]}/_ozone\" %n";
    private static final String OZONE_COMMAND = "ozone ";
    private static final int PREFIX_LENGTH = "ozone ".length();
    private static final String[] PACKAGES_TO_SCAN = new String[]{"org.apache.hadoop.hdds", "org.apache.hadoop.ozone", "org.apache.ozone"};

    @CommandLine.Command(name="bash", header={"Generate the shell completion code for bash."}, synopsisHeading="%nUsage: ", description={"%nTo load completions in your current shell session: %n%n\t source <(ozone completion bash) %n%nTo load completions for every new session automatically, %nadd this to your `~/.bash_profile`: %n%n\t eval \"$(ozone completion bash)\" %n"}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true)
    public void bashCompletion() {
        this.out().println(this.getBashCompletion());
    }

    @CommandLine.Command(name="zsh", header={"Generate the shell completion code for zsh."}, synopsisHeading="%nUsage: ", description={"%nTo load completions in your current shell session: %n%n\t source <(ozone completion zsh)%n%nTo load completions for every new session automatically, %ngenerate a `_ozone` completion script and put it in your `$fpath`: %n%n\t ozone completion zsh > \"$${fpath[1]}/_ozone\" %n"}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true)
    public void zshCompletion() {
        this.bashCompletion();
    }

    private String getBashCompletion() {
        CommandLine ozone = new CommandLine((Object)new Ozone());
        for (String pkg : PACKAGES_TO_SCAN) {
            new Reflections(pkg, new Scanner[0]).getSubTypesOf(GenericCli.class).stream().map(AutoCompletion::getCommand).filter(Objects::nonNull).filter(AutoCompletion::isPublicCommand).forEach(command -> ozone.addSubcommand(AutoCompletion.getCommandName(command), command));
        }
        return AutoComplete.bash((String)"ozone", (CommandLine)ozone);
    }

    private static CommandLine getCommand(Class<? extends GenericCli> clazz) {
        CommandLine command = null;
        try {
            command = ((GenericCli)ReflectionUtils.newInstance(clazz)).getCmd();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return command;
    }

    private static boolean isPublicCommand(CommandLine command) {
        CommandLine.Model.CommandSpec spec = command.getCommandSpec();
        return !spec.usageMessage().hidden() && !"<main class>".equals(spec.name());
    }

    private static String getCommandName(CommandLine command) {
        CommandLine.Model.CommandSpec spec = command.getCommandSpec();
        String qualifiedName = spec.qualifiedName();
        return qualifiedName.startsWith(OZONE_COMMAND) ? qualifiedName.substring(PREFIX_LENGTH) : qualifiedName;
    }

    public static void main(String[] args) {
        new AutoCompletion().run(args);
    }

    @CommandLine.Command(name="ozone", description={"Ozone top level command"})
    private static final class Ozone {
        @CommandLine.Option(names={"--buildpaths"}, description={"attempt to add class files from build tree"})
        private String buildpaths;
        @CommandLine.Option(names={"--config"}, description={"Ozone config directory"})
        private String config;
        @CommandLine.Option(names={"--debug"}, description={"turn on shell script debug mode"})
        private String debug;
        @CommandLine.Option(names={"--daemon"}, description={"attempt to add class files from build tree"})
        private String daemon;
        @CommandLine.Option(names={"--help"}, description={"usage information"})
        private String help;
        @CommandLine.Option(names={"--hostnames"}, description={"hosts to use in worker mode"})
        private String hostnames;
        @CommandLine.Option(names={"--hosts"}, description={"list of hosts to use in worker mode"})
        private String hosts;
        @CommandLine.Option(names={"--loglevel"}, description={"set the log4j level for this command"})
        private String loglevel;
        @CommandLine.Option(names={"--workers"}, description={"turn on worker mode"})
        private String workers;
        @CommandLine.Option(names={"--jvmargs"}, description={"append JVM options to any existing options defined in the OZONE_OPTS environment variable. Any defined in OZONE_CLIENT_OPTS will be appended after these jvmargs"})
        private String jvmargs;
        @CommandLine.Option(names={"--validate"}, description={"validates if all jars as indicated in the corresponding OZONE_RUN_ARTIFACT_NAME classpath file are present, command execution shall continue post validation failure if 'continue' is passed"})
        private String validate;

        private Ozone() {
        }
    }
}

