/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.SplitLocationInfo;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;

public interface SparkPigSplit
extends Writable,
Configurable,
Serializable {
    public InputSplit getWrappedSplit();

    public InputSplit getWrappedSplit(int var1);

    public SplitLocationInfo[] getLocationInfo() throws IOException;

    public long getLength(int var1) throws IOException, InterruptedException;

    public int getSplitIndex();

    public void setMultiInputs(boolean var1);

    public boolean isMultiInputs();

    public int getNumPaths();

    public void setDisableCounter(boolean var1);

    public boolean disableCounter();

    public void setCurrentIdx(int var1);

    public PigSplit getWrappedPigSplit();

    public static class SparkPigSplitsUtils {
        private static final List<String> PIGSPLIT_CONFIG_KEYS = Lists.newArrayList((Object[])new String[]{"io.serializations", "pig.compress.input.splits"});

        public static void writeConfigForPigSplits(Configuration originalConf, DataOutput os) throws IOException {
            Configuration conf = new Configuration(false);
            for (String key : PIGSPLIT_CONFIG_KEYS) {
                String value = originalConf.get(key);
                if (value == null) continue;
                conf.set(key, value);
            }
            conf.write(os);
        }
    }

    public static class GenericSparkPigSplit
    extends InputSplit
    implements SparkPigSplit {
        private static final long serialVersionUID = 1L;
        private PigSplit pigSplit;

        public GenericSparkPigSplit() {
            this.pigSplit = new PigSplit();
        }

        public GenericSparkPigSplit(PigSplit pigSplit) {
            this.pigSplit = pigSplit;
        }

        @Override
        public SplitLocationInfo[] getLocationInfo() throws IOException {
            return this.pigSplit.getLocationInfo();
        }

        public String toString() {
            return this.pigSplit.toString();
        }

        public long getLength() throws IOException, InterruptedException {
            return this.pigSplit.getLength();
        }

        public String[] getLocations() throws IOException, InterruptedException {
            return this.pigSplit.getLocations();
        }

        @Override
        public InputSplit getWrappedSplit() {
            return this.pigSplit.getWrappedSplit();
        }

        @Override
        public InputSplit getWrappedSplit(int idx) {
            return this.pigSplit.getWrappedSplit(idx);
        }

        @Override
        public long getLength(int idx) throws IOException, InterruptedException {
            return this.pigSplit.getLength(idx);
        }

        public void readFields(DataInput is) throws IOException {
            this.getConf().readFields(is);
            this.pigSplit.readFields(is);
        }

        public void write(DataOutput os) throws IOException {
            SparkPigSplitsUtils.writeConfigForPigSplits(this.getConf(), os);
            this.pigSplit.write(os);
        }

        @Override
        public int getSplitIndex() {
            return this.pigSplit.getSplitIndex();
        }

        @Override
        public void setMultiInputs(boolean b) {
            this.pigSplit.setMultiInputs(b);
        }

        @Override
        public boolean isMultiInputs() {
            return this.pigSplit.isMultiInputs();
        }

        public Configuration getConf() {
            return this.pigSplit.getConf();
        }

        public void setConf(Configuration conf) {
            this.pigSplit.setConf(conf);
        }

        @Override
        public int getNumPaths() {
            return this.pigSplit.getNumPaths();
        }

        @Override
        public void setDisableCounter(boolean disableCounter) {
            this.pigSplit.setDisableCounter(disableCounter);
        }

        @Override
        public boolean disableCounter() {
            return this.pigSplit.disableCounter();
        }

        @Override
        public void setCurrentIdx(int idx) {
            this.pigSplit.setCurrentIdx(idx);
        }

        @Override
        public PigSplit getWrappedPigSplit() {
            return this.pigSplit;
        }
    }

    public static class FileSparkPigSplit
    extends FileSplit
    implements SparkPigSplit {
        private PigSplit pigSplit;

        public FileSparkPigSplit() {
            this.pigSplit = new PigSplit();
        }

        public FileSparkPigSplit(PigSplit pigSplit) {
            this.pigSplit = pigSplit;
        }

        @Override
        public SplitLocationInfo[] getLocationInfo() throws IOException {
            return this.pigSplit.getLocationInfo();
        }

        public String toString() {
            return this.pigSplit.toString();
        }

        public long getLength() {
            try {
                return this.pigSplit.getLength();
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        public String[] getLocations() throws IOException {
            try {
                return this.pigSplit.getLocations();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public InputSplit getWrappedSplit() {
            return this.pigSplit.getWrappedSplit();
        }

        @Override
        public InputSplit getWrappedSplit(int idx) {
            return this.pigSplit.getWrappedSplit(idx);
        }

        @Override
        public long getLength(int idx) throws IOException, InterruptedException {
            return this.pigSplit.getLength(idx);
        }

        public void readFields(DataInput is) throws IOException {
            this.getConf().readFields(is);
            this.pigSplit.readFields(is);
        }

        public void write(DataOutput os) throws IOException {
            SparkPigSplitsUtils.writeConfigForPigSplits(this.getConf(), os);
            this.pigSplit.write(os);
        }

        @Override
        public int getSplitIndex() {
            return this.pigSplit.getSplitIndex();
        }

        @Override
        public void setMultiInputs(boolean b) {
            this.pigSplit.setMultiInputs(b);
        }

        @Override
        public boolean isMultiInputs() {
            return this.pigSplit.isMultiInputs();
        }

        public Configuration getConf() {
            return this.pigSplit.getConf();
        }

        public void setConf(Configuration conf) {
            this.pigSplit.setConf(conf);
        }

        @Override
        public int getNumPaths() {
            return this.pigSplit.getNumPaths();
        }

        @Override
        public void setDisableCounter(boolean disableCounter) {
            this.pigSplit.setDisableCounter(disableCounter);
        }

        @Override
        public boolean disableCounter() {
            return this.pigSplit.disableCounter();
        }

        @Override
        public void setCurrentIdx(int idx) {
            this.pigSplit.setCurrentIdx(idx);
        }

        @Override
        public PigSplit getWrappedPigSplit() {
            return this.pigSplit;
        }

        public Path getPath() {
            return ((FileSplit)this.getWrappedPigSplit().getWrappedSplit()).getPath();
        }
    }
}

