/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseZKTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.replication.ReplicationPeerConfigUtil;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ZKReplicationPeerStorage;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestZKReplicationPeerStorage {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestZKReplicationPeerStorage.class);
    private static final HBaseZKTestingUtility UTIL = new HBaseZKTestingUtility();
    private static final Random RNG = new Random();
    private static ZKReplicationPeerStorage STORAGE;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniZKCluster();
        STORAGE = new ZKReplicationPeerStorage(UTIL.getZooKeeperWatcher(), UTIL.getConfiguration());
    }

    @AfterClass
    public static void tearDown() throws IOException {
        UTIL.shutdownMiniZKCluster();
    }

    @After
    public void cleanCustomConfigurations() {
        UTIL.getConfiguration().unset("hbase.replication.peer.base.config");
    }

    private Set<String> randNamespaces(Random rand) {
        return Stream.generate(() -> Long.toHexString(rand.nextLong())).limit(rand.nextInt(5)).collect(Collectors.toSet());
    }

    private Map<TableName, List<String>> randTableCFs(Random rand) {
        int size = rand.nextInt(5);
        HashMap<TableName, List<String>> map = new HashMap<TableName, List<String>>();
        for (int i = 0; i < size; ++i) {
            TableName tn = TableName.valueOf((String)Long.toHexString(rand.nextLong()));
            List cfs = Stream.generate(() -> Long.toHexString(rand.nextLong())).limit(rand.nextInt(5)).collect(Collectors.toList());
            map.put(tn, cfs);
        }
        return map;
    }

    private ReplicationPeerConfig getConfig(int seed) {
        RNG.setSeed(seed);
        return ReplicationPeerConfig.newBuilder().setClusterKey(Long.toHexString(RNG.nextLong())).setReplicationEndpointImpl(Long.toHexString(RNG.nextLong())).setNamespaces(this.randNamespaces(RNG)).setExcludeNamespaces(this.randNamespaces(RNG)).setTableCFsMap(this.randTableCFs(RNG)).setReplicateAllUserTables(RNG.nextBoolean()).setBandwidth((long)RNG.nextInt(1000)).build();
    }

    private void assertSetEquals(Set<String> expected, Set<String> actual) {
        if (expected == null || expected.size() == 0) {
            Assert.assertTrue((actual == null || actual.size() == 0 ? 1 : 0) != 0);
            return;
        }
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        expected.forEach(s -> Assert.assertTrue((boolean)actual.contains(s)));
    }

    private void assertMapEquals(Map<TableName, List<String>> expected, Map<TableName, List<String>> actual) {
        if (expected == null || expected.size() == 0) {
            Assert.assertTrue((actual == null || actual.size() == 0 ? 1 : 0) != 0);
            return;
        }
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        expected.forEach((expectedTn, expectedCFs) -> {
            List actualCFs = (List)actual.get(expectedTn);
            if (expectedCFs == null || expectedCFs.size() == 0) {
                Assert.assertTrue((boolean)actual.containsKey(expectedTn));
                Assert.assertTrue((actualCFs == null || actualCFs.size() == 0 ? 1 : 0) != 0);
            } else {
                Assert.assertNotNull((Object)actualCFs);
                Assert.assertEquals((long)expectedCFs.size(), (long)actualCFs.size());
                Iterator expectedIt = expectedCFs.iterator();
                Iterator actualIt = actualCFs.iterator();
                while (expectedIt.hasNext()) {
                    Assert.assertEquals(expectedIt.next(), actualIt.next());
                }
            }
        });
    }

    private void assertConfigEquals(ReplicationPeerConfig expected, ReplicationPeerConfig actual) {
        Assert.assertEquals((Object)expected.getClusterKey(), (Object)actual.getClusterKey());
        Assert.assertEquals((Object)expected.getReplicationEndpointImpl(), (Object)actual.getReplicationEndpointImpl());
        this.assertSetEquals(expected.getNamespaces(), actual.getNamespaces());
        this.assertSetEquals(expected.getExcludeNamespaces(), actual.getExcludeNamespaces());
        this.assertMapEquals(expected.getTableCFsMap(), actual.getTableCFsMap());
        this.assertMapEquals(expected.getExcludeTableCFsMap(), actual.getExcludeTableCFsMap());
        Assert.assertEquals((Object)expected.replicateAllUserTables(), (Object)actual.replicateAllUserTables());
        Assert.assertEquals((long)expected.getBandwidth(), (long)actual.getBandwidth());
    }

    @Test
    public void test() throws ReplicationException {
        int i;
        int seed;
        int peerCount = 10;
        for (int i2 = 0; i2 < peerCount; ++i2) {
            STORAGE.addPeer(Integer.toString(i2), this.getConfig(i2), i2 % 2 == 0);
        }
        List peerIds = STORAGE.listPeerIds();
        Assert.assertEquals((long)peerCount, (long)peerIds.size());
        for (String peerId : peerIds) {
            seed = Integer.parseInt(peerId);
            this.assertConfigEquals(this.getConfig(seed), STORAGE.getPeerConfig(peerId));
        }
        for (int i3 = 0; i3 < peerCount; ++i3) {
            STORAGE.updatePeerConfig(Integer.toString(i3), this.getConfig(i3 + 1));
        }
        for (String peerId : peerIds) {
            seed = Integer.parseInt(peerId);
            this.assertConfigEquals(this.getConfig(seed + 1), STORAGE.getPeerConfig(peerId));
        }
        for (i = 0; i < peerCount; ++i) {
            Assert.assertEquals((Object)(i % 2 == 0 ? 1 : 0), (Object)STORAGE.isPeerEnabled(Integer.toString(i)));
        }
        for (i = 0; i < peerCount; ++i) {
            STORAGE.setPeerState(Integer.toString(i), i % 2 != 0);
        }
        for (i = 0; i < peerCount; ++i) {
            Assert.assertEquals((Object)(i % 2 != 0 ? 1 : 0), (Object)STORAGE.isPeerEnabled(Integer.toString(i)));
        }
        String toRemove = Integer.toString(peerCount / 2);
        STORAGE.removePeer(toRemove);
        peerIds = STORAGE.listPeerIds();
        Assert.assertEquals((long)(peerCount - 1), (long)peerIds.size());
        Assert.assertFalse((boolean)peerIds.contains(toRemove));
        try {
            STORAGE.getPeerConfig(toRemove);
            Assert.fail((String)"Should throw a ReplicationException when get peer config of a peerId");
        }
        catch (ReplicationException replicationException) {
            // empty catch block
        }
    }

    @Test
    public void testBaseReplicationPeerConfig() throws ReplicationException {
        String customPeerConfigKey = "hbase.xxx.custom_config";
        String customPeerConfigValue = "test";
        String customPeerConfigUpdatedValue = "testUpdated";
        String customPeerConfigSecondKey = "hbase.xxx.custom_second_config";
        String customPeerConfigSecondValue = "testSecond";
        String customPeerConfigSecondUpdatedValue = "testSecondUpdated";
        ReplicationPeerConfig existingReplicationPeerConfig = this.getConfig(1);
        Assert.assertEquals(existingReplicationPeerConfig.getConfiguration().get(customPeerConfigKey), null);
        Configuration conf = UTIL.getConfiguration();
        conf.set("hbase.replication.peer.base.config", customPeerConfigKey.concat("=").concat(customPeerConfigValue).concat(";").concat(customPeerConfigSecondKey).concat("=").concat(customPeerConfigSecondValue));
        ReplicationPeerConfig updatedReplicationPeerConfig = ReplicationPeerConfigUtil.updateReplicationBasePeerConfigs((Configuration)conf, (ReplicationPeerConfig)existingReplicationPeerConfig);
        Assert.assertEquals((Object)customPeerConfigValue, updatedReplicationPeerConfig.getConfiguration().get(customPeerConfigKey));
        Assert.assertEquals((Object)customPeerConfigSecondValue, updatedReplicationPeerConfig.getConfiguration().get(customPeerConfigSecondKey));
        conf.unset("hbase.replication.peer.base.config");
        conf.set("hbase.replication.peer.base.config", customPeerConfigKey.concat("=").concat(customPeerConfigUpdatedValue).concat(";").concat(customPeerConfigSecondKey).concat("=").concat(customPeerConfigSecondUpdatedValue));
        ReplicationPeerConfig replicationPeerConfigAfterValueUpdate = ReplicationPeerConfigUtil.updateReplicationBasePeerConfigs((Configuration)conf, (ReplicationPeerConfig)updatedReplicationPeerConfig);
        Assert.assertEquals((Object)customPeerConfigUpdatedValue, replicationPeerConfigAfterValueUpdate.getConfiguration().get(customPeerConfigKey));
        Assert.assertEquals((Object)customPeerConfigSecondUpdatedValue, replicationPeerConfigAfterValueUpdate.getConfiguration().get(customPeerConfigSecondKey));
    }

    @Test
    public void testBaseReplicationRemovePeerConfig() throws ReplicationException {
        String customPeerConfigKey = "hbase.xxx.custom_config";
        String customPeerConfigValue = "test";
        ReplicationPeerConfig existingReplicationPeerConfig = this.getConfig(1);
        Assert.assertEquals(existingReplicationPeerConfig.getConfiguration().get(customPeerConfigKey), null);
        Configuration conf = UTIL.getConfiguration();
        conf.set("hbase.replication.peer.base.config", customPeerConfigKey.concat("=").concat(customPeerConfigValue));
        ReplicationPeerConfig updatedReplicationPeerConfig = ReplicationPeerConfigUtil.updateReplicationBasePeerConfigs((Configuration)conf, (ReplicationPeerConfig)existingReplicationPeerConfig);
        Assert.assertEquals((Object)customPeerConfigValue, updatedReplicationPeerConfig.getConfiguration().get(customPeerConfigKey));
        conf.unset("hbase.replication.peer.base.config");
        conf.set("hbase.replication.peer.base.config", customPeerConfigKey.concat("=").concat(""));
        ReplicationPeerConfig replicationPeerConfigRemoved = ReplicationPeerConfigUtil.updateReplicationBasePeerConfigs((Configuration)conf, (ReplicationPeerConfig)updatedReplicationPeerConfig);
        Assert.assertNull(replicationPeerConfigRemoved.getConfiguration().get(customPeerConfigKey));
    }

    @Test
    public void testBaseReplicationRemovePeerConfigWithNoExistingConfig() throws ReplicationException {
        String customPeerConfigKey = "hbase.xxx.custom_config";
        ReplicationPeerConfig existingReplicationPeerConfig = this.getConfig(1);
        Assert.assertEquals(existingReplicationPeerConfig.getConfiguration().get(customPeerConfigKey), null);
        Configuration conf = UTIL.getConfiguration();
        conf.set("hbase.replication.peer.base.config", customPeerConfigKey.concat("=").concat(""));
        ReplicationPeerConfig updatedReplicationPeerConfig = ReplicationPeerConfigUtil.updateReplicationBasePeerConfigs((Configuration)conf, (ReplicationPeerConfig)existingReplicationPeerConfig);
        Assert.assertNull(updatedReplicationPeerConfig.getConfiguration().get(customPeerConfigKey));
    }
}

