/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelBuilder;
import org.apache.hadoop.hive.ql.optimizer.calcite.TraitsUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveExcept;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveIntersect;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSemiJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveUnion;

public class HiveRelFactories {
    public static final RelFactories.ProjectFactory HIVE_PROJECT_FACTORY = new HiveProjectFactoryImpl();
    public static final RelFactories.FilterFactory HIVE_FILTER_FACTORY = new HiveFilterFactoryImpl();
    public static final RelFactories.JoinFactory HIVE_JOIN_FACTORY = new HiveJoinFactoryImpl();
    public static final RelFactories.SemiJoinFactory HIVE_SEMI_JOIN_FACTORY = new HiveSemiJoinFactoryImpl();
    public static final RelFactories.SortFactory HIVE_SORT_FACTORY = new HiveSortFactoryImpl();
    public static final RelFactories.AggregateFactory HIVE_AGGREGATE_FACTORY = new HiveAggregateFactoryImpl();
    public static final RelFactories.SetOpFactory HIVE_SET_OP_FACTORY = new HiveSetOpFactoryImpl();
    public static final RelBuilderFactory HIVE_BUILDER = HiveRelBuilder.proto(Contexts.of((Object[])new Object[]{HIVE_PROJECT_FACTORY, HIVE_FILTER_FACTORY, HIVE_JOIN_FACTORY, HIVE_SEMI_JOIN_FACTORY, HIVE_SORT_FACTORY, HIVE_AGGREGATE_FACTORY, HIVE_SET_OP_FACTORY}));

    private HiveRelFactories() {
    }

    private static class HiveSetOpFactoryImpl
    implements RelFactories.SetOpFactory {
        private HiveSetOpFactoryImpl() {
        }

        public RelNode createSetOp(SqlKind kind, List<RelNode> inputs, boolean all) {
            if (kind == SqlKind.UNION) {
                return new HiveUnion(inputs.get(0).getCluster(), inputs.get(0).getTraitSet(), inputs);
            }
            if (kind == SqlKind.INTERSECT) {
                return new HiveIntersect(inputs.get(0).getCluster(), inputs.get(0).getTraitSet(), inputs, all);
            }
            if (kind == SqlKind.EXCEPT) {
                return new HiveExcept(inputs.get(0).getCluster(), inputs.get(0).getTraitSet(), inputs, all);
            }
            throw new IllegalStateException("Expected to get set operator of type Union, Intersect or Except(Minus). Found : " + kind);
        }
    }

    private static class HiveAggregateFactoryImpl
    implements RelFactories.AggregateFactory {
        private HiveAggregateFactoryImpl() {
        }

        public RelNode createAggregate(RelNode child, boolean indicator, ImmutableBitSet groupSet, ImmutableList<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
            if (indicator) {
                throw new IllegalStateException("Hive does not support indicator columns but Calcite created an Aggregate operator containing them");
            }
            return new HiveAggregate(child.getCluster(), child.getTraitSet(), child, groupSet, (List<ImmutableBitSet>)groupSets, aggCalls);
        }
    }

    private static class HiveSortFactoryImpl
    implements RelFactories.SortFactory {
        private HiveSortFactoryImpl() {
        }

        public RelNode createSort(RelTraitSet traits, RelNode input, RelCollation collation, RexNode offset, RexNode fetch) {
            return this.createSort(input, collation, offset, fetch);
        }

        public RelNode createSort(RelNode input, RelCollation collation, RexNode offset, RexNode fetch) {
            return HiveSortLimit.create(input, collation, offset, fetch);
        }
    }

    private static class HiveSemiJoinFactoryImpl
    implements RelFactories.SemiJoinFactory {
        private HiveSemiJoinFactoryImpl() {
        }

        public RelNode createSemiJoin(RelNode left, RelNode right, RexNode condition) {
            JoinInfo joinInfo = JoinInfo.of((RelNode)left, (RelNode)right, (RexNode)condition);
            RelOptCluster cluster = left.getCluster();
            return HiveSemiJoin.getSemiJoin(cluster, left.getTraitSet(), left, right, condition, joinInfo.leftKeys, joinInfo.rightKeys);
        }
    }

    private static class HiveJoinFactoryImpl
    implements RelFactories.JoinFactory {
        private HiveJoinFactoryImpl() {
        }

        public RelNode createJoin(RelNode left, RelNode right, RexNode condition, JoinRelType joinType, Set<String> variablesStopped, boolean semiJoinDone) {
            return HiveJoin.getJoin(left.getCluster(), left, right, condition, joinType);
        }

        public RelNode createJoin(RelNode left, RelNode right, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType, boolean semiJoinDone) {
            return HiveJoin.getJoin(left.getCluster(), left, right, condition, joinType);
        }
    }

    private static class HiveFilterFactoryImpl
    implements RelFactories.FilterFactory {
        private HiveFilterFactoryImpl() {
        }

        public RelNode createFilter(RelNode child, RexNode condition) {
            RelOptCluster cluster = child.getCluster();
            HiveFilter filter = new HiveFilter(cluster, TraitsUtil.getDefaultTraitSet(cluster), child, condition);
            return filter;
        }
    }

    private static class HiveProjectFactoryImpl
    implements RelFactories.ProjectFactory {
        private HiveProjectFactoryImpl() {
        }

        public RelNode createProject(RelNode child, List<? extends RexNode> childExprs, List<String> fieldNames) {
            RelOptCluster cluster = child.getCluster();
            RelDataType rowType = RexUtil.createStructType((RelDataTypeFactory)cluster.getTypeFactory(), childExprs, fieldNames);
            RelTraitSet trait = TraitsUtil.getDefaultTraitSet(cluster, child.getTraitSet());
            HiveProject project = HiveProject.create(cluster, child, childExprs, rowType, trait, Collections.emptyList());
            return project;
        }
    }
}

