/*
 * Decompiled with CFR 0.152.
 */
package sdsu.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sdsu.io.FilePrefixFilter;
import sdsu.io.LabeledObject;
import sdsu.io.Repository;

public class ASCIIFileRepository
implements Repository {
    static final int EOFIndicator = -1;
    File repositoryDirectory;
    Hashtable cachedObjects = new Hashtable();

    public ASCIIFileRepository(File file) {
        this.repositoryDirectory = file;
    }

    public ASCIIFileRepository(String string) {
        this(new File(string));
    }

    public boolean containsKey(String string) {
        String[] stringArray = this.repositoryDirectory.list(new FilePrefixFilter(string));
        return stringArray.length != 0;
    }

    public boolean containsSubrepository(String string) {
        return false;
    }

    public boolean create() {
        if (this.repositoryDirectory.exists()) {
            return true;
        }
        return this.repositoryDirectory.mkdirs();
    }

    public boolean createSubrepository(String string) {
        return false;
    }

    public boolean exists() {
        return this.repositoryDirectory.exists();
    }

    public Object get(String string) throws IOException {
        if (this.cachedObjects.containsKey(string)) {
            LabeledObject labeledObject = (LabeledObject)this.cachedObjects.get(string);
            return labeledObject.getObject();
        }
        LabeledObject labeledObject = this.getFromFile(string);
        if (labeledObject == null) {
            return null;
        }
        this.cachedObjects.put(string, labeledObject);
        return labeledObject.getObject();
    }

    private LabeledObject getFromFile(String string) throws IOException {
        String[] stringArray = this.repositoryDirectory.list(new FilePrefixFilter(string));
        if (stringArray.length == 0) {
            return null;
        }
        File file = new File(this.repositoryDirectory, stringArray[0]);
        String string2 = this.readFile(file);
        int n = stringArray[0].indexOf(".");
        String string3 = stringArray[0].substring(n + 1);
        return LabeledObject.fromString(string2, string3);
    }

    public Enumeration getSubrepositories() {
        return null;
    }

    public Repository getSubrepository(String string) {
        return null;
    }

    public boolean isEmpty() {
        Enumeration enumeration = this.keys();
        return enumeration.hasMoreElements();
    }

    public Enumeration keys() {
        String[] stringArray = this.repositoryDirectory.list();
        Vector<String> vector = new Vector<String>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            int n2 = stringArray[n].indexOf(".");
            if (n2 > 0) {
                vector.addElement(stringArray[n].substring(0, n2));
            }
            ++n;
        }
        return vector.elements();
    }

    public int length() {
        return this.size();
    }

    public void put(String string, Object object) throws IOException {
        this.put(string, object, null);
    }

    public void put(String string, Object object, String string2) throws IOException {
        LabeledObject labeledObject = new LabeledObject(object, string, string2);
        this.cachedObjects.put(string, labeledObject);
        this.saveToFile(labeledObject.asString(), string, labeledObject.shortClassName());
    }

    public void putSerializable(String string, Serializable serializable) throws IOException {
        this.put(string, serializable, null);
    }

    public void putSerializable(String string, Serializable serializable, String string2) throws IOException {
        LabeledObject labeledObject = new LabeledObject(serializable, string, string2);
        this.cachedObjects.put(string, labeledObject);
        this.saveToFile(labeledObject.serializableToString(), string, labeledObject.serializableShortName());
    }

    private String readFile(File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        StringBuffer stringBuffer = new StringBuffer(1024);
        int n = 1024;
        char[] cArray = new char[n];
        int n2 = bufferedReader.read(cArray, 0, n);
        while (n2 != -1) {
            stringBuffer.append(cArray, 0, n2);
            n2 = bufferedReader.read(cArray, 0, n);
        }
        return stringBuffer.toString();
    }

    public boolean remove(String string) {
        String[] stringArray = this.repositoryDirectory.list(new FilePrefixFilter(string));
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            File file = new File(this.repositoryDirectory, stringArray[n]);
            bl = bl || file.delete();
            ++n;
        }
        return bl;
    }

    private void saveToFile(String string, String string2, String string3) throws IOException {
        String string4 = String.valueOf(string2) + "." + string3;
        File file = new File(this.repositoryDirectory, string4);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.write(string, 0, string.length());
        bufferedWriter.close();
    }

    public void setNameSeparator(char c) {
    }

    public int size() {
        Enumeration enumeration = this.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            ++n;
            enumeration.nextElement();
        }
        return n;
    }
}

