/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.protobuf.Service;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.locking.EntityLock;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.mob.MobFileCache;
import org.apache.hadoop.hbase.quotas.RegionServerRpcQuotaManager;
import org.apache.hadoop.hbase.quotas.RegionServerSpaceQuotaManager;
import org.apache.hadoop.hbase.quotas.RegionSizeStore;
import org.apache.hadoop.hbase.regionserver.FlushRequester;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HeapMemoryManager;
import org.apache.hadoop.hbase.regionserver.LeaseManager;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionServerAccounting;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.SecureBulkLoadManager;
import org.apache.hadoop.hbase.regionserver.ServerNonceManager;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequester;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.security.access.AccessChecker;
import org.apache.hadoop.hbase.security.access.ZKPermissionWatcher;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;

class MockRegionServer
implements AdminProtos.AdminService.BlockingInterface,
ClientProtos.ClientService.BlockingInterface,
RegionServerServices {
    private final ServerName sn;
    private final ZKWatcher zkw;
    private final Configuration conf;
    private final Map<byte[], Map<byte[], Result>> gets = new TreeMap<byte[], Map<byte[], Result>>(Bytes.BYTES_COMPARATOR);
    private final Map<byte[], Result[]> nexts = new TreeMap<byte[], Result[]>(Bytes.BYTES_COMPARATOR);
    private final Map<Long, RegionNameAndIndex> scannersAndOffsets = new HashMap<Long, RegionNameAndIndex>();

    MockRegionServer(Configuration conf, ServerName sn) throws ZooKeeperConnectionException, IOException {
        this.sn = sn;
        this.conf = conf;
        this.zkw = new ZKWatcher(conf, sn.toString(), (Abortable)this, true);
    }

    void setGetResult(byte[] regionName, byte[] row, Result r) {
        Map<byte[], Result> value = this.gets.get(regionName);
        if (value == null) {
            value = new TreeMap<byte[], Result>(Bytes.BYTES_COMPARATOR);
            this.gets.put(regionName, value);
        }
        value.put(row, r);
    }

    void setNextResults(byte[] regionName, Result[] rs) {
        this.nexts.put(regionName, rs);
    }

    public boolean isStopped() {
        return false;
    }

    public void abort(String why, Throwable e) {
        throw new RuntimeException(this.sn + ": " + why, e);
    }

    public boolean isAborted() {
        return false;
    }

    public long openScanner(byte[] regionName, Scan scan) throws IOException {
        long scannerId = ThreadLocalRandom.current().nextLong();
        this.scannersAndOffsets.put(scannerId, new RegionNameAndIndex(regionName));
        return scannerId;
    }

    public Result next(long scannerId) throws IOException {
        RegionNameAndIndex rnai = this.scannersAndOffsets.get(scannerId);
        int index = rnai.getThenIncrement();
        Result[] results = this.nexts.get(rnai.getRegionName());
        if (results == null) {
            return null;
        }
        return index < results.length ? results[index] : null;
    }

    public Result[] next(long scannerId, int numberOfRows) throws IOException {
        Result[] resultArray;
        Result r = this.next(scannerId);
        if (r == null) {
            resultArray = null;
        } else {
            Result[] resultArray2 = new Result[1];
            resultArray = resultArray2;
            resultArray2[0] = r;
        }
        return resultArray;
    }

    public void close(long scannerId) throws IOException {
        this.scannersAndOffsets.remove(scannerId);
    }

    public void stop(String why) {
        this.zkw.close();
    }

    public void addRegion(HRegion r) {
    }

    public boolean removeRegion(HRegion r, ServerName destination) {
        return false;
    }

    public HRegion getRegion(String encodedRegionName) {
        return null;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public ZKWatcher getZooKeeper() {
        return this.zkw;
    }

    public CoordinatedStateManager getCoordinatedStateManager() {
        return null;
    }

    public ClusterConnection getConnection() {
        return null;
    }

    public ServerName getServerName() {
        return this.sn;
    }

    public boolean isStopping() {
        return false;
    }

    public FlushRequester getFlushRequester() {
        return null;
    }

    public CompactionRequester getCompactionRequestor() {
        return null;
    }

    public RegionServerAccounting getRegionServerAccounting() {
        return null;
    }

    public RegionServerRpcQuotaManager getRegionServerRpcQuotaManager() {
        return null;
    }

    public void postOpenDeployTasks(RegionServerServices.PostOpenDeployContext context) throws IOException {
    }

    public RpcServerInterface getRpcServer() {
        return null;
    }

    public ConcurrentSkipListMap<byte[], Boolean> getRegionsInTransitionInRS() {
        return null;
    }

    public FileSystem getFileSystem() {
        return null;
    }

    public ClientProtos.GetResponse get(RpcController controller, ClientProtos.GetRequest request) throws ServiceException {
        byte[] regionName = request.getRegion().getValue().toByteArray();
        Map<byte[], Result> m = this.gets.get(regionName);
        ClientProtos.GetResponse.Builder builder = ClientProtos.GetResponse.newBuilder();
        if (m != null) {
            byte[] row = request.getGet().getRow().toByteArray();
            builder.setResult(ProtobufUtil.toResult((Result)m.get(row)));
        }
        return builder.build();
    }

    public ClientProtos.MutateResponse mutate(RpcController controller, ClientProtos.MutateRequest request) throws ServiceException {
        return null;
    }

    public ClientProtos.ScanResponse scan(RpcController controller, ClientProtos.ScanRequest request) throws ServiceException {
        ClientProtos.ScanResponse.Builder builder = ClientProtos.ScanResponse.newBuilder();
        try {
            if (request.hasScan()) {
                byte[] regionName = request.getRegion().getValue().toByteArray();
                builder.setScannerId(this.openScanner(regionName, null));
                builder.setMoreResults(true);
            } else {
                long scannerId = request.getScannerId();
                Result result = this.next(scannerId);
                if (result != null) {
                    builder.addCellsPerResult(result.size());
                    ArrayList<Result> results = new ArrayList<Result>(1);
                    results.add(result);
                    ((HBaseRpcController)controller).setCellScanner(CellUtil.createCellScanner(results));
                    builder.setMoreResults(true);
                } else {
                    builder.setMoreResults(false);
                    this.close(scannerId);
                }
            }
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
        return builder.build();
    }

    public ClientProtos.BulkLoadHFileResponse bulkLoadHFile(RpcController controller, ClientProtos.BulkLoadHFileRequest request) throws ServiceException {
        return null;
    }

    public ClientProtos.CoprocessorServiceResponse execService(RpcController controller, ClientProtos.CoprocessorServiceRequest request) throws ServiceException {
        return null;
    }

    public ClientProtos.MultiResponse multi(RpcController controller, ClientProtos.MultiRequest request) throws ServiceException {
        return null;
    }

    public AdminProtos.GetRegionInfoResponse getRegionInfo(RpcController controller, AdminProtos.GetRegionInfoRequest request) throws ServiceException {
        AdminProtos.GetRegionInfoResponse.Builder builder = AdminProtos.GetRegionInfoResponse.newBuilder();
        builder.setRegionInfo(ProtobufUtil.toRegionInfo((RegionInfo)RegionInfoBuilder.FIRST_META_REGIONINFO));
        return builder.build();
    }

    public AdminProtos.GetRegionLoadResponse getRegionLoad(RpcController controller, AdminProtos.GetRegionLoadRequest request) throws ServiceException {
        AdminProtos.GetRegionLoadResponse.Builder builder = AdminProtos.GetRegionLoadResponse.newBuilder();
        return builder.build();
    }

    public AdminProtos.ClearCompactionQueuesResponse clearCompactionQueues(RpcController controller, AdminProtos.ClearCompactionQueuesRequest request) throws ServiceException {
        return null;
    }

    public AdminProtos.GetStoreFileResponse getStoreFile(RpcController controller, AdminProtos.GetStoreFileRequest request) throws ServiceException {
        return null;
    }

    public AdminProtos.GetOnlineRegionResponse getOnlineRegion(RpcController controller, AdminProtos.GetOnlineRegionRequest request) throws ServiceException {
        return null;
    }

    public List<Region> getRegions() {
        return null;
    }

    public AdminProtos.OpenRegionResponse openRegion(RpcController controller, AdminProtos.OpenRegionRequest request) throws ServiceException {
        return null;
    }

    public AdminProtos.WarmupRegionResponse warmupRegion(RpcController controller, AdminProtos.WarmupRegionRequest request) throws ServiceException {
        return null;
    }

    public AdminProtos.CloseRegionResponse closeRegion(RpcController controller, AdminProtos.CloseRegionRequest request) throws ServiceException {
        return null;
    }

    public AdminProtos.FlushRegionResponse flushRegion(RpcController controller, AdminProtos.FlushRegionRequest request) throws ServiceException {
        return null;
    }

    public AdminProtos.CompactionSwitchResponse compactionSwitch(RpcController controller, AdminProtos.CompactionSwitchRequest request) throws ServiceException {
        return null;
    }

    public AdminProtos.CompactRegionResponse compactRegion(RpcController controller, AdminProtos.CompactRegionRequest request) throws ServiceException {
        return null;
    }

    public AdminProtos.ReplicateWALEntryResponse replicateWALEntry(RpcController controller, AdminProtos.ReplicateWALEntryRequest request) throws ServiceException {
        return null;
    }

    public AdminProtos.RollWALWriterResponse rollWALWriter(RpcController controller, AdminProtos.RollWALWriterRequest request) throws ServiceException {
        return null;
    }

    public AdminProtos.GetServerInfoResponse getServerInfo(RpcController controller, AdminProtos.GetServerInfoRequest request) throws ServiceException {
        return null;
    }

    public AdminProtos.StopServerResponse stopServer(RpcController controller, AdminProtos.StopServerRequest request) throws ServiceException {
        return null;
    }

    public List<Region> getRegions(TableName tableName) throws IOException {
        return null;
    }

    public LeaseManager getLeaseManager() {
        return null;
    }

    public List<WAL> getWALs() throws IOException {
        return Collections.emptyList();
    }

    public WAL getWAL(RegionInfo regionInfo) throws IOException {
        return null;
    }

    public ExecutorService getExecutorService() {
        return null;
    }

    public ChoreService getChoreService() {
        return null;
    }

    public void updateRegionFavoredNodesMapping(String encodedRegionName, List<HBaseProtos.ServerName> favoredNodes) {
    }

    public InetSocketAddress[] getFavoredNodesForRegion(String encodedRegionName) {
        return null;
    }

    public AdminProtos.ReplicateWALEntryResponse replay(RpcController controller, AdminProtos.ReplicateWALEntryRequest request) throws ServiceException {
        return null;
    }

    public AdminProtos.UpdateFavoredNodesResponse updateFavoredNodes(RpcController controller, AdminProtos.UpdateFavoredNodesRequest request) throws ServiceException {
        return null;
    }

    public ServerNonceManager getNonceManager() {
        return null;
    }

    public boolean reportRegionStateTransition(RegionServerServices.RegionStateTransitionContext context) {
        return false;
    }

    public boolean registerService(Service service) {
        return false;
    }

    public ClientProtos.CoprocessorServiceResponse execRegionServerService(RpcController controller, ClientProtos.CoprocessorServiceRequest request) throws ServiceException {
        return null;
    }

    public AdminProtos.UpdateConfigurationResponse updateConfiguration(RpcController controller, AdminProtos.UpdateConfigurationRequest request) throws ServiceException {
        return null;
    }

    public AdminProtos.ClearRegionBlockCacheResponse clearRegionBlockCache(RpcController controller, AdminProtos.ClearRegionBlockCacheRequest request) throws ServiceException {
        return null;
    }

    public HeapMemoryManager getHeapMemoryManager() {
        return null;
    }

    public double getCompactionPressure() {
        return 0.0;
    }

    public ClusterConnection getClusterConnection() {
        return null;
    }

    public ThroughputController getFlushThroughputController() {
        return null;
    }

    public double getFlushPressure() {
        return 0.0;
    }

    public MetricsRegionServer getMetrics() {
        return null;
    }

    public EntityLock regionLock(List<RegionInfo> regionInfos, String description, Abortable abort) throws IOException {
        return null;
    }

    public ClientProtos.PrepareBulkLoadResponse prepareBulkLoad(RpcController controller, ClientProtos.PrepareBulkLoadRequest request) throws ServiceException {
        return null;
    }

    public ClientProtos.CleanupBulkLoadResponse cleanupBulkLoad(RpcController controller, ClientProtos.CleanupBulkLoadRequest request) throws ServiceException {
        return null;
    }

    public SecureBulkLoadManager getSecureBulkLoadManager() {
        return null;
    }

    public void unassign(byte[] regionName) throws IOException {
    }

    public RegionServerSpaceQuotaManager getRegionServerSpaceQuotaManager() {
        return null;
    }

    public AdminProtos.ExecuteProceduresResponse executeProcedures(RpcController controller, AdminProtos.ExecuteProceduresRequest request) throws ServiceException {
        return null;
    }

    public AdminProtos.SlowLogResponses getSlowLogResponses(RpcController controller, AdminProtos.SlowLogResponseRequest request) throws ServiceException {
        return null;
    }

    public AdminProtos.SlowLogResponses getLargeLogResponses(RpcController controller, AdminProtos.SlowLogResponseRequest request) throws ServiceException {
        return null;
    }

    public AdminProtos.ClearSlowLogResponses clearSlowLogsResponses(RpcController controller, AdminProtos.ClearSlowLogResponseRequest request) throws ServiceException {
        return null;
    }

    public HBaseProtos.LogEntry getLogEntries(RpcController controller, HBaseProtos.LogRequest request) throws ServiceException {
        return null;
    }

    public QuotaProtos.GetSpaceQuotaSnapshotsResponse getSpaceQuotaSnapshots(RpcController controller, QuotaProtos.GetSpaceQuotaSnapshotsRequest request) throws ServiceException {
        return null;
    }

    public Connection createConnection(Configuration conf) throws IOException {
        return null;
    }

    public boolean isClusterUp() {
        return true;
    }

    public TableDescriptors getTableDescriptors() {
        return null;
    }

    public Optional<BlockCache> getBlockCache() {
        return Optional.empty();
    }

    public Optional<MobFileCache> getMobFileCache() {
        return Optional.empty();
    }

    public AccessChecker getAccessChecker() {
        return null;
    }

    public ZKPermissionWatcher getZKPermissionWatcher() {
        return null;
    }

    public boolean reportRegionSizesForQuotas(RegionSizeStore sizeStore) {
        return true;
    }

    public boolean reportFileArchivalForQuotas(TableName tableName, Collection<Map.Entry<String, Long>> archivedFiles) {
        return false;
    }

    class RegionNameAndIndex {
        private final byte[] regionName;
        private int index = 0;

        RegionNameAndIndex(byte[] regionName) {
            this.regionName = regionName;
        }

        byte[] getRegionName() {
            return this.regionName;
        }

        int getThenIncrement() {
            int currentIndex = this.index++;
            return currentIndex;
        }
    }
}

