/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class CastStringToDecimal
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final int inputColumn;

    public CastStringToDecimal(int inputColumn, int outputColumnNum) {
        super(outputColumnNum);
        this.inputColumn = inputColumn;
    }

    public CastStringToDecimal() {
        this.inputColumn = -1;
    }

    protected void func(DecimalColumnVector outputColVector, BytesColumnVector inputColVector, int i) {
        try {
            String s = new String(inputColVector.vector[i], inputColVector.start[i], inputColVector.length[i], "UTF-8");
            outputColVector.set(i, HiveDecimal.create((String)s));
        }
        catch (Exception e) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        BytesColumnVector inputColVector = (BytesColumnVector)batch.cols[this.inputColumn];
        int[] sel = batch.selected;
        int n = batch.size;
        DecimalColumnVector outputColVector = (DecimalColumnVector)batch.cols[this.outputColumnNum];
        boolean[] inputIsNull = inputColVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        if (inputColVector.isRepeating) {
            if (inputColVector.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                this.func(outputColVector, inputColVector, 0);
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            return;
        }
        if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        this.func(outputColVector, inputColVector, i);
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        this.func(outputColVector, inputColVector, i);
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    this.func(outputColVector, inputColVector, i);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!inputColVector.isNull[i]) {
                    outputColVector.isNull[i] = false;
                    this.func(outputColVector, inputColVector, i);
                    continue;
                }
                outputColVector.isNull[i] = true;
                outputColVector.noNulls = false;
            }
        } else {
            System.arraycopy(inputColVector.isNull, 0, outputColVector.isNull, 0, n);
            for (int i = 0; i != n; ++i) {
                if (!inputColVector.isNull[i]) {
                    outputColVector.isNull[i] = false;
                    this.func(outputColVector, inputColVector, i);
                    continue;
                }
                outputColVector.isNull[i] = true;
                outputColVector.noNulls = false;
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumn);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.STRING_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN);
        return b.build();
    }
}

