/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.spark;

import java.util.Stack;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.BucketJoinProcCtx;
import org.apache.hadoop.hive.ql.optimizer.BucketMapjoinProc;
import org.apache.hadoop.hive.ql.optimizer.SortBucketJoinProcCtx;
import org.apache.hadoop.hive.ql.optimizer.spark.SparkSMBJoinHintOptimizer;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.spark.OptimizeSparkProcContext;

public class SparkJoinHintOptimizer
implements NodeProcessor {
    private BucketMapjoinProc bucketMapJoinOptimizer;
    private SparkSMBJoinHintOptimizer smbMapJoinOptimizer;

    public SparkJoinHintOptimizer(ParseContext parseCtx) {
        this.bucketMapJoinOptimizer = new BucketMapjoinProc(parseCtx);
        this.smbMapJoinOptimizer = new SparkSMBJoinHintOptimizer(parseCtx);
    }

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
        OptimizeSparkProcContext context = (OptimizeSparkProcContext)procCtx;
        HiveConf hiveConf = context.getParseContext().getConf();
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVEOPTBUCKETMAPJOIN) || hiveConf.getBoolVar(HiveConf.ConfVars.HIVEOPTSORTMERGEBUCKETMAPJOIN)) {
            BucketJoinProcCtx bjProcCtx = new BucketJoinProcCtx(hiveConf);
            this.bucketMapJoinOptimizer.process(nd, stack, bjProcCtx, nodeOutputs);
        }
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVEOPTSORTMERGEBUCKETMAPJOIN)) {
            SortBucketJoinProcCtx smbJoinCtx = new SortBucketJoinProcCtx(hiveConf);
            this.smbMapJoinOptimizer.process(nd, stack, smbJoinCtx, nodeOutputs);
        }
        return null;
    }
}

