/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.evaluator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.query.engine.evaluator.EvaluationContext;
import org.apache.qpid.server.query.engine.evaluator.EvaluationContextHolder;
import org.apache.qpid.server.query.engine.evaluator.EvaluationResult;
import org.apache.qpid.server.query.engine.evaluator.settings.DefaultQuerySettings;
import org.apache.qpid.server.query.engine.evaluator.settings.QuerySettings;
import org.apache.qpid.server.query.engine.exception.QueryParsingException;
import org.apache.qpid.server.query.engine.exception.QueryValidationException;
import org.apache.qpid.server.query.engine.parsing.ExpressionParser;
import org.apache.qpid.server.query.engine.parsing.ParseException;
import org.apache.qpid.server.query.engine.parsing.converter.NumberConverter;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.accessor.MapObjectAccessor;
import org.apache.qpid.server.query.engine.parsing.expression.set.SetExpression;
import org.apache.qpid.server.query.engine.parsing.query.Order;
import org.apache.qpid.server.query.engine.parsing.query.OrderItem;
import org.apache.qpid.server.query.engine.parsing.query.ProjectionExpression;
import org.apache.qpid.server.query.engine.parsing.query.QueryExpression;
import org.apache.qpid.server.query.engine.parsing.query.SelectExpression;
import org.apache.qpid.server.query.engine.validation.QueryExpressionValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryEvaluator.class);
    private final Broker<?> _broker;
    private final QuerySettings _defaultQuerySettings;
    private final Map<String, QueryExpression<?, ?>> _queryCache;

    public QueryEvaluator(Broker<?> broker) {
        Objects.requireNonNull(broker, "Broker instance not provided for querying");
        this._broker = broker;
        this._defaultQuerySettings = new QuerySettings();
        this._queryCache = null;
    }

    public QueryEvaluator(Map<String, QueryExpression<?, ?>> queryCache, QuerySettings defaultQuerySettings, Broker<?> broker) {
        Objects.requireNonNull(defaultQuerySettings, "Default query settings not provided");
        Objects.requireNonNull(broker, "Broker instance not provided for querying");
        this._broker = broker;
        this._defaultQuerySettings = defaultQuerySettings;
        this._queryCache = queryCache;
    }

    public <R> EvaluationResult<R> execute(String sql) {
        Objects.requireNonNull(sql, "Query not provided");
        if (sql.isEmpty()) {
            throw QueryValidationException.of("Query should not be empty", new Object[0]);
        }
        QuerySettings querySettings = new QuerySettings();
        querySettings.setDatePattern(this._defaultQuerySettings.getDatePattern());
        querySettings.setDateTimeFormat(this._defaultQuerySettings.getDateTimeFormat());
        querySettings.setDecimalDigits(this._defaultQuerySettings.getDecimalDigits());
        querySettings.setMaxBigDecimalValue(this._defaultQuerySettings.getMaxBigDecimalValue());
        querySettings.setMaxQueryCacheSize(this._defaultQuerySettings.getMaxQueryCacheSize());
        querySettings.setMaxQueryDepth(this._defaultQuerySettings.getMaxQueryDepth());
        querySettings.setRoundingMode(this._defaultQuerySettings.getRoundingMode());
        querySettings.setZoneId(this._defaultQuerySettings.getZoneId());
        return this.execute(sql, querySettings);
    }

    public <T, R> EvaluationResult<R> execute(String sql, QuerySettings querySettings) {
        QueryExpression<Object, Object> query;
        Objects.requireNonNull(sql, "Query not provided");
        Objects.requireNonNull(querySettings, "Query settings not provided");
        if (sql.isEmpty()) {
            throw QueryValidationException.of("Query should not be empty", new Object[0]);
        }
        LOGGER.debug("Executing query '{}'", (Object)sql);
        querySettings.setMaxBigDecimalValue(this._defaultQuerySettings.getMaxBigDecimalValue());
        querySettings.setMaxQueryCacheSize(this._defaultQuerySettings.getMaxQueryCacheSize());
        querySettings.setMaxQueryDepth(this._defaultQuerySettings.getMaxQueryDepth());
        EvaluationContext ctx = EvaluationContextHolder.getEvaluationContext();
        ctx.put("query.depth", new AtomicInteger(0));
        ctx.put("query.settings", querySettings);
        ctx.put("broker", this._broker);
        if (querySettings.getDatePattern() != null && !Objects.equals(DefaultQuerySettings.DATE_TIME_PATTERN, querySettings.getDateTimePattern())) {
            ctx.put("query.datetime.pattern.overriden", true);
        }
        ctx.startBuilding();
        try {
            if (this._queryCache != null && this._queryCache.containsKey(sql + "|" + String.valueOf(querySettings))) {
                query = this._queryCache.get(sql + "|" + String.valueOf(querySettings));
            } else {
                query = new ExpressionParser().parseQuery(sql);
                if (this._queryCache != null) {
                    this._queryCache.put(sql + "|" + String.valueOf(querySettings), query);
                }
                LOGGER.debug("Query parsed: {}", query.getSelect());
            }
        }
        catch (ParseException e) {
            throw new QueryParsingException(e);
        }
        return this.evaluate(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, R> EvaluationResult<R> evaluate(QueryExpression<T, R> query) {
        Objects.requireNonNull(query, "Query not provided");
        QueryExpressionValidator queryExpressionValidator = new QueryExpressionValidator();
        queryExpressionValidator.validate(query);
        EvaluationContext ctx = EvaluationContextHolder.getEvaluationContext();
        try {
            ctx.startExecution(query);
            if (query.getWithItems() != null) {
                query.getWithItems().forEach(item -> ctx.put(item.getName(), item.getQuery()));
            }
            if (query.getOrderItems() != null && !query.getOrderItems().isEmpty()) {
                ctx.put("query.ordering", query.getOrderItems());
            }
            Stream<Map<String, Object>> stream = (Stream)query.getSelect().apply(null);
            stream = ctx.contains("query.aggregated.result") ? this.sortAggregatedResult(stream, query) : this.sortResult(stream, query, ctx);
            Integer limit = query.getLimit();
            Integer offset = query.getOffset();
            List list = stream.collect(Collectors.toList());
            long total = list.size();
            stream = list.stream();
            if (offset != null) {
                stream = stream.skip(offset.intValue());
            }
            if (limit != null) {
                stream = stream.limit(limit.intValue());
            }
            EvaluationResult evaluationResult = new EvaluationResult(stream.collect(Collectors.toList()), total);
            return evaluationResult;
        }
        finally {
            EvaluationContextHolder.clearEvaluationContext();
        }
    }

    private <T, R> Stream<Map<String, R>> sortResult(Stream<Map<String, R>> stream, QueryExpression<T, R> query, EvaluationContext ctx) {
        List<OrderItem<T, R>> orderItems = query.getOrderItems();
        List<String> defaultSortingFields = Arrays.asList("alias", "identity", "name");
        Comparator<Map<String, R>> comparator = null;
        SetExpression<T, R> setExpression = query.getSelect();
        ArrayList<ProjectionExpression<T, R>> projections = new ArrayList<ProjectionExpression<T, R>>(setExpression.getProjections());
        if (orderItems.isEmpty() && setExpression instanceof SelectExpression) {
            List list = stream.collect(Collectors.toList());
            if (!list.isEmpty()) {
                ArrayList names = new ArrayList(((Map)list.get(0)).keySet());
                String name = names.stream().filter(item -> defaultSortingFields.stream().anyMatch(element -> Objects.equals(element, item))).findFirst().orElse((String)names.get(0));
                if (!NumberConverter.isNumber(name)) {
                    orderItems.add(new OrderItem(name, new MapObjectAccessor(name), Order.ASC));
                } else {
                    orderItems.add(new OrderItem(String.valueOf(names.indexOf(name) + 1), new MapObjectAccessor(name), Order.ASC));
                }
                ctx.put("query.order.items.for.removal", orderItems.get(orderItems.size() - 1));
            }
            stream = list.stream();
        }
        for (OrderItem<T, R> orderItem : orderItems) {
            if (orderItem.isAliasOrdinal() && (orderItem.getOrdinal() < 1 || orderItem.getOrdinal() - 1 >= projections.size())) {
                throw QueryParsingException.of("Order by item must be the number of a select list expression", new Object[0]);
            }
            String alias = !orderItem.isAliasOrdinal() ? orderItem.getAlias() : ((ProjectionExpression)projections.get(orderItem.getOrdinal() - 1)).getAlias();
            ExpressionNode expression = !orderItem.isAliasOrdinal() ? orderItem.getExpression() : (ExpressionNode)((ProjectionExpression)projections.get(orderItem.getOrdinal() - 1)).getExpression();
            Comparator<Map<String, R>> itemComparator = this.createComparator(expression, orderItem, alias);
            if (comparator == null) {
                comparator = Comparator.nullsLast(itemComparator);
                continue;
            }
            comparator = comparator.thenComparing(itemComparator);
        }
        if (comparator != null) {
            stream = stream.sorted(comparator);
        }
        if (ctx.contains("query.items.for.removal")) {
            List expressions = (List)ctx.get("query.items.for.removal");
            setExpression.getSelections().forEach(selection -> selection.getProjections().removeAll(expressions));
            stream = stream.peek(item -> expressions.forEach(expression -> item.remove(expression.getAlias())));
        }
        if (ctx.contains("query.order.items.for.removal")) {
            OrderItem item2 = (OrderItem)ctx.get("query.order.items.for.removal");
            query.getOrderItems().remove(item2);
        }
        return stream;
    }

    private <T, R> Comparator<Map<String, R>> createComparator(ExpressionNode<T, R> expression, OrderItem<T, R> orderItem, String alias) {
        AtomicBoolean replaced = new AtomicBoolean(false);
        return (map1, map2) -> {
            if (!replaced.get()) {
                EvaluationContext ctx = EvaluationContextHolder.getEvaluationContext();
                Map aliases = ctx.get("query.aliases", Map.class);
                for (Map.Entry entry : aliases.entrySet()) {
                    entry.setValue(item -> item);
                }
                replaced.set(true);
            }
            Object object1 = expression.apply(map1);
            Object object2 = expression.apply(map2);
            if (object1 != null && !(object1 instanceof Comparable) || object2 != null && !(object2 instanceof Comparable)) {
                throw QueryParsingException.of("Sorting by field '%s' not supported", alias);
            }
            if (object1 instanceof Number && object2 instanceof Number && !object1.getClass().isInstance(object2)) {
                object1 = NumberConverter.toDouble(object1);
                object2 = NumberConverter.toDouble(object2);
            }
            Comparable comparable1 = (Comparable)object1;
            Comparable comparable = (Comparable)object2;
            if (comparable1 == null) {
                return comparable == null ? 0 : -1;
            }
            if (comparable == null) {
                return 1;
            }
            return orderItem.getOrder().equals((Object)Order.ASC) ? comparable1.compareTo(comparable) : comparable.compareTo(comparable1);
        };
    }

    private <T, R> Stream<Map<String, R>> sortAggregatedResult(Stream<Map<String, R>> stream, QueryExpression<T, R> query) {
        Map<String, R> map = stream.findFirst().orElse(new HashMap());
        List<OrderItem<T, R>> orderItems = query.getOrderItems();
        SelectExpression select = (SelectExpression)query.getSelect();
        for (OrderItem<T, R> orderItem : orderItems) {
            if (orderItem.isAliasOrdinal() && (orderItem.getOrdinal() < 1 || orderItem.getOrdinal() - 1 >= query.getSelect().getProjections().size())) {
                throw QueryParsingException.of("Order by item must be the number of a select list expression", new Object[0]);
            }
            String alias = !orderItem.isAliasOrdinal() ? orderItem.getAlias() : select.getProjections().get(orderItem.getOrdinal() - 1).getAlias();
            boolean isAggregation = select.getProjections().stream().filter(projection -> Objects.equals(alias, projection.getAlias())).map(projection -> !projection.getAggregations().isEmpty()).findFirst().orElse(false);
            int level = isAggregation ? select.getGroupBy().size() : 1 + IntStream.range(0, select.getGroupBy().size()).filter(i -> Objects.equals(alias, select.getGroupBy().get(i).getAlias())).findFirst().orElse(-1);
            this.addComparator(map, level, orderItem.getOrder(), isAggregation);
        }
        map = this.sort(map);
        return Stream.of(map);
    }

    private <R> void addComparator(Map<String, R> map, int level, Order order, boolean isAggregation) {
        for (Map.Entry<String, R> entry : map.entrySet()) {
            if (Objects.equals("comparators", entry.getKey())) continue;
            if (level > 0 && entry.getValue() instanceof Map) {
                this.addComparator((Map)entry.getValue(), level - 1, order, isAggregation);
                continue;
            }
            Comparator<Map.Entry<Object, Object>> newComparator = isAggregation ? Map.Entry.comparingByValue(order == Order.ASC ? Comparator.naturalOrder() : Comparator.reverseOrder()) : Map.Entry.comparingByKey(order == Order.ASC ? Comparator.naturalOrder() : Comparator.reverseOrder());
            List<Comparator<Map.Entry<Object, Object>>> comparators = new ArrayList();
            if (map.containsKey("comparators")) {
                comparators = (List)map.get("comparators");
                comparators.add(newComparator);
            } else {
                comparators.add(newComparator);
            }
            if (isAggregation) {
                comparators.add(Map.Entry.comparingByKey(Comparator.naturalOrder()));
            }
            map.put("comparators", comparators);
            break;
        }
    }

    private <R> Map<String, R> sort(Map<String, R> map) {
        for (Map.Entry<String, R> entry : map.entrySet()) {
            if (!(entry.getValue() instanceof Map)) continue;
            Map child = (Map)entry.getValue();
            List list = child.containsKey("comparators") ? (List)child.remove("comparators") : Collections.singletonList(Map.Entry.comparingByKey(Comparator.naturalOrder()));
            Comparator comparator = (Comparator)list.get(0);
            if (list.size() > 1) {
                comparator = comparator.thenComparing((Comparator)list.get(list.size() - 1));
            }
            ArrayList entries = new ArrayList(child.entrySet());
            entries.sort(comparator);
            LinkedHashMap result = new LinkedHashMap();
            for (Map.Entry entry2 : entries) {
                result.put((String)entry2.getKey(), entry2.getValue());
            }
            entry.setValue(result);
            this.sort((Map)entry.getValue());
        }
        ArrayList<Map.Entry<String, R>> entries = new ArrayList<Map.Entry<String, R>>(map.entrySet());
        entries.sort(Map.Entry.comparingByKey());
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : entries) {
            result.put((String)entry.getKey(), entry.getValue());
        }
        return result;
    }
}

