/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.qpid.server.transport.network.security.ssl.SSLUtil;

public class CipherSuiteAndProtocolRestrictingSSLSocketFactory
extends SSLSocketFactory {
    private final SSLSocketFactory _wrappedSocketFactory;
    private final List<String> _tlsCipherSuiteAllowList;
    private final List<String> _tlsCipherSuiteDenyList;
    private final List<String> _tlsProtocolAllowList;
    private final List<String> _tlsProtocolDenyList;

    public CipherSuiteAndProtocolRestrictingSSLSocketFactory(SSLSocketFactory wrappedSocketFactory, List<String> tlsCipherSuiteAllowList, List<String> tlsCipherSuiteDenyList, List<String> tlsProtocolAllowList, List<String> tlsProtocolDenyList) {
        this._wrappedSocketFactory = wrappedSocketFactory;
        this._tlsCipherSuiteAllowList = tlsCipherSuiteAllowList == null ? null : new ArrayList<String>(tlsCipherSuiteAllowList);
        this._tlsCipherSuiteDenyList = tlsCipherSuiteDenyList == null ? null : new ArrayList<String>(tlsCipherSuiteDenyList);
        this._tlsProtocolAllowList = tlsProtocolAllowList == null ? null : new ArrayList<String>(tlsProtocolAllowList);
        this._tlsProtocolDenyList = tlsProtocolDenyList == null ? null : new ArrayList<String>(tlsProtocolDenyList);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return SSLUtil.filterEnabledCipherSuites(this._wrappedSocketFactory.getDefaultCipherSuites(), this._wrappedSocketFactory.getSupportedCipherSuites(), this._tlsCipherSuiteAllowList, this._tlsCipherSuiteDenyList);
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this._wrappedSocketFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        SSLSocket newSocket = (SSLSocket)this._wrappedSocketFactory.createSocket(socket, host, port, autoClose);
        SSLUtil.updateEnabledCipherSuites(newSocket, this._tlsCipherSuiteAllowList, this._tlsCipherSuiteDenyList);
        SSLUtil.updateEnabledTlsProtocols(newSocket, this._tlsProtocolAllowList, this._tlsProtocolDenyList);
        return newSocket;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        SSLSocket socket = (SSLSocket)this._wrappedSocketFactory.createSocket(host, port);
        SSLUtil.updateEnabledCipherSuites(socket, this._tlsCipherSuiteAllowList, this._tlsCipherSuiteDenyList);
        SSLUtil.updateEnabledTlsProtocols(socket, this._tlsProtocolAllowList, this._tlsProtocolDenyList);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localhost, int localPort) throws IOException, UnknownHostException {
        SSLSocket socket = (SSLSocket)this._wrappedSocketFactory.createSocket(host, port, localhost, localPort);
        SSLUtil.updateEnabledCipherSuites(socket, this._tlsCipherSuiteAllowList, this._tlsCipherSuiteDenyList);
        SSLUtil.updateEnabledTlsProtocols(socket, this._tlsProtocolAllowList, this._tlsProtocolDenyList);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        SSLSocket socket = (SSLSocket)this._wrappedSocketFactory.createSocket(host, port);
        SSLUtil.updateEnabledCipherSuites(socket, this._tlsCipherSuiteAllowList, this._tlsCipherSuiteDenyList);
        SSLUtil.updateEnabledTlsProtocols(socket, this._tlsProtocolAllowList, this._tlsProtocolDenyList);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLSocket socket = (SSLSocket)this._wrappedSocketFactory.createSocket(address, port, localAddress, localPort);
        SSLUtil.updateEnabledCipherSuites(socket, this._tlsCipherSuiteAllowList, this._tlsCipherSuiteDenyList);
        SSLUtil.updateEnabledTlsProtocols(socket, this._tlsProtocolAllowList, this._tlsProtocolDenyList);
        return socket;
    }
}

