/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.nlpmodel.embedding.remote.custom;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.seatunnel.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.seatunnel.transform.nlpmodel.CustomConfigPlaceholder;
import org.apache.seatunnel.transform.nlpmodel.embedding.remote.AbstractModel;

public class CustomModel
extends AbstractModel {
    private final CloseableHttpClient client;
    private final String model;
    private final String apiPath;
    private final Map<String, String> header;
    private final Map<String, Object> body;
    private final String parse;

    public CustomModel(String model, String apiPath, Map<String, String> header, Map<String, Object> body, String parse, Integer vectorizedNumber) {
        super(vectorizedNumber);
        this.apiPath = apiPath;
        this.model = model;
        this.header = header;
        this.body = body;
        this.parse = parse;
        this.client = HttpClients.createDefault();
    }

    @Override
    protected List<List<Float>> vector(Object[] fields) throws IOException {
        return this.vectorGeneration(fields);
    }

    @Override
    public Integer dimension() throws IOException {
        return this.vectorGeneration(new Object[]{"dimension example"}).size();
    }

    private List<List<Float>> vectorGeneration(Object[] fields) throws IOException {
        HttpPost post = new HttpPost(this.apiPath);
        for (Map.Entry<String, String> entry : this.header.entrySet()) {
            post.setHeader(entry.getKey(), entry.getValue());
        }
        post.setEntity(new StringEntity(OBJECT_MAPPER.writeValueAsString((Object)this.createJsonNodeFromData(fields)), "UTF-8"));
        CloseableHttpResponse response = this.client.execute(post);
        String responseStr = EntityUtils.toString(response.getEntity());
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new IOException("Failed to get vector from custom, response: " + responseStr);
        }
        return (List)OBJECT_MAPPER.convertValue(this.parseResponse(responseStr), (TypeReference)new TypeReference<List<List<Float>>>(){});
    }

    @VisibleForTesting
    public Object parseResponse(String responseStr) {
        return JsonPath.parse(responseStr).read(this.parse, new Predicate[0]);
    }

    @VisibleForTesting
    public ObjectNode createJsonNodeFromData(Object[] fields) throws IOException {
        JsonNode rootNode = OBJECT_MAPPER.readTree(OBJECT_MAPPER.writeValueAsString(this.body));
        Iterator bodyFields = rootNode.fields();
        while (bodyFields.hasNext()) {
            Map.Entry field = (Map.Entry)bodyFields.next();
            String fieldName = (String)field.getKey();
            JsonNode fieldValue = (JsonNode)field.getValue();
            if (fieldValue.isTextual()) {
                String value = fieldValue.asText();
                if (CustomConfigPlaceholder.findPlaceholder(value, "model").booleanValue()) {
                    ((ObjectNode)rootNode).put(fieldName, CustomConfigPlaceholder.replacePlaceholders(value, "model", this.model, null));
                    continue;
                }
                if (!CustomConfigPlaceholder.findPlaceholder(value, "input").booleanValue()) continue;
                ((ObjectNode)rootNode).put(fieldName, CustomConfigPlaceholder.replacePlaceholders(value, "input", fields[0].toString(), null));
                continue;
            }
            if (!fieldValue.isArray()) continue;
            ArrayNode arrayNode = (ArrayNode)OBJECT_MAPPER.valueToTree(Arrays.asList(fields));
            ((ObjectNode)rootNode).set(fieldName, (JsonNode)arrayNode);
        }
        return (ObjectNode)rootNode;
    }

    @Override
    public void close() throws IOException {
        if (this.client != null) {
            this.client.close();
        }
    }
}

