/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.sql.zeta.functions;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.transform.exception.TransformException;

public class SystemFunction {
    public static Object coalesce(List<Object> args) {
        Object v = null;
        for (Object v2 : args) {
            if (v2 == null) continue;
            v = v2;
            break;
        }
        return v;
    }

    public static Object ifnull(List<Object> args) {
        if (args.size() != 2) {
            throw new TransformException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, String.format("Unsupported function IFNULL() arguments: %s", args));
        }
        return SystemFunction.coalesce(args);
    }

    public static Object nullif(List<Object> args) {
        Object v1 = args.get(0);
        Object v2 = args.get(1);
        if (v1 == null) {
            return null;
        }
        if (v1.equals(v2)) {
            return null;
        }
        return v1;
    }

    public static String[] array(List<Object> args) {
        if (CollectionUtils.isNotEmpty(args)) {
            return (String[])args.stream().map(obj -> obj == null ? null : obj.toString()).toArray(String[]::new);
        }
        return new String[0];
    }

    public static Object castAs(Object arg, SeaTunnelDataType<?> type) {
        ArrayList<Object> args = new ArrayList<Object>(4);
        args.add(arg);
        args.add(type.getSqlType().toString());
        if (DecimalType.class.equals(type.getClass())) {
            DecimalType decimalType = (DecimalType)type;
            args.add(decimalType.getPrecision());
            args.add(decimalType.getScale());
        }
        return SystemFunction.castAs(args);
    }

    public static Object castAs(List<Object> args) {
        Object v1 = args.get(0);
        String v2 = (String)args.get(1);
        if (v1 == null) {
            return null;
        }
        if (v1.equals(v2)) {
            return null;
        }
        switch (v2) {
            case "VARCHAR": 
            case "STRING": {
                return v1.toString();
            }
            case "INT": 
            case "INTEGER": {
                return Integer.parseInt(v1.toString());
            }
            case "BIGINT": 
            case "LONG": {
                return Long.parseLong(v1.toString());
            }
            case "BYTE": {
                return Byte.parseByte(v1.toString());
            }
            case "BYTES": 
            case "BINARY": {
                return v1.toString().getBytes(StandardCharsets.UTF_8);
            }
            case "DOUBLE": {
                return Double.parseDouble(v1.toString());
            }
            case "FLOAT": {
                return Float.valueOf(Float.parseFloat(v1.toString()));
            }
            case "TIMESTAMP": 
            case "DATETIME": {
                if (v1 instanceof LocalDateTime) {
                    return v1;
                }
                if (v1 instanceof LocalDate) {
                    return LocalDateTime.of((LocalDate)v1, LocalTime.of(0, 0, 0));
                }
                if (v1 instanceof LocalTime) {
                    return LocalDateTime.of(LocalDate.now(), (LocalTime)v1);
                }
                if (v1 instanceof Long) {
                    Instant instant = Instant.ofEpochMilli((Long)v1);
                    ZoneId zone = ZoneId.systemDefault();
                    return LocalDateTime.ofInstant(instant, zone);
                }
                throw new TransformException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, String.format("Unsupported CAST AS type: %s", v2));
            }
            case "DATE": {
                if (v1 instanceof LocalDateTime) {
                    return ((LocalDateTime)v1).toLocalDate();
                }
                if (v1 instanceof LocalDate) {
                    return v1;
                }
                if (v1 instanceof Integer) {
                    int dateValue = (Integer)v1;
                    int year = dateValue / 10000;
                    int month = dateValue / 100 % 100;
                    int day = dateValue % 100;
                    return LocalDate.of(year, month, day);
                }
                throw new TransformException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, String.format("Unsupported CAST AS type: %s", v2));
            }
            case "TIME": {
                if (v1 instanceof LocalDateTime) {
                    return ((LocalDateTime)v1).toLocalTime();
                }
                if (v1 instanceof LocalDate) {
                    return LocalTime.of(0, 0, 0);
                }
                if (v1 instanceof LocalTime) {
                    return v1;
                }
                if (v1 instanceof Integer) {
                    int intTime = (Integer)v1;
                    int hour = intTime / 10000;
                    int minute = intTime / 100 % 100;
                    int second = intTime % 100;
                    return LocalTime.of(hour, minute, second);
                }
                throw new TransformException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, String.format("Unsupported CAST AS type: %s", v2));
            }
            case "DECIMAL": {
                BigDecimal bigDecimal = new BigDecimal(v1.toString());
                Integer scale = (Integer)args.get(3);
                return bigDecimal.setScale((int)scale, RoundingMode.CEILING);
            }
        }
        throw new TransformException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, String.format("Unsupported CAST AS type: %s", v2));
    }
}

