/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.impl.doubles;

import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;
import org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.AbstractPrimitiveWriters;
import org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.RepeatedPrimitiveWriteSchemas;

public class DoubleNotPackedWriteSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor) {
        return RepeatedPrimitiveWriteSchemas.create(protoField, propertyDescriptor, new DoubleNotPackedWriters(protoField));
    }

    private static class DoubleNotPackedWriters
    extends AbstractPrimitiveWriters<double[], Double> {
        public DoubleNotPackedWriters(Field protoField) {
            super(protoField);
            this.primitiveArrayWriter = (output, array) -> {
                for (double element : array) {
                    output.writeDouble(this.tag, this.tagSize, element);
                }
            };
            this.arrayWriter = (output, array) -> {
                for (Double element : array) {
                    if (element != null) {
                        output.writeDouble(this.tag, this.tagSize, element);
                        continue;
                    }
                    ProtoUtils.throwNotSupportNullElement(protoField);
                }
            };
            this.collectionWriter = (output, collection) -> {
                for (Double element : collection) {
                    if (element != null) {
                        output.writeDouble(this.tag, this.tagSize, element);
                        continue;
                    }
                    ProtoUtils.throwNotSupportNullElement(protoField);
                }
            };
            this.stringArrayWriter = (output, array) -> {
                for (String element : array) {
                    if (element != null) {
                        double parsedValue = Double.parseDouble(element);
                        output.writeDouble(this.tag, this.tagSize, parsedValue);
                        continue;
                    }
                    ProtoUtils.throwNotSupportNullElement(protoField);
                }
            };
        }
    }
}

