/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe.internal;

import java.time.Duration;
import net.jodah.failsafe.CircuitBreaker;
import net.jodah.failsafe.ExecutionContext;
import net.jodah.failsafe.internal.CircuitStats;

public abstract class CircuitState {
    final CircuitBreaker breaker;
    volatile CircuitStats stats;

    CircuitState(CircuitBreaker breaker, CircuitStats stats) {
        this.breaker = breaker;
        this.stats = stats;
    }

    public abstract boolean allowsExecution();

    public Duration getRemainingDelay() {
        return Duration.ZERO;
    }

    public CircuitStats getStats() {
        return this.stats;
    }

    public abstract CircuitBreaker.State getState();

    public synchronized void recordFailure(ExecutionContext context) {
        this.stats.recordFailure();
        this.checkThreshold(context);
    }

    public synchronized void recordSuccess() {
        this.stats.recordSuccess();
        this.checkThreshold(null);
    }

    public void handleConfigChange() {
    }

    void checkThreshold(ExecutionContext context) {
    }
}

