/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp;

import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.List;
import java.util.function.BiPredicate;
import org.springframework.ai.mcp.SyncMcpToolCallback;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.ai.tool.support.ToolUtils;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class SyncMcpToolCallbackProvider
implements ToolCallbackProvider {
    private final List<McpSyncClient> mcpClients;
    private final BiPredicate<McpSyncClient, McpSchema.Tool> toolFilter;

    public SyncMcpToolCallbackProvider(BiPredicate<McpSyncClient, McpSchema.Tool> toolFilter, List<McpSyncClient> mcpClients) {
        Assert.notNull(mcpClients, (String)"MCP clients must not be null");
        Assert.notNull(toolFilter, (String)"Tool filter must not be null");
        this.mcpClients = mcpClients;
        this.toolFilter = toolFilter;
    }

    public SyncMcpToolCallbackProvider(List<McpSyncClient> mcpClients) {
        this((McpSyncClient mcpClient, McpSchema.Tool tool) -> true, mcpClients);
    }

    public SyncMcpToolCallbackProvider(BiPredicate<McpSyncClient, McpSchema.Tool> toolFilter, McpSyncClient ... mcpClients) {
        this(toolFilter, List.of(mcpClients));
    }

    public SyncMcpToolCallbackProvider(McpSyncClient ... mcpClients) {
        this(List.of(mcpClients));
    }

    public ToolCallback[] getToolCallbacks() {
        ToolCallback[] array = (ToolCallback[])this.mcpClients.stream().flatMap(mcpClient -> mcpClient.listTools().tools().stream().filter(tool -> this.toolFilter.test((McpSyncClient)mcpClient, (McpSchema.Tool)tool)).map(tool -> new SyncMcpToolCallback((McpSyncClient)mcpClient, (McpSchema.Tool)tool))).toArray(ToolCallback[]::new);
        this.validateToolCallbacks(array);
        return array;
    }

    private void validateToolCallbacks(ToolCallback[] toolCallbacks) {
        List duplicateToolNames = ToolUtils.getDuplicateToolNames((ToolCallback[])toolCallbacks);
        if (!duplicateToolNames.isEmpty()) {
            throw new IllegalStateException("Multiple tools with the same name (%s)".formatted(String.join((CharSequence)", ", duplicateToolNames)));
        }
    }

    public static List<ToolCallback> syncToolCallbacks(List<McpSyncClient> mcpClients) {
        if (CollectionUtils.isEmpty(mcpClients)) {
            return List.of();
        }
        return List.of(new SyncMcpToolCallbackProvider(mcpClients).getToolCallbacks());
    }
}

