/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.yahoo.sketches;

import org.apache.pulsar.shade.com.yahoo.sketches.SketchesArgumentException;

public final class BoundsOnBinomialProportions {
    private BoundsOnBinomialProportions() {
    }

    public static double approximateLowerBoundOnP(long n, long k, double numStdDevs) {
        BoundsOnBinomialProportions.checkInputs(n, k);
        if (n == 0L) {
            return 0.0;
        }
        if (k == 0L) {
            return 0.0;
        }
        if (k == 1L) {
            return BoundsOnBinomialProportions.exactLowerBoundOnPForKequalsOne(n, BoundsOnBinomialProportions.deltaOfNumStdevs(numStdDevs));
        }
        if (k == n) {
            return BoundsOnBinomialProportions.exactLowerBoundOnPForKequalsN(n, BoundsOnBinomialProportions.deltaOfNumStdevs(numStdDevs));
        }
        double x = BoundsOnBinomialProportions.abramowitzStegunFormula26p5p22(n - k + 1L, k, -1.0 * numStdDevs);
        return 1.0 - x;
    }

    public static double approximateUpperBoundOnP(long n, long k, double numStdDevs) {
        BoundsOnBinomialProportions.checkInputs(n, k);
        if (n == 0L) {
            return 1.0;
        }
        if (k == n) {
            return 1.0;
        }
        if (k == n - 1L) {
            return BoundsOnBinomialProportions.exactUpperBoundOnPForKequalsNminusOne(n, BoundsOnBinomialProportions.deltaOfNumStdevs(numStdDevs));
        }
        if (k == 0L) {
            return BoundsOnBinomialProportions.exactUpperBoundOnPForKequalsZero(n, BoundsOnBinomialProportions.deltaOfNumStdevs(numStdDevs));
        }
        double x = BoundsOnBinomialProportions.abramowitzStegunFormula26p5p22(n - k, k + 1L, numStdDevs);
        return 1.0 - x;
    }

    public static double estimateUnknownP(long n, long k) {
        BoundsOnBinomialProportions.checkInputs(n, k);
        if (n == 0L) {
            return 0.5;
        }
        return (double)k / (double)n;
    }

    private static void checkInputs(long n, long k) {
        if (n < 0L) {
            throw new SketchesArgumentException("N must be non-negative");
        }
        if (k < 0L) {
            throw new SketchesArgumentException("K must be non-negative");
        }
        if (k > n) {
            throw new SketchesArgumentException("K cannot exceed N");
        }
    }

    public static double erf(double x) {
        if (x < 0.0) {
            return -1.0 * BoundsOnBinomialProportions.erf_of_nonneg(-1.0 * x);
        }
        return BoundsOnBinomialProportions.erf_of_nonneg(x);
    }

    public static double normalCDF(double x) {
        return 0.5 * (1.0 + BoundsOnBinomialProportions.erf(x / Math.sqrt(2.0)));
    }

    private static double erf_of_nonneg(double x) {
        double a1 = 0.0705230784;
        double a3 = 0.0092705272;
        double a5 = 2.765672E-4;
        double a2 = 0.0422820123;
        double a4 = 1.520143E-4;
        double a6 = 4.30638E-5;
        double x2 = x * x;
        double x3 = x2 * x;
        double x4 = x2 * x2;
        double x5 = x2 * x3;
        double x6 = x3 * x3;
        double sum = 1.0 + 0.0705230784 * x + 0.0422820123 * x2 + 0.0092705272 * x3 + 1.520143E-4 * x4 + 2.765672E-4 * x5 + 4.30638E-5 * x6;
        double sum2 = sum * sum;
        double sum4 = sum2 * sum2;
        double sum8 = sum4 * sum4;
        double sum16 = sum8 * sum8;
        return 1.0 - 1.0 / sum16;
    }

    private static double deltaOfNumStdevs(double kappa) {
        return BoundsOnBinomialProportions.normalCDF(-1.0 * kappa);
    }

    private static double abramowitzStegunFormula26p5p22(double a, double b, double yp) {
        double b2m1 = 2.0 * b - 1.0;
        double a2m1 = 2.0 * a - 1.0;
        double lambda = (yp * yp - 3.0) / 6.0;
        double htmp = 1.0 / a2m1 + 1.0 / b2m1;
        double h2 = 2.0 / htmp;
        double term1 = yp * Math.sqrt(h2 + lambda) / h2;
        double term2 = 1.0 / b2m1 - 1.0 / a2m1;
        double term3 = lambda + 0.8333333333333334 - 2.0 / (3.0 * h2);
        double w = term1 - term2 * term3;
        double xp = a / (a + b * Math.exp(2.0 * w));
        return xp;
    }

    private static double exactUpperBoundOnPForKequalsZero(double n, double delta) {
        return 1.0 - Math.pow(delta, 1.0 / n);
    }

    private static double exactLowerBoundOnPForKequalsN(double n, double delta) {
        return Math.pow(delta, 1.0 / n);
    }

    private static double exactLowerBoundOnPForKequalsOne(double n, double delta) {
        return 1.0 - Math.pow(1.0 - delta, 1.0 / n);
    }

    private static double exactUpperBoundOnPForKequalsNminusOne(double n, double delta) {
        return Math.pow(1.0 - delta, 1.0 / n);
    }
}

