/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http.factory;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.http.RestClient;
import org.apache.dubbo.remoting.http.config.HttpClientConfig;
import org.apache.dubbo.remoting.http.factory.RestClientFactory;
import org.apache.dubbo.rpc.RpcException;

public abstract class AbstractHttpClientFactory
implements RestClientFactory {
    protected final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(this.getClass());
    protected HttpClientConfig httpClientConfig = new HttpClientConfig();

    @Override
    public RestClient createRestClient(URL url) throws RpcException {
        this.beforeCreated(url);
        RestClient restClient = this.doCreateRestClient(url);
        this.afterCreated(restClient);
        return restClient;
    }

    protected void beforeCreated(URL url) {
    }

    protected abstract RestClient doCreateRestClient(URL var1) throws RpcException;

    protected void afterCreated(RestClient client) {
    }
}

