/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.sofarpc;

import com.alipay.remoting.InvokeCallback;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;

public class InvokeCallbackWrapper
implements InvokeCallback {
    private ContextSnapshot contextSnapshot;
    private final InvokeCallback invokeCallback;

    public InvokeCallbackWrapper(InvokeCallback invokeCallback) {
        if (ContextManager.isActive()) {
            this.contextSnapshot = ContextManager.capture();
        }
        this.invokeCallback = invokeCallback;
    }

    public void onResponse(Object o) {
        ContextManager.createLocalSpan((String)("Thread/" + this.invokeCallback.getClass().getName() + "/onResponse"));
        if (this.contextSnapshot != null) {
            ContextManager.continued((ContextSnapshot)this.contextSnapshot);
        }
        try {
            this.invokeCallback.onResponse(o);
        }
        catch (Throwable t) {
            ContextManager.activeSpan().log(t);
            throw t;
        }
        finally {
            this.contextSnapshot = null;
            ContextManager.stopSpan();
        }
    }

    public void onException(Throwable throwable) {
        AbstractSpan abstractSpan;
        ContextManager.createLocalSpan((String)("Thread/" + this.invokeCallback.getClass().getName() + "/onException"));
        if (this.contextSnapshot != null) {
            ContextManager.continued((ContextSnapshot)this.contextSnapshot);
        }
        if (throwable != null && (abstractSpan = ContextManager.activeSpan()) != null) {
            abstractSpan.log(throwable);
        }
        try {
            this.invokeCallback.onException(throwable);
        }
        catch (Throwable t) {
            ContextManager.activeSpan().log(t);
            throw t;
        }
        finally {
            this.contextSnapshot = null;
            ContextManager.stopSpan();
        }
    }

    public Executor getExecutor() {
        return this.invokeCallback.getExecutor();
    }

    @Generated
    ContextSnapshot getContextSnapshot() {
        return this.contextSnapshot;
    }

    @Generated
    InvokeCallback getInvokeCallback() {
        return this.invokeCallback;
    }
}

