/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.redisson.v3;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collection;
import java.util.Objects;
import org.apache.skywalking.apm.agent.core.context.util.PeerFormat;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.plugin.redisson.v3.util.ClassUtil;
import org.redisson.config.Config;
import org.redisson.connection.MasterSlaveConnectionManager;
import org.redisson.connection.ServiceManager;

public class ConnectionManagerInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final ILog LOGGER = LogManager.getLogger(ConnectionManagerInterceptor.class);

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        try {
            Config config = this.getConfig(objInst);
            Object singleServerConfig = null;
            Object sentinelServersConfig = null;
            Object masterSlaveServersConfig = null;
            Object clusterServersConfig = null;
            Object replicatedServersConfig = null;
            if (Objects.nonNull(config)) {
                singleServerConfig = ClassUtil.getObjectField(config, "singleServerConfig");
                sentinelServersConfig = ClassUtil.getObjectField(config, "sentinelServersConfig");
                masterSlaveServersConfig = ClassUtil.getObjectField(config, "masterSlaveServersConfig");
                clusterServersConfig = ClassUtil.getObjectField(config, "clusterServersConfig");
                replicatedServersConfig = ClassUtil.getObjectField(config, "replicatedServersConfig");
            }
            StringBuilder peer = new StringBuilder();
            EnhancedInstance retInst = (EnhancedInstance)ret;
            if (singleServerConfig != null) {
                Object singleAddress = ClassUtil.getObjectField(singleServerConfig, "address");
                peer.append(ConnectionManagerInterceptor.getPeer(singleAddress));
                retInst.setSkyWalkingDynamicField((Object)PeerFormat.shorten((String)peer.toString()));
                return ret;
            }
            if (sentinelServersConfig != null) {
                this.appendAddresses(peer, (Collection)ClassUtil.getObjectField(sentinelServersConfig, "sentinelAddresses"));
                retInst.setSkyWalkingDynamicField((Object)PeerFormat.shorten((String)peer.toString()));
                return ret;
            }
            if (masterSlaveServersConfig != null) {
                Object masterAddress = ClassUtil.getObjectField(masterSlaveServersConfig, "masterAddress");
                peer.append(ConnectionManagerInterceptor.getPeer(masterAddress)).append(";");
                this.appendAddresses(peer, (Collection)ClassUtil.getObjectField(masterSlaveServersConfig, "slaveAddresses"));
                retInst.setSkyWalkingDynamicField((Object)PeerFormat.shorten((String)peer.toString()));
                return ret;
            }
            if (clusterServersConfig != null) {
                this.appendAddresses(peer, (Collection)ClassUtil.getObjectField(clusterServersConfig, "nodeAddresses"));
                retInst.setSkyWalkingDynamicField((Object)PeerFormat.shorten((String)peer.toString()));
                return ret;
            }
            if (replicatedServersConfig != null) {
                this.appendAddresses(peer, (Collection)ClassUtil.getObjectField(replicatedServersConfig, "nodeAddresses"));
                retInst.setSkyWalkingDynamicField((Object)PeerFormat.shorten((String)peer.toString()));
                return ret;
            }
        }
        catch (Exception e) {
            LOGGER.warn("redisClient set peer error: ", new Object[]{e});
        }
        return ret;
    }

    private void appendAddresses(StringBuilder peer, Collection nodeAddresses) {
        if (nodeAddresses != null && !nodeAddresses.isEmpty()) {
            for (Object uri : nodeAddresses) {
                peer.append(ConnectionManagerInterceptor.getPeer(uri)).append(";");
            }
        }
    }

    static String getPeer(Object obj) {
        if (obj instanceof String) {
            return ((String)obj).replace("redis://", "");
        }
        if (obj instanceof URI) {
            URI uri = (URI)obj;
            return uri.getHost() + ":" + uri.getPort();
        }
        LOGGER.warn("redisson not support this version", new Object[0]);
        return null;
    }

    private Config getConfig(EnhancedInstance objInst) {
        Config config = null;
        MasterSlaveConnectionManager connectionManager = (MasterSlaveConnectionManager)objInst;
        try {
            config = (Config)ClassUtil.getObjectField(connectionManager, "cfg");
        }
        catch (IllegalAccessException | NoSuchFieldException ignore) {
            try {
                ServiceManager serviceManager = (ServiceManager)ClassUtil.getObjectField(connectionManager, "serviceManager");
                config = serviceManager.getCfg();
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        }
        return config;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }
}

