/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.hierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.jcr2spi.WorkspaceManager;
import org.apache.jackrabbit.jcr2spi.config.CacheBehaviour;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyManager;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.observation.InternalEventListener;
import org.apache.jackrabbit.spi.Event;
import org.apache.jackrabbit.spi.EventBundle;
import org.apache.jackrabbit.spi.EventFilter;
import org.apache.jackrabbit.spi.ItemId;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HierarchyEventListener
implements InternalEventListener {
    private static Logger log = LoggerFactory.getLogger(HierarchyEventListener.class);
    private final HierarchyManager hierarchyMgr;
    private final Collection<EventFilter> eventFilter;

    public HierarchyEventListener(WorkspaceManager wspManager, HierarchyManager hierarchyMgr, CacheBehaviour cacheBehaviour) {
        this.hierarchyMgr = hierarchyMgr;
        if (cacheBehaviour == CacheBehaviour.OBSERVATION) {
            EventFilter filter = null;
            try {
                Path root = wspManager.getPathFactory().getRootPath();
                filter = wspManager.createEventFilter(127, root, true, null, null, true);
            }
            catch (RepositoryException e) {
                log.debug("Creating event filter for cache behavior observation failed", (Throwable)e);
            }
            this.eventFilter = filter == null ? Collections.emptyList() : Collections.singletonList(filter);
        } else {
            this.eventFilter = Collections.emptyList();
        }
    }

    @Override
    public Collection<EventFilter> getEventFilters() {
        return this.eventFilter;
    }

    @Override
    public void onEvent(EventBundle eventBundle) {
        if (eventBundle.isLocal()) {
            log.debug("Local event bundle -> not processed by HierarchyEventListener.");
            return;
        }
        this.pushEvents(HierarchyEventListener.getEventCollection(eventBundle));
    }

    private void pushEvents(Collection<Event> events) {
        if (events.isEmpty()) {
            log.debug("Empty event bundle");
            return;
        }
        HashSet<ItemId> removedEvents = new HashSet<ItemId>();
        HashSet<Event> addEvents = new HashSet<Event>();
        Iterator<Event> it = events.iterator();
        while (it.hasNext()) {
            Event event = it.next();
            int type = event.getType();
            if (type == 2) {
                removedEvents.add(event.getItemId());
                continue;
            }
            if (type != 1 && type != 4) continue;
            addEvents.add(event);
            it.remove();
        }
        boolean progress = true;
        while (!addEvents.isEmpty() && progress) {
            progress = false;
            Iterator it2 = addEvents.iterator();
            while (it2.hasNext()) {
                Event ev = (Event)it2.next();
                NodeId parentId = ev.getParentId();
                HierarchyEntry parent = null;
                if (parentId != null && (parent = this.hierarchyMgr.lookup((ItemId)parentId)) == null && ev.getPath() != null && parentId.getUniqueID() != null) {
                    try {
                        Path parentPath = ev.getPath().getAncestor(1);
                        parent = this.hierarchyMgr.lookup(parentPath);
                    }
                    catch (RepositoryException e) {
                        log.debug(e.getMessage());
                    }
                }
                if (parent == null || !parent.denotesNode()) continue;
                ((NodeEntry)parent).refresh(ev);
                it2.remove();
                progress = true;
            }
        }
        block11: for (Event event : events) {
            int type = event.getType();
            NodeId parentId = event.getParentId();
            NodeEntry parent = parentId != null ? (NodeEntry)this.hierarchyMgr.lookup((ItemId)parentId) : null;
            switch (type) {
                case 2: 
                case 8: {
                    if (parent == null || removedEvents.contains(parentId)) continue block11;
                    parent.refresh(event);
                    continue block11;
                }
                case 16: {
                    if (parent == null) continue block11;
                    parent.refresh(event);
                    continue block11;
                }
                case 32: {
                    throw new UnsupportedOperationException("Implementation missing");
                }
                case 64: {
                    throw new UnsupportedOperationException("Implementation missing");
                }
            }
            throw new IllegalArgumentException("Invalid event type: " + event.getType());
        }
    }

    private static Collection<Event> getEventCollection(EventBundle eventBundle) {
        ArrayList<Event> evs = new ArrayList<Event>();
        Iterator it = eventBundle.getEvents();
        while (it.hasNext()) {
            evs.add((Event)it.next());
        }
        return evs;
    }
}

