/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SpecificInternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.plans.physical.HashPartitioning;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class BucketingUtils$ {
    public static BucketingUtils$ MODULE$;
    private final Regex bucketedFileName;
    private final String optionForHiveCompatibleBucketWrite;

    static {
        new BucketingUtils$();
    }

    private Regex bucketedFileName() {
        return this.bucketedFileName;
    }

    public String optionForHiveCompatibleBucketWrite() {
        return this.optionForHiveCompatibleBucketWrite;
    }

    public Option<Object> getBucketId(String fileName) {
        String string = fileName;
        Option option = this.bucketedFileName().unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String bucketId = (String)((LinearSeqOptimized)option.get()).apply(0);
            return new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(bucketId)).toInt()));
        }
        return None$.MODULE$;
    }

    public int getBucketIdFromValue(Attribute bucketColumn, int numBuckets, Object value) {
        SpecificInternalRow mutableInternalRow = new SpecificInternalRow((Seq)new .colon.colon((Object)bucketColumn.dataType(), (List)Nil$.MODULE$));
        mutableInternalRow.update(0, value);
        Expression expression = new HashPartitioning((Seq)new .colon.colon((Object)bucketColumn, (List)Nil$.MODULE$), numBuckets).partitionIdExpression();
        Attribute attribute = bucketColumn;
        UnsafeProjection bucketIdGenerator = UnsafeProjection$.MODULE$.create((Seq)Nil$.MODULE$.$colon$colon((Object)expression), (Seq)Nil$.MODULE$.$colon$colon((Object)attribute));
        return bucketIdGenerator.apply((InternalRow)mutableInternalRow).getInt(0);
    }

    public String bucketIdToString(int id) {
        int arg$macro$1 = id;
        return new StringOps("_%05d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$1)}));
    }

    private BucketingUtils$() {
        MODULE$ = this;
        this.bucketedFileName = new StringOps(Predef$.MODULE$.augmentString(".*_(\\d+)(?:\\..*)?$")).r();
        this.optionForHiveCompatibleBucketWrite = "__hive_compatible_bucketed_table_insertion__";
    }
}

