/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.common.util;

import java.io.Serializable;
import java.util.List;
import org.apache.streampark.common.util.RedisEndpoint;
import org.apache.streampark.common.util.RedisEndpoint$;
import org.apache.streampark.common.util.RedisNode;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.util.JedisClusterCRC16;
import redis.clients.jedis.util.SafeEncoder;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\u000b\u0017\u0001\u0005B\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0001\f\u0005\tc\u0001\u0011\t\u0011)A\u0005[!)!\u0007\u0001C\u0001g!9a\u0007\u0001b\u0001\n\u00039\u0004BB\"\u0001A\u0003%\u0001\bC\u0004E\u0001\t\u0007I\u0011A#\t\r1\u0003\u0001\u0015!\u0003G\u0011\u001di\u0005A1A\u0005\u0002\u0015CaA\u0014\u0001!\u0002\u00131\u0005\"B(\u0001\t\u00039\u0004\"\u0002)\u0001\t\u0003\t\u0006\"B+\u0001\t\u00031\u0006\"B,\u0001\t\u0003A\u0006\"B/\u0001\t\u0003q\u0006\"B6\u0001\t\u0013a\u0007\"B9\u0001\t\u0003\u0011\b\"\u0002;\u0001\t\u0013)\b\"B<\u0001\t\u0013A\b\"\u0002>\u0001\t\u0013Y\b\"B?\u0001\t\u0003q(a\u0003*fI&\u001c8i\u001c8gS\u001eT!a\u0006\r\u0002\tU$\u0018\u000e\u001c\u0006\u00033i\taaY8n[>t'BA\u000e\u001d\u0003)\u0019HO]3b[B\f'o\u001b\u0006\u0003;y\ta!\u00199bG\",'\"A\u0010\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0011\u0003\u0006\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0004B]f\u0014VM\u001a\t\u0003G%J!A\u000b\u0013\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0017%t\u0017\u000e^5bY\"{7\u000f^\u000b\u0002[A\u0011afL\u0007\u0002-%\u0011\u0001G\u0006\u0002\u000e%\u0016$\u0017n]#oIB|\u0017N\u001c;\u0002\u0019%t\u0017\u000e^5bY\"{7\u000f\u001e\u0011\u0002\rqJg.\u001b;?)\t!T\u0007\u0005\u0002/\u0001!)1f\u0001a\u0001[\u0005Y\u0011N\\5uS\u0006d\u0017\t\u001a3s+\u0005A\u0004CA\u001dA\u001d\tQd\b\u0005\u0002<I5\tAH\u0003\u0002>A\u00051AH]8pizJ!a\u0010\u0013\u0002\rA\u0013X\rZ3g\u0013\t\t%I\u0001\u0004TiJLgn\u001a\u0006\u0003\u007f\u0011\nA\"\u001b8ji&\fG.\u00113ee\u0002\nQ\u0001[8tiN,\u0012A\u0012\t\u0004G\u001dK\u0015B\u0001%%\u0005\u0015\t%O]1z!\tq#*\u0003\u0002L-\tI!+\u001a3jg:{G-Z\u0001\u0007Q>\u001cHo\u001d\u0011\u0002\u000b9|G-Z:\u0002\r9|G-Z:!\u0003\u001d9W\r^!vi\"\fQaZ3u\t\n+\u0012A\u0015\t\u0003GMK!\u0001\u0016\u0013\u0003\u0007%sG/A\u0007hKR\u0014\u0016M\u001c3p[:{G-Z\u000b\u0002\u0013\u0006yq-\u001a;O_\u0012,7OQ=TY>$8\u000fF\u0002G3nCQAW\u0007A\u0002I\u000bAa\u001d)pg\")A,\u0004a\u0001%\u0006!Q\rU8t\u0003A\u0019wN\u001c8fGRLwN\u001c$pe.+\u0017\u0010\u0006\u0002`SB\u0011\u0001mZ\u0007\u0002C*\u0011!mY\u0001\u0006U\u0016$\u0017n\u001d\u0006\u0003I\u0016\fqa\u00197jK:$8OC\u0001g\u0003\u0015\u0011X\rZ5t\u0013\tA\u0017MA\u0003KK\u0012L7\u000fC\u0003k\u001d\u0001\u0007\u0001(A\u0002lKf\fab\u00197vgR,'/\u00128bE2,G\r\u0006\u0002naB\u00111E\\\u0005\u0003_\u0012\u0012qAQ8pY\u0016\fg\u000eC\u0003,\u001f\u0001\u0007Q&A\u0004hKRDun\u001d;\u0015\u0005%\u001b\b\"\u00026\u0011\u0001\u0004A\u0014\u0001C4fi\"{7\u000f^:\u0015\u0005\u00193\b\"B\u0016\u0012\u0001\u0004i\u0013AE4fi:{gn\u00117vgR,'OT8eKN$\"AR=\t\u000b-\u0012\u0002\u0019A\u0017\u0002\u001f\u001d,Go\u00117vgR,'OT8eKN$\"A\u0012?\t\u000b-\u001a\u0002\u0019A\u0017\u0002\u0011\u001d,GOT8eKN$\"AR@\t\u000b-\"\u0002\u0019A\u0017")
public class RedisConfig
implements scala.Serializable {
    private final RedisEndpoint initialHost;
    private final String initialAddr;
    private final RedisNode[] hosts;
    private final RedisNode[] nodes;

    public RedisEndpoint initialHost() {
        return this.initialHost;
    }

    public String initialAddr() {
        return this.initialAddr;
    }

    public RedisNode[] hosts() {
        return this.hosts;
    }

    public RedisNode[] nodes() {
        return this.nodes;
    }

    public String getAuth() {
        return this.initialHost().auth();
    }

    public int getDB() {
        return this.initialHost().db();
    }

    public RedisNode getRandomNode() {
        int rnd = RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(Random$.MODULE$.nextInt())) % this.hosts().length;
        return this.hosts()[rnd];
    }

    public RedisNode[] getNodesBySlots(int sPos, int ePos) {
        return (RedisNode[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.nodes())).filter((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)RedisConfig.inter$1(sPos, ePos, node.startSlot(), node.endSlot()))))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RedisConfig.$anonfun$getNodesBySlots$2(x$1)));
    }

    public Jedis connectionForKey(String key) {
        return this.getHost(key).connect();
    }

    private boolean clusterEnabled(RedisEndpoint initialHost) {
        Jedis conn = initialHost.connect();
        String[] info = conn.info().split("\n");
        String version = ((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])info)).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains("redis_version:"))))[0];
        String[] clusterEnable = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])info)).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.contains("cluster_enabled:")));
        int mainVersion = new StringOps(Predef$.MODULE$.augmentString(version.substring(14, version.indexOf(".")))).toInt();
        boolean res = mainVersion > 2 && clusterEnable.length > 0 && clusterEnable[0].contains("1");
        conn.close();
        return res;
    }

    public RedisNode getHost(String key) {
        int slot = JedisClusterCRC16.getSlot((String)key);
        return ((RedisNode[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.hosts())).filter((Function1 & Serializable & scala.Serializable)host -> BoxesRunTime.boxToBoolean((boolean)RedisConfig.$anonfun$getHost$1(slot, host))))[0];
    }

    private RedisNode[] getHosts(RedisEndpoint initialHost) {
        return (RedisNode[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getNodes(initialHost))).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)RedisConfig.$anonfun$getHosts$1(x$4)));
    }

    private RedisNode[] getNonClusterNodes(RedisEndpoint initialHost) {
        String[] replinfo;
        Tuple2 master;
        while (true) {
            master = new Tuple2((Object)initialHost.host(), (Object)BoxesRunTime.boxToInteger((int)initialHost.port()));
            Jedis conn = initialHost.connect();
            replinfo = conn.info("Replication").split("\n");
            conn.close();
            if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])replinfo)).exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.contains("role:slave")))) break;
            String host = ((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])replinfo)).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.contains("master_host:"))))[0].trim().substring(12);
            int port = new StringOps(Predef$.MODULE$.augmentString(((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])replinfo)).filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.contains("master_port:"))))[0].trim().substring(12))).toInt();
            initialHost = new RedisEndpoint(host, port, initialHost.auth(), initialHost.db(), RedisEndpoint$.MODULE$.apply$default$5());
        }
        Tuple2[] slaves = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])replinfo)).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)RedisConfig.$anonfun$getNonClusterNodes$4(x))))).map((Function1 & Serializable & scala.Serializable)rl -> {
            String[] content = rl.substring(rl.indexOf(58) + 1).split(",");
            String ip = content[0];
            String port = content[1];
            return new Tuple2((Object)ip.substring(ip.indexOf(61) + 1), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(port.substring(port.indexOf(61) + 1))).toInt()));
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        Tuple2 tuple2 = master;
        Tuple2[] nodes = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])slaves)).$plus$colon((Object)tuple2, ClassTag$.MODULE$.apply(Tuple2.class));
        int range = nodes.length;
        return (RedisNode[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), range).map((Function1 & Serializable & scala.Serializable)i -> RedisConfig.$anonfun$getNonClusterNodes$6(nodes, initialHost, range, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(RedisNode.class));
    }

    /*
     * WARNING - void declaration
     */
    private RedisNode[] getClusterNodes(RedisEndpoint initialHost) {
        void var3_3;
        Jedis conn = initialHost.connect();
        RedisNode[] res = (RedisNode[])((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(conn.clusterSlots()).flatMap((Function1 & Serializable & scala.Serializable)slotInfoObj -> {
            List slotInfo = (List)slotInfoObj;
            int sPos = new StringOps(Predef$.MODULE$.augmentString(slotInfo.get(0).toString())).toInt();
            int ePos = new StringOps(Predef$.MODULE$.augmentString(slotInfo.get(1).toString())).toInt();
            return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), slotInfo.size() - 2).map((Function1 & Serializable & scala.Serializable)i -> RedisConfig.$anonfun$getClusterNodes$2(slotInfo, initialHost, sPos, ePos, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(RedisNode.class));
        conn.close();
        return var3_3;
    }

    public RedisNode[] getNodes(RedisEndpoint initialHost) {
        return this.clusterEnabled(initialHost) ? this.getClusterNodes(initialHost) : this.getNonClusterNodes(initialHost);
    }

    private static final boolean inter$1(int sPos1, int ePos1, int sPos2, int ePos2) {
        return sPos1 <= sPos2 ? ePos1 >= sPos2 : ePos2 >= sPos1;
    }

    public static final /* synthetic */ boolean $anonfun$getNodesBySlots$2(RedisNode x$1) {
        return x$1.idx() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$getHost$1(int slot$1, RedisNode host) {
        return host.startSlot() <= slot$1 && host.endSlot() >= slot$1;
    }

    public static final /* synthetic */ boolean $anonfun$getHosts$1(RedisNode x$4) {
        return x$4.idx() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$getNonClusterNodes$4(String x) {
        return x.contains("slave") && x.contains("online");
    }

    public static final /* synthetic */ RedisNode $anonfun$getNonClusterNodes$6(Tuple2[] nodes$1, RedisEndpoint initialHost$1, int range$1, int i) {
        return new RedisNode(new RedisEndpoint((String)nodes$1[i]._1(), nodes$1[i]._2$mcI$sp(), initialHost$1.auth(), initialHost$1.db(), initialHost$1.timeout()), 0, 16383, i, range$1);
    }

    public static final /* synthetic */ RedisNode $anonfun$getClusterNodes$2(List slotInfo$1, RedisEndpoint initialHost$2, int sPos$2, int ePos$2, int i) {
        List node = (List)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(slotInfo$1).apply(i + 2);
        String host = SafeEncoder.encode((byte[])((byte[])node.get(0)));
        int port = new StringOps(Predef$.MODULE$.augmentString(node.get(1).toString())).toInt();
        return new RedisNode(new RedisEndpoint(host, port, initialHost$2.auth(), initialHost$2.db(), initialHost$2.timeout()), sPos$2, ePos$2, i, slotInfo$1.size() - 2);
    }

    public RedisConfig(RedisEndpoint initialHost) {
        this.initialHost = initialHost;
        this.initialAddr = initialHost.host();
        this.hosts = this.getHosts(initialHost);
        this.nodes = this.getNodes(initialHost);
    }
}

