/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import java.net.URI;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.HttpHeadResponseDecorator;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.mock.http.client.reactive.MockClientHttpRequest;
import org.springframework.mock.http.client.reactive.MockClientHttpResponse;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.http.server.reactive.MockServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Schedulers;

public class HttpHandlerConnector
implements ClientHttpConnector {
    private static final Log logger = LogFactory.getLog(HttpHandlerConnector.class);
    private final HttpHandler handler;

    public HttpHandlerConnector(HttpHandler handler) {
        Assert.notNull((Object)handler, (String)"HttpHandler is required");
        this.handler = handler;
    }

    public Mono<ClientHttpResponse> connect(HttpMethod httpMethod, URI uri, Function<? super ClientHttpRequest, Mono<Void>> requestCallback) {
        return Mono.defer(() -> this.doConnect(httpMethod, uri, requestCallback)).subscribeOn(Schedulers.parallel());
    }

    private Mono<ClientHttpResponse> doConnect(HttpMethod httpMethod, URI uri, Function<? super ClientHttpRequest, Mono<Void>> requestCallback) {
        Sinks.Empty requestWriteSink = Sinks.unsafe().empty();
        Sinks.Empty handlerSink = Sinks.unsafe().empty();
        ClientHttpResponse[] savedResponse = new ClientHttpResponse[1];
        MockClientHttpRequest mockClientRequest = new MockClientHttpRequest(httpMethod, uri);
        MockServerHttpResponse mockServerResponse = new MockServerHttpResponse();
        mockClientRequest.setWriteHandler(requestBody -> {
            this.log("Invoking HttpHandler for ", httpMethod, uri);
            ServerHttpRequest mockServerRequest = this.adaptRequest(mockClientRequest, (Publisher<DataBuffer>)requestBody);
            ServerHttpResponse responseToUse = this.prepareResponse((ServerHttpResponse)mockServerResponse, mockServerRequest);
            this.handler.handle(mockServerRequest, responseToUse).subscribe(aVoid -> {}, arg_0 -> ((Sinks.Empty)handlerSink).tryEmitError(arg_0), () -> ((Sinks.Empty)handlerSink).tryEmitEmpty());
            return Mono.empty();
        });
        mockServerResponse.setWriteHandler(responseBody -> Mono.fromRunnable(() -> {
            this.log("Creating client response for ", httpMethod, uri);
            savedResponse[0] = this.adaptResponse(mockServerResponse, (Flux<DataBuffer>)responseBody);
        }));
        this.log("Writing client request for ", httpMethod, uri);
        requestCallback.apply((ClientHttpRequest)mockClientRequest).subscribe(aVoid -> {}, arg_0 -> ((Sinks.Empty)requestWriteSink).tryEmitError(arg_0), () -> ((Sinks.Empty)requestWriteSink).tryEmitEmpty());
        return Mono.when((Publisher[])new Publisher[]{requestWriteSink.asMono(), handlerSink.asMono()}).onErrorMap(ex -> {
            ClientHttpResponse response = savedResponse[0];
            return response != null ? new FailureAfterResponseCompletedException(response, (Throwable)ex) : ex;
        }).then(Mono.fromCallable(() -> savedResponse[0] != null ? savedResponse[0] : this.adaptResponse(mockServerResponse, (Flux<DataBuffer>)Flux.empty())));
    }

    private void log(String message, HttpMethod httpMethod, URI uri) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("%s %s \"%s\"", message, httpMethod, uri));
        }
    }

    private ServerHttpRequest adaptRequest(MockClientHttpRequest request2, Publisher<DataBuffer> body2) {
        HttpMethod method = request2.getMethod();
        URI uri = request2.getURI();
        HttpHeaders headers = request2.getHeaders();
        MultiValueMap cookies = request2.getCookies();
        return ((MockServerHttpRequest.BodyBuilder)((MockServerHttpRequest.BodyBuilder)MockServerHttpRequest.method(method, uri).headers((MultiValueMap<String, String>)headers)).cookies((MultiValueMap<String, HttpCookie>)cookies)).body(body2);
    }

    private ServerHttpResponse prepareResponse(ServerHttpResponse response, ServerHttpRequest request2) {
        return request2.getMethod() == HttpMethod.HEAD ? new HttpHeadResponseDecorator(response) : response;
    }

    private ClientHttpResponse adaptResponse(MockServerHttpResponse response, Flux<DataBuffer> body2) {
        HttpStatusCode status = response.getStatusCode();
        MockClientHttpResponse clientResponse = new MockClientHttpResponse((HttpStatusCode)(status != null ? status : HttpStatus.OK));
        clientResponse.getHeaders().putAll((Map)response.getHeaders());
        clientResponse.getCookies().putAll((Map)response.getCookies());
        clientResponse.setBody((Publisher<DataBuffer>)body2);
        return clientResponse;
    }

    public static final class FailureAfterResponseCompletedException
    extends RuntimeException {
        private final ClientHttpResponse completedResponse;

        private FailureAfterResponseCompletedException(ClientHttpResponse response, Throwable cause) {
            super("Error occurred after response was completed: " + String.valueOf(response), cause);
            this.completedResponse = response;
        }

        public ClientHttpResponse getCompletedResponse() {
            return this.completedResponse;
        }
    }
}

